/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.datasource.AbstractChainedSource;
import org.ethereum.datasource.Serializer;
import org.ethereum.datasource.Serializers;
import org.ethereum.datasource.Source;

public class SourceCodec<Key, Value, SourceKey, SourceValue>
extends AbstractChainedSource<Key, Value, SourceKey, SourceValue> {
    protected Serializer<Key, SourceKey> keySerializer;
    protected Serializer<Value, SourceValue> valSerializer;

    public SourceCodec(Source<SourceKey, SourceValue> src, Serializer<Key, SourceKey> keySerializer, Serializer<Value, SourceValue> valSerializer) {
        super(src);
        this.keySerializer = keySerializer;
        this.valSerializer = valSerializer;
        this.setFlushSource(true);
    }

    @Override
    public void put(Key key, Value val) {
        this.getSource().put(this.keySerializer.serialize(key), this.valSerializer.serialize(val));
    }

    @Override
    public Value get(Key key) {
        return this.valSerializer.deserialize(this.getSource().get(this.keySerializer.serialize(key)));
    }

    @Override
    public void delete(Key key) {
        this.getSource().delete(this.keySerializer.serialize(key));
    }

    @Override
    public boolean flushImpl() {
        return false;
    }

    public static class BytesKey<Value, SourceValue>
    extends ValueOnly<byte[], Value, SourceValue> {
        public BytesKey(Source<byte[], SourceValue> src, Serializer<Value, SourceValue> valSerializer) {
            super(src, valSerializer);
        }
    }

    public static class KeyOnly<Key, Value, SourceKey>
    extends SourceCodec<Key, Value, SourceKey, Value> {
        public KeyOnly(Source<SourceKey, Value> src, Serializer<Key, SourceKey> keySerializer) {
            super(src, keySerializer, new Serializers.Identity());
        }
    }

    public static class ValueOnly<Key, Value, SourceValue>
    extends SourceCodec<Key, Value, Key, SourceValue> {
        public ValueOnly(Source<Key, SourceValue> src, Serializer<Value, SourceValue> valSerializer) {
            super(src, new Serializers.Identity(), valSerializer);
        }
    }
}

