/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import com.googlecode.concurentlocks.ReadWriteUpdateLock;
import com.googlecode.concurentlocks.ReentrantReadWriteUpdateLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.CachedSource;
import org.ethereum.datasource.Source;
import org.ethereum.util.ALock;
import org.ethereum.util.ByteArrayMap;

public class WriteCache<Key, Value>
extends AbstractCachedSource<Key, Value> {
    private final boolean isCounting;
    protected volatile Map<Key, CacheEntry<Value>> cache = new HashMap<Key, CacheEntry<Value>>();
    protected ReadWriteUpdateLock rwuLock = new ReentrantReadWriteUpdateLock();
    protected ALock readLock = new ALock(this.rwuLock.readLock());
    protected ALock writeLock = new ALock(this.rwuLock.writeLock());
    protected ALock updateLock = new ALock(this.rwuLock.updateLock());
    private boolean checked = false;

    public WriteCache(Source<Key, Value> src, CacheType cacheType) {
        super(src);
        this.isCounting = cacheType == CacheType.COUNTING;
    }

    public WriteCache<Key, Value> withCache(Map<Key, CacheEntry<Value>> cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public Collection<Key> getModified() {
        try (ALock l = this.readLock.lock();){
            Set<Key> set = this.cache.keySet();
            return set;
        }
    }

    @Override
    public boolean hasModified() {
        return !this.cache.isEmpty();
    }

    private CacheEntry<Value> createCacheEntry(Value val) {
        if (this.isCounting) {
            return new CountCacheEntry<Value>(val);
        }
        return new SimpleCacheEntry<Value>(val);
    }

    @Override
    public void put(Key key, Value val) {
        this.checkByteArrKey(key);
        if (val == null) {
            this.delete(key);
            return;
        }
        try (ALock l = this.writeLock.lock();){
            CacheEntry<Value> curVal = this.cache.get(key);
            if (curVal == null) {
                curVal = this.createCacheEntry(val);
                CacheEntry<Value> oldVal = this.cache.put(key, curVal);
                if (oldVal != null) {
                    this.cacheRemoved(key, oldVal.value == this.unknownValue() ? null : (Object)oldVal.value);
                }
                this.cacheAdded(key, curVal.value);
            }
            curVal.value = val;
            curVal.added();
        }
    }

    @Override
    public Value get(Key key) {
        this.checkByteArrKey(key);
        try (ALock l = this.readLock.lock();){
            CacheEntry<Value> curVal = this.cache.get(key);
            if (curVal == null) {
                Value Value2 = this.getSource() == null ? null : (Value)this.getSource().get(key);
                return Value2;
            }
            Value value = curVal.getValue();
            if (value == this.unknownValue()) {
                Value Value3 = this.getSource() == null ? null : (Value)this.getSource().get(key);
                return Value3;
            }
            Value Value4 = value;
            return Value4;
        }
    }

    @Override
    public void delete(Key key) {
        this.checkByteArrKey(key);
        try (ALock l = this.writeLock.lock();){
            CacheEntry<Object> curVal = this.cache.get(key);
            if (curVal == null) {
                curVal = this.createCacheEntry(this.getSource() == null ? null : (Value)this.unknownValue());
                CacheEntry<Value> oldVal = this.cache.put(key, curVal);
                if (oldVal != null) {
                    this.cacheRemoved(key, oldVal.value);
                }
                this.cacheAdded(key, curVal.value == this.unknownValue() ? null : (Object)curVal.value);
            }
            curVal.deleted();
        }
    }

    @Override
    public boolean flush() {
        boolean ret = false;
        try (ALock l = this.updateLock.lock();){
            for (Map.Entry<Key, CacheEntry<Value>> entry : this.cache.entrySet()) {
                int i;
                if (entry.getValue().counter > 0) {
                    for (i = 0; i < entry.getValue().counter; ++i) {
                        this.getSource().put(entry.getKey(), entry.getValue().value);
                    }
                    ret = true;
                    continue;
                }
                if (entry.getValue().counter >= 0) continue;
                for (i = 0; i > entry.getValue().counter; --i) {
                    this.getSource().delete(entry.getKey());
                }
                ret = true;
            }
            if (this.flushSource) {
                this.getSource().flush();
            }
            try (ALock l1 = this.writeLock.lock();){
                this.cache.clear();
                this.cacheCleared();
            }
            boolean bl = ret;
            return bl;
        }
    }

    @Override
    protected boolean flushImpl() {
        return false;
    }

    private Value unknownValue() {
        return (Value)CacheEntry.UNKNOWN_VALUE;
    }

    @Override
    public AbstractCachedSource.Entry<Value> getCached(Key key) {
        try (ALock l = this.readLock.lock();){
            CacheEntry<Value> entry = this.cache.get(key);
            if (entry == null || entry.value == this.unknownValue()) {
                AbstractCachedSource.Entry<Value> entry2 = null;
                return entry2;
            }
            CacheEntry<Value> cacheEntry = entry;
            return cacheEntry;
        }
    }

    private void checkByteArrKey(Key key) {
        if (this.checked) {
            return;
        }
        if (key instanceof byte[] && !(this.cache instanceof ByteArrayMap)) {
            throw new RuntimeException("Wrong map/set for byte[] key");
        }
        this.checked = true;
    }

    public long debugCacheSize() {
        long ret = 0L;
        for (Map.Entry<Key, CacheEntry<Value>> entry : this.cache.entrySet()) {
            ret += this.keySizeEstimator.estimateSize(entry.getKey());
            ret += this.valueSizeEstimator.estimateSize(entry.getValue().value());
        }
        return ret;
    }

    public static class BytesKey<V>
    extends WriteCache<byte[], V>
    implements CachedSource.BytesKey<V> {
        public BytesKey(Source<byte[], V> src, CacheType cacheType) {
            super(src, cacheType);
            this.withCache(new ByteArrayMap());
        }
    }

    private static final class CountCacheEntry<V>
    extends CacheEntry<V> {
        public CountCacheEntry(V value) {
            super(value);
        }

        @Override
        public void deleted() {
            --this.counter;
        }

        @Override
        public void added() {
            ++this.counter;
        }

        @Override
        public V getValue() {
            return (V)this.value;
        }
    }

    private static final class SimpleCacheEntry<V>
    extends CacheEntry<V> {
        public SimpleCacheEntry(V value) {
            super(value);
        }

        @Override
        public void deleted() {
            this.counter = -1;
        }

        @Override
        public void added() {
            this.counter = 1;
        }

        @Override
        public V getValue() {
            return (V)(this.counter < 0 ? null : this.value);
        }
    }

    private static abstract class CacheEntry<V>
    implements AbstractCachedSource.Entry<V> {
        static final Object UNKNOWN_VALUE = new Object();
        V value;
        int counter = 0;

        protected CacheEntry(V value) {
            this.value = value;
        }

        protected abstract void deleted();

        protected abstract void added();

        protected abstract V getValue();

        @Override
        public V value() {
            V v = this.getValue();
            return v == UNKNOWN_VALUE ? null : (V)v;
        }
    }

    public static enum CacheType {
        SIMPLE,
        COUNTING;

    }
}

