/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource.rocksdb;

import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.util.Log;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rockdb.util.DBUtils;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.ArrayUtils;
import org.ethereum.config.SystemProperties;
import org.ethereum.datasource.DbSettings;
import org.ethereum.datasource.DbSource;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbDataSource
implements DbSource<byte[]> {
    private static final Logger logger = LoggerFactory.getLogger((String)"db");
    private String AREA;
    SystemProperties config = SystemProperties.getDefault();
    String name;
    boolean alive;
    RocksDB rocksDB;
    DbSettings settings = DbSettings.DEFAULT;
    private ReadWriteLock resetDbLock = new ReentrantReadWriteLock();

    public RocksDbDataSource() {
    }

    public RocksDbDataSource(int chainId) {
        this.AREA = "contract_" + chainId;
    }

    public RocksDbDataSource(String name) {
        this.name = name;
        logger.debug("New RocksDbDataSource: " + name);
    }

    @Override
    public void init() {
        this.init(DbSettings.DEFAULT);
    }

    @Override
    public void init(DbSettings settings) {
        this.settings = settings;
        this.resetDbLock.writeLock().lock();
        try {
            if (this.isAlive()) {
                return;
            }
            if (this.name == null) {
                throw new NullPointerException("no name set to the db");
            }
            Object[] areas = RocksDBService.listTable();
            if (ArrayUtils.contains((Object[])areas, (Object)this.AREA)) {
                RocksDBManager.closeTable((String)this.AREA);
            }
            this.rocksDB = this.createTable(this.AREA);
            this.alive = true;
        }
        catch (Exception e) {
            logger.error("RocksDbDataSource.init() error", (Throwable)e);
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    private RocksDB createTable(String area) {
        try {
            if (StringUtils.isBlank((String)area)) {
                throw new RuntimeException("empty area");
            }
            NulsCoresConfig contractConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
            Object dataPath = contractConfig.getDataPath();
            File pathDir = DBUtils.loadDataPath((String)dataPath);
            dataPath = pathDir.getPath();
            File dir = new File((String)(dataPath = (String)dataPath + File.separator + "smart-contract") + File.separator + area);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dataPath = (String)dataPath + File.separator + area + File.separator + "rocksdb";
            Options options = new Options();
            options.setCreateIfMissing(true);
            options.setAllowMmapReads(true);
            options.setCompressionType(CompressionType.NO_COMPRESSION);
            options.setMaxOpenFiles(-1);
            BlockBasedTableConfig tableOption = new BlockBasedTableConfig();
            tableOption.setBlockCache((Cache)new LRUCache(0x2000000L));
            tableOption.setCacheIndexAndFilterBlocks(true);
            tableOption.setPinL0FilterAndIndexBlocksInCache(true);
            tableOption.setBlockRestartInterval(4);
            tableOption.setFilterPolicy((Filter)new BloomFilter(10, true));
            options.setTableFormatConfig((TableFormatConfig)tableOption);
            options.setNewTableReaderForCompactionInputs(true);
            options.setCompactionReadaheadSize(131072L);
            return RocksDB.open((Options)options, (String)dataPath);
        }
        catch (Exception e) {
            Log.error("error create table: " + area, e);
            throw new RuntimeException("error create table: " + area);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public byte[] prefixLookup(byte[] key, int prefixBytes) {
        throw new RuntimeException("RocksDbDataSource.prefixLookup() is not supported");
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) {
        this.resetDbLock.readLock().lock();
        try {
            byte[] ret;
            byte[] byArray = ret = this.rocksDB.get(key);
            return byArray;
        }
        catch (Exception e) {
            logger.warn("Exception. Retrying again...", (Throwable)e);
            byte[] ret = null;
            try {
                ret = this.rocksDB.get(key);
            }
            catch (RocksDBException rocksDBException) {
                // empty catch block
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(byte[] key, byte[] value) {
        this.resetDbLock.writeLock().lock();
        try {
            this.rocksDB.put(key, value);
        }
        catch (Exception e) {
            logger.error("RocksDbDataSource.put() error", (Throwable)e);
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    @Override
    public void delete(byte[] key) {
        this.resetDbLock.writeLock().lock();
        try {
            this.rocksDB.delete(key);
        }
        catch (Exception e) {
            Log.error("RocksDbDataSource.delete() error", e);
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    @Override
    public Set<byte[]> keys() {
        return null;
    }

    private void updateBatchInternal(Map<byte[], byte[]> rows) throws Exception {
        try (WriteBatch batch = null;){
            batch = new WriteBatch();
            Set<Map.Entry<byte[], byte[]>> entrySet = rows.entrySet();
            for (Map.Entry<byte[], byte[]> entry : entrySet) {
                if (entry.getValue() == null) {
                    batch.delete(entry.getKey());
                    continue;
                }
                batch.put(entry.getKey(), entry.getValue());
            }
            this.rocksDB.write(new WriteOptions(), batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBatch(Map<byte[], byte[]> rows) {
        this.resetDbLock.writeLock().lock();
        try {
            try {
                this.updateBatchInternal(rows);
            }
            catch (Exception e) {
                Log.error("Error, retrying one more time...", e);
                try {
                    this.updateBatchInternal(rows);
                }
                catch (Exception e1) {
                    Log.error("Error", e);
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    @Override
    public boolean flush() {
        return false;
    }

    @Override
    public void close() {
    }
}

