/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ethereum.config.SystemProperties;
import org.ethereum.datasource.AbstractCachedSource;
import org.ethereum.datasource.AsyncFlushable;
import org.ethereum.datasource.DbSource;
import org.ethereum.datasource.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbFlushManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"db");
    List<AbstractCachedSource<byte[], ?>> writeCaches = new CopyOnWriteArrayList();
    List<Source<byte[], ?>> sources = new CopyOnWriteArrayList();
    Set<DbSource> dbSources = new HashSet<DbSource>();
    AbstractCachedSource<byte[], byte[]> stateDbCache;
    long sizeThreshold;
    int commitsCountThreshold;
    boolean syncDone = false;
    boolean flushAfterSyncDone;
    SystemProperties config;
    int commitCount = 0;
    private final BlockingQueue<Runnable> executorQueue = new ArrayBlockingQueue<Runnable>(1);
    private final ExecutorService flushThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.executorQueue, new ThreadFactoryBuilder().setNameFormat("DbFlushManagerThread-%d").build());
    Future<Boolean> lastFlush = Futures.immediateFuture((Object)false);

    public DbFlushManager(SystemProperties config, Set<DbSource> dbSources, AbstractCachedSource<byte[], byte[]> stateDbCache) {
        this.config = config;
        this.dbSources = dbSources;
        this.sizeThreshold = (long)config.getConfig().getInt("cache.flush.writeCacheSize") * 1024L * 1024L;
        this.commitsCountThreshold = config.getConfig().getInt("cache.flush.blocks");
        this.flushAfterSyncDone = config.getConfig().getBoolean("cache.flush.shortSyncFlush");
        this.stateDbCache = stateDbCache;
    }

    public void setSizeThreshold(long sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public void addCache(AbstractCachedSource<byte[], ?> cache) {
        this.writeCaches.add(cache);
    }

    public void addSource(Source<byte[], ?> src) {
        this.sources.add(src);
    }

    public long getCacheSize() {
        long ret = 0L;
        for (AbstractCachedSource<byte[], ?> writeCache : this.writeCaches) {
            ret += writeCache.estimateCacheSize();
        }
        return ret;
    }

    public synchronized void commit(Runnable atomicUpdate) {
        atomicUpdate.run();
        this.commit();
    }

    public synchronized void commit() {
        long cacheSize = this.getCacheSize();
        if (this.sizeThreshold >= 0L && cacheSize >= this.sizeThreshold) {
            logger.debug("DbFlushManager: flushing db due to write cache size (" + cacheSize + ") reached threshold (" + this.sizeThreshold + ")");
            this.flush();
        } else if (this.commitsCountThreshold > 0 && this.commitCount >= this.commitsCountThreshold) {
            logger.debug("DbFlushManager: flushing db due to commits (" + this.commitCount + ") reached threshold (" + this.commitsCountThreshold + ")");
            this.flush();
            this.commitCount = 0;
        } else if (this.flushAfterSyncDone && this.syncDone) {
            logger.debug("DbFlushManager: flushing db due to short sync");
            this.flush();
        }
        ++this.commitCount;
    }

    public synchronized void flushSync() {
        try {
            this.flush().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Future<Boolean> flush() {
        if (!this.lastFlush.isDone()) {
            logger.debug("Waiting for previous flush to complete...");
            try {
                this.lastFlush.get();
            }
            catch (Exception e) {
                logger.error("Error during last flush", (Throwable)e);
            }
        }
        logger.debug("Flipping async storages");
        for (AbstractCachedSource<byte[], ?> writeCache : this.writeCaches) {
            try {
                if (!(writeCache instanceof AsyncFlushable)) continue;
                ((AsyncFlushable)((Object)writeCache)).flipStorage();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        logger.debug("Submitting flush task");
        this.lastFlush = this.flushThread.submit(() -> {
            boolean ret = false;
            long s = System.nanoTime();
            logger.debug("Flush started");
            this.sources.forEach(Source::flush);
            for (AbstractCachedSource<byte[], ?> writeCache : this.writeCaches) {
                if (writeCache instanceof AsyncFlushable) {
                    try {
                        ret |= ((Boolean)((AsyncFlushable)((Object)writeCache)).flushAsync().get()).booleanValue();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
                ret |= writeCache.flush();
            }
            if (this.stateDbCache != null) {
                logger.debug("Flushing to DB");
                this.stateDbCache.flush();
            }
            logger.debug("Flush completed in " + (System.nanoTime() - s) / 1000000L + " ms");
            return ret;
        });
        return this.lastFlush;
    }

    public synchronized void close() {
        logger.debug("Flushing DBs...");
        this.flushSync();
        logger.debug("Flush done.");
        for (DbSource dbSource : this.dbSources) {
            logger.debug("Closing DB: {}", (Object)dbSource.getName());
            try {
                dbSource.close();
            }
            catch (Exception ex) {
                logger.error(String.format("Caught error while closing DB: %s", dbSource.getName()), (Throwable)ex);
            }
        }
    }
}

