/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.db;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.ethereum.core.AccountState;
import org.ethereum.core.Block;
import org.ethereum.core.Repository;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.db.ContractDetails;
import org.ethereum.vm.DataWord;

public class RepositoryWrapper
implements Repository {
    private Repository repository;

    public RepositoryWrapper(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public AccountState createAccount(byte[] addr, byte[] creater) {
        return this.getRepository().createAccount(addr, creater);
    }

    @Override
    public boolean isExist(byte[] addr) {
        return this.getRepository().isExist(addr);
    }

    @Override
    public AccountState getAccountState(byte[] addr) {
        return this.getRepository().getAccountState(addr);
    }

    @Override
    public void delete(byte[] addr) {
        this.getRepository().delete(addr);
    }

    @Override
    public BigInteger increaseNonce(byte[] addr) {
        return this.getRepository().increaseNonce(addr);
    }

    @Override
    public BigInteger setNonce(byte[] addr, BigInteger nonce) {
        return this.getRepository().setNonce(addr, nonce);
    }

    @Override
    public BigInteger getNonce(byte[] addr) {
        return this.getRepository().getNonce(addr);
    }

    @Override
    public ContractDetails getContractDetails(byte[] addr) {
        return this.getRepository().getContractDetails(addr);
    }

    @Override
    public boolean hasContractDetails(byte[] addr) {
        return this.getRepository().hasContractDetails(addr);
    }

    @Override
    public void saveCode(byte[] addr, byte[] code) {
        this.getRepository().saveCode(addr, code);
    }

    @Override
    public byte[] getCode(byte[] addr) {
        return this.getRepository().getCode(addr);
    }

    @Override
    public byte[] getCodeHash(byte[] addr) {
        return this.getRepository().getCodeHash(addr);
    }

    @Override
    public void addStorageRow(byte[] addr, DataWord key, DataWord value) {
        this.getRepository().addStorageRow(addr, key, value);
    }

    @Override
    public DataWord getStorageValue(byte[] addr, DataWord key) {
        return this.getRepository().getStorageValue(addr, key);
    }

    @Override
    public BigInteger getBalance(byte[] addr) {
        return this.getRepository().getBalance(addr);
    }

    @Override
    public BigInteger addBalance(byte[] addr, BigInteger value) {
        return this.getRepository().addBalance(addr, value);
    }

    @Override
    public Set<byte[]> getAccountsKeys() {
        return this.getRepository().getAccountsKeys();
    }

    @Override
    public void dumpState(Block block, long gasUsed, int txNumber, byte[] txHash) {
        this.getRepository().dumpState(block, gasUsed, txNumber, txHash);
    }

    @Override
    public Repository startTracking() {
        return this.getRepository().startTracking();
    }

    @Override
    public void flush() {
        this.getRepository().flush();
    }

    @Override
    public void flushNoReconnect() {
        this.getRepository().flushNoReconnect();
    }

    @Override
    public void commit() {
        this.getRepository().commit();
    }

    @Override
    public void rollback() {
        this.getRepository().rollback();
    }

    @Override
    public void syncToRoot(byte[] root) {
        this.getRepository().syncToRoot(root);
    }

    @Override
    public boolean isClosed() {
        return this.getRepository().isClosed();
    }

    @Override
    public void close() {
        this.getRepository().close();
    }

    @Override
    public void reset() {
        this.getRepository().reset();
    }

    @Override
    public void updateBatch(HashMap<ByteArrayWrapper, AccountState> accountStates, HashMap<ByteArrayWrapper, ContractDetails> contractDetailes) {
        this.getRepository().updateBatch(accountStates, contractDetailes);
    }

    @Override
    public byte[] getRoot() {
        return this.getRepository().getRoot();
    }

    @Override
    public void loadAccount(byte[] addr, HashMap<ByteArrayWrapper, AccountState> cacheAccounts, HashMap<ByteArrayWrapper, ContractDetails> cacheDetails) {
        this.getRepository().loadAccount(addr, cacheAccounts, cacheDetails);
    }

    @Override
    public Repository getSnapshotTo(byte[] root) {
        return this.getRepository().getSnapshotTo(root);
    }

    @Override
    public Repository clone() {
        return this.getSnapshotTo(this.getRoot());
    }

    @Override
    public int getStorageSize(byte[] addr) {
        return this.getRepository().getStorageSize(addr);
    }

    @Override
    public Set<DataWord> getStorageKeys(byte[] addr) {
        return this.getRepository().getStorageKeys(addr);
    }

    @Override
    public Map<DataWord, DataWord> getStorage(byte[] addr, @Nullable Collection<DataWord> keys) {
        return this.getRepository().getStorage(addr, keys);
    }
}

