/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.trie;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.nuls.core.crypto.HexUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.ethereum.crypto.HashUtil;
import org.ethereum.datasource.Source;
import org.ethereum.datasource.inmem.HashMapDB;
import org.ethereum.trie.Trie;
import org.ethereum.trie.TrieKey;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.FastByteComparisons;
import org.ethereum.util.RLP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrieImpl
implements Trie<byte[]> {
    private static final Object NULL_NODE = new Object();
    private static final int MIN_BRANCHES_CONCURRENTLY = 3;
    private static ExecutorService executor;
    private static final Logger logger;
    private Source<byte[], byte[]> cache;
    private Node root;
    private boolean async = true;

    public static ExecutorService getExecutor() {
        if (executor == null) {
            executor = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("trie-calc-thread-%d").build());
        }
        return executor;
    }

    public TrieImpl() {
        this((byte[])null);
    }

    public TrieImpl(byte[] root) {
        this(new HashMapDB<byte[]>(), root);
    }

    public TrieImpl(Source<byte[], byte[]> cache) {
        this(cache, null);
    }

    public TrieImpl(Source<byte[], byte[]> cache, byte[] root) {
        this.cache = cache;
        this.setRoot(root);
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    private void encode() {
        if (this.root != null) {
            this.root.encode();
        }
    }

    @Override
    public void setRoot(byte[] root) {
        this.root = root != null && !FastByteComparisons.equal(root, HashUtil.EMPTY_TRIE_HASH) ? new Node(root) : null;
    }

    private boolean hasRoot() {
        return this.root != null && this.root.resolveCheck();
    }

    public Source<byte[], byte[]> getCache() {
        return this.cache;
    }

    private byte[] getHash(byte[] hash) {
        return this.cache.get(hash);
    }

    private void addHash(byte[] hash, byte[] ret) {
        this.cache.put(hash, ret);
    }

    private void deleteHash(byte[] hash) {
        this.cache.delete(hash);
    }

    @Override
    public byte[] get(byte[] key) {
        if (!this.hasRoot()) {
            return null;
        }
        TrieKey k = TrieKey.fromNormal(key);
        return this.get(this.root, k);
    }

    private byte[] get(Node n, TrieKey k) {
        if (n == null) {
            return null;
        }
        NodeType type = n.getType();
        if (type == NodeType.BranchNode) {
            if (k.isEmpty()) {
                return n.branchNodeGetValue();
            }
            Node childNode = n.branchNodeGetChild(k.getHex(0));
            return this.get(childNode, k.shift(1));
        }
        TrieKey k1 = k.matchAndShift(n.kvNodeGetKey());
        if (k1 == null) {
            return null;
        }
        if (type == NodeType.KVNodeValue) {
            return k1.isEmpty() ? n.kvNodeGetValue() : null;
        }
        return this.get(n.kvNodeGetChildNode(), k1);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        TrieKey k = TrieKey.fromNormal(key);
        if (this.root == null) {
            if (value != null && value.length > 0) {
                this.root = new Node(k, value);
            }
        } else {
            this.root = value == null || value.length == 0 ? this.delete(this.root, k) : this.insert(this.root, k, value);
        }
    }

    private Node insert(Node n, TrieKey k, Object nodeOrValue) {
        NodeType type = n.getType();
        if (type == NodeType.BranchNode) {
            if (k.isEmpty()) {
                return n.branchNodeSetValue((byte[])nodeOrValue);
            }
            Node childNode = n.branchNodeGetChild(k.getHex(0));
            if (childNode != null) {
                return n.branchNodeSetChild(k.getHex(0), this.insert(childNode, k.shift(1), nodeOrValue));
            }
            TrieKey childKey = k.shift(1);
            Node newChildNode = !childKey.isEmpty() ? new Node(childKey, nodeOrValue) : (nodeOrValue instanceof Node ? (Node)nodeOrValue : new Node(childKey, nodeOrValue));
            return n.branchNodeSetChild(k.getHex(0), newChildNode);
        }
        TrieKey currentNodeKey = n.kvNodeGetKey();
        TrieKey commonPrefix = k.getCommonPrefix(currentNodeKey);
        if (commonPrefix.isEmpty()) {
            Node newBranchNode = new Node();
            this.insert(newBranchNode, currentNodeKey, n.kvNodeGetValueOrNode());
            this.insert(newBranchNode, k, nodeOrValue);
            n.dispose();
            return newBranchNode;
        }
        if (commonPrefix.equals(k)) {
            return n.kvNodeSetValueOrNode(nodeOrValue);
        }
        if (commonPrefix.equals(currentNodeKey)) {
            this.insert(n.kvNodeGetChildNode(), k.shift(commonPrefix.getLength()), nodeOrValue);
            return n.invalidate();
        }
        Node newBranchNode = new Node();
        Node newKvNode = new Node(commonPrefix, newBranchNode);
        this.insert(newKvNode, currentNodeKey, n.kvNodeGetValueOrNode());
        this.insert(newKvNode, k, nodeOrValue);
        n.dispose();
        return newKvNode;
    }

    @Override
    public void delete(byte[] key) {
        TrieKey k = TrieKey.fromNormal(key);
        if (this.root != null) {
            this.root = this.delete(this.root, k);
        }
    }

    private Node delete(Node n, TrieKey k) {
        Node newKvNode;
        Node newNode;
        NodeType type = n.getType();
        if (type == NodeType.BranchNode) {
            if (k.isEmpty()) {
                n.branchNodeSetValue(null);
            } else {
                int idx = k.getHex(0);
                Node child = n.branchNodeGetChild(idx);
                if (child == null) {
                    return n;
                }
                newNode = this.delete(child, k.shift(1));
                n.branchNodeSetChild(idx, newNode);
                if (newNode != null) {
                    return n;
                }
            }
            int compactIdx = n.branchNodeCompactIdx();
            if (compactIdx < 0) {
                return n;
            }
            n.dispose();
            if (compactIdx == 16) {
                return new Node(TrieKey.empty(true), n.branchNodeGetValue());
            }
            newKvNode = new Node(TrieKey.singleHex(compactIdx), n.branchNodeGetChild(compactIdx));
        } else {
            TrieKey k1 = k.matchAndShift(n.kvNodeGetKey());
            if (k1 == null) {
                return n;
            }
            if (type == NodeType.KVNodeValue) {
                if (k1.isEmpty()) {
                    n.dispose();
                    return null;
                }
                return n;
            }
            Node newChild = this.delete(n.kvNodeGetChildNode(), k1);
            if (newChild == null) {
                throw new RuntimeException("Shouldn't happen");
            }
            newKvNode = n.kvNodeSetValueOrNode(newChild);
        }
        Node newChild = newKvNode.kvNodeGetChildNode();
        if (newChild.getType() != NodeType.BranchNode) {
            TrieKey newKey = newKvNode.kvNodeGetKey().concat(newChild.kvNodeGetKey());
            newNode = new Node(newKey, newChild.kvNodeGetValueOrNode());
            newChild.dispose();
            newKvNode.dispose();
            return newNode;
        }
        return newKvNode;
    }

    @Override
    public byte[] getRootHash() {
        this.encode();
        return this.root != null ? this.root.hash : HashUtil.EMPTY_TRIE_HASH;
    }

    @Override
    public void clear() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean flush() {
        if (this.root != null && this.root.dirty) {
            this.encode();
            this.root = new Node(this.root.hash);
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrieImpl trieImpl1 = (TrieImpl)o;
        return FastByteComparisons.equal(this.getRootHash(), trieImpl1.getRootHash());
    }

    public String dumpStructure() {
        return this.root == null ? "<empty>" : this.root.dumpStruct("", "");
    }

    public String dumpTrie() {
        return this.dumpTrie(true);
    }

    public String dumpTrie(boolean compact) {
        if (this.root == null) {
            return "<empty>";
        }
        this.encode();
        StringBuilder ret = new StringBuilder();
        List<String> strings = this.root.dumpTrieNode(compact);
        ret.append("Root: " + TrieImpl.hash2str(this.getRootHash(), compact) + "\n");
        for (String s : strings) {
            ret.append(s).append('\n');
        }
        return ret.toString();
    }

    public void scanTree(ScanAction scanAction) {
        this.scanTree(this.root, TrieKey.empty(false), scanAction);
    }

    public void scanTree(Node node, TrieKey k, ScanAction scanAction) {
        if (node == null) {
            return;
        }
        if (node.hash != null) {
            scanAction.doOnNode(node.hash, node);
        }
        if (node.getType() == NodeType.BranchNode) {
            if (node.branchNodeGetValue() != null) {
                scanAction.doOnValue(node.hash, node, k.toNormal(), node.branchNodeGetValue());
            }
            for (int i = 0; i < 16; ++i) {
                this.scanTree(node.branchNodeGetChild(i), k.concat(TrieKey.singleHex(i)), scanAction);
            }
        } else if (node.getType() == NodeType.KVNodeNode) {
            this.scanTree(node.kvNodeGetChildNode(), k.concat(node.kvNodeGetKey()), scanAction);
        } else {
            scanAction.doOnValue(node.hash, node, k.concat(node.kvNodeGetKey()).toNormal(), node.kvNodeGetValue());
        }
    }

    private static String hash2str(byte[] hash, boolean shortHash) {
        String ret = HexUtil.encode((byte[])hash);
        return "0x" + (shortHash ? ret.substring(0, 8) : ret);
    }

    private static String val2str(byte[] val, boolean shortHash) {
        Object ret = HexUtil.encode((byte[])val);
        if (val.length > 16) {
            ret = ((String)ret).substring(0, 10) + "... len " + val.length;
        }
        return "\"" + (String)ret + "\"";
    }

    static {
        logger = LoggerFactory.getLogger((String)"state");
    }

    public static interface ScanAction {
        public void doOnNode(byte[] var1, Node var2);

        public void doOnValue(byte[] var1, Node var2, byte[] var3, byte[] var4);
    }

    public final class Node {
        private byte[] hash = null;
        private byte[] rlp = null;
        private RLP.LList parsedRlp = null;
        private boolean dirty = false;
        private Object[] children = null;

        public Node() {
            this.children = new Object[17];
            this.dirty = true;
        }

        public Node(TrieKey key, Object valueOrNode) {
            this(new Object[]{key, valueOrNode});
            this.dirty = true;
        }

        public Node(byte[] hashOrRlp) {
            if (hashOrRlp.length == 32) {
                this.hash = hashOrRlp;
            } else {
                this.rlp = hashOrRlp;
            }
        }

        private Node(RLP.LList parsedRlp) {
            this.parsedRlp = parsedRlp;
            this.rlp = parsedRlp.getEncoded();
        }

        private Node(Object[] children) {
            this.children = children;
        }

        public boolean resolveCheck() {
            if (this.rlp != null || this.parsedRlp != null || this.hash == null) {
                return true;
            }
            this.rlp = TrieImpl.this.getHash(this.hash);
            return this.rlp != null;
        }

        private void resolve() {
            if (!this.resolveCheck()) {
                logger.error("Invalid Trie state, can't resolve hash " + ByteUtil.toHexString(this.hash));
                throw new RuntimeException("Invalid Trie state, can't resolve hash " + ByteUtil.toHexString(this.hash));
            }
        }

        public byte[] encode() {
            return this.encode(1, true);
        }

        private byte[] encode(int depth, boolean forceHash) {
            byte[] ret;
            if (!this.dirty) {
                return this.hash != null ? RLP.encodeElement(this.hash) : this.rlp;
            }
            NodeType type = this.getType();
            if (type == NodeType.BranchNode) {
                if (depth == 1 && TrieImpl.this.async) {
                    Node child;
                    int i;
                    Object[] encoded = new Object[17];
                    int encodeCnt = 0;
                    for (i = 0; i < 16; ++i) {
                        child = this.branchNodeGetChild(i);
                        if (child == null) {
                            encoded[i] = RLP.EMPTY_ELEMENT_RLP;
                            continue;
                        }
                        if (!child.dirty) {
                            encoded[i] = child.encode(depth + 1, false);
                            continue;
                        }
                        ++encodeCnt;
                    }
                    for (i = 0; i < 16; ++i) {
                        if (encoded[i] != null) continue;
                        child = this.branchNodeGetChild(i);
                        encoded[i] = encodeCnt >= 3 ? TrieImpl.getExecutor().submit(() -> child.encode(depth + 1, false)) : (Object)child.encode(depth + 1, false);
                    }
                    byte[] value = this.branchNodeGetValue();
                    encoded[16] = ConcurrentUtils.constantFuture((Object)RLP.encodeElement(value));
                    try {
                        ret = this.encodeRlpListFutures(encoded);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    byte[][] encoded = new byte[17][];
                    for (int i = 0; i < 16; ++i) {
                        Node child = this.branchNodeGetChild(i);
                        encoded[i] = child == null ? RLP.EMPTY_ELEMENT_RLP : child.encode(depth + 1, false);
                    }
                    byte[] value = this.branchNodeGetValue();
                    encoded[16] = RLP.encodeElement(value);
                    ret = RLP.encodeList(encoded);
                }
            } else if (type == NodeType.KVNodeNode) {
                ret = RLP.encodeList(RLP.encodeElement(this.kvNodeGetKey().toPacked()), this.kvNodeGetChildNode().encode(depth + 1, false));
            } else {
                byte[] value = this.kvNodeGetValue();
                ret = RLP.encodeList(RLP.encodeElement(this.kvNodeGetKey().toPacked()), RLP.encodeElement(value == null ? ByteUtil.EMPTY_BYTE_ARRAY : value));
            }
            if (this.hash != null) {
                TrieImpl.this.deleteHash(this.hash);
            }
            this.dirty = false;
            if (ret.length < 32 && !forceHash) {
                this.rlp = ret;
                return ret;
            }
            this.hash = HashUtil.sha3(ret);
            TrieImpl.this.addHash(this.hash, ret);
            return RLP.encodeElement(this.hash);
        }

        @SafeVarargs
        private final byte[] encodeRlpListFutures(Object ... list) throws ExecutionException, InterruptedException {
            byte[][] vals = new byte[list.length][];
            for (int i = 0; i < list.length; ++i) {
                vals[i] = list[i] instanceof Future ? (byte[])((Future)list[i]).get() : (byte[])list[i];
            }
            return RLP.encodeList(vals);
        }

        private void parse() {
            RLP.LList list;
            if (this.children != null) {
                return;
            }
            this.resolve();
            RLP.LList lList = list = this.parsedRlp == null ? RLP.decodeLazyList(this.rlp) : this.parsedRlp;
            if (list.size() == 2) {
                this.children = new Object[2];
                TrieKey key = TrieKey.fromPacked(list.getBytes(0));
                this.children[0] = key;
                this.children[1] = key.isTerminal() ? (Object)list.getBytes(1) : (list.isList(1) ? new Node(list.getList(1)) : new Node(list.getBytes(1)));
            } else {
                this.children = new Object[17];
                this.parsedRlp = list;
            }
        }

        public Node branchNodeGetChild(int hex) {
            this.parse();
            assert (this.getType() == NodeType.BranchNode);
            Object n = this.children[hex];
            if (n == null && this.parsedRlp != null) {
                byte[] bytes;
                n = this.parsedRlp.isList(hex) ? new Node(this.parsedRlp.getList(hex)) : ((bytes = this.parsedRlp.getBytes(hex)).length == 0 ? NULL_NODE : new Node(bytes));
                this.children[hex] = n;
            }
            return n == NULL_NODE ? null : (Node)n;
        }

        public Node branchNodeSetChild(int hex, Node node) {
            this.parse();
            assert (this.getType() == NodeType.BranchNode);
            this.children[hex] = node == null ? NULL_NODE : node;
            this.dirty = true;
            return this;
        }

        public byte[] branchNodeGetValue() {
            this.parse();
            assert (this.getType() == NodeType.BranchNode);
            Object n = this.children[16];
            if (n == null && this.parsedRlp != null) {
                byte[] bytes = this.parsedRlp.getBytes(16);
                n = bytes.length == 0 ? NULL_NODE : (Object)bytes;
                this.children[16] = n;
            }
            return n == NULL_NODE ? null : (byte[])n;
        }

        public Node branchNodeSetValue(byte[] val) {
            this.parse();
            assert (this.getType() == NodeType.BranchNode);
            this.children[16] = val == null ? NULL_NODE : (Object)val;
            this.dirty = true;
            return this;
        }

        public int branchNodeCompactIdx() {
            this.parse();
            assert (this.getType() == NodeType.BranchNode);
            int cnt = 0;
            int idx = -1;
            for (int i = 0; i < 16; ++i) {
                if (this.branchNodeGetChild(i) == null) continue;
                idx = i;
                if (++cnt <= 1) continue;
                return -1;
            }
            return cnt > 0 ? idx : (this.branchNodeGetValue() == null ? -1 : 16);
        }

        public boolean branchNodeCanCompact() {
            this.parse();
            assert (this.getType() == NodeType.BranchNode);
            int cnt = 0;
            for (int i = 0; i < 16; ++i) {
                if ((cnt += this.branchNodeGetChild(i) == null ? 0 : 1) <= 1) continue;
                return false;
            }
            return cnt == 0 || this.branchNodeGetValue() == null;
        }

        public TrieKey kvNodeGetKey() {
            this.parse();
            assert (this.getType() != NodeType.BranchNode);
            return (TrieKey)this.children[0];
        }

        public Node kvNodeGetChildNode() {
            this.parse();
            assert (this.getType() == NodeType.KVNodeNode);
            return (Node)this.children[1];
        }

        public byte[] kvNodeGetValue() {
            this.parse();
            assert (this.getType() == NodeType.KVNodeValue);
            return (byte[])this.children[1];
        }

        public Node kvNodeSetValue(byte[] value) {
            this.parse();
            assert (this.getType() == NodeType.KVNodeValue);
            this.children[1] = value;
            this.dirty = true;
            return this;
        }

        public Object kvNodeGetValueOrNode() {
            this.parse();
            assert (this.getType() != NodeType.BranchNode);
            return this.children[1];
        }

        public Node kvNodeSetValueOrNode(Object valueOrNode) {
            this.parse();
            assert (this.getType() != NodeType.BranchNode);
            this.children[1] = valueOrNode;
            this.dirty = true;
            return this;
        }

        public NodeType getType() {
            this.parse();
            return this.children.length == 17 ? NodeType.BranchNode : (this.children[1] instanceof Node ? NodeType.KVNodeNode : NodeType.KVNodeValue);
        }

        public void dispose() {
            if (this.hash != null) {
                TrieImpl.this.deleteHash(this.hash);
            }
        }

        public Node invalidate() {
            this.dirty = true;
            return this;
        }

        public String dumpStruct(String indent, String prefix) {
            String ret = indent + prefix + this.getType() + (this.dirty ? " *" : "") + (String)(this.hash == null ? "" : "(hash: " + HexUtil.encode((byte[])this.hash).substring(0, 6) + ")");
            if (this.getType() == NodeType.BranchNode) {
                byte[] value = this.branchNodeGetValue();
                ret = ret + (String)(value == null ? "" : " [T] = " + HexUtil.encode((byte[])value)) + "\n";
                for (int i = 0; i < 16; ++i) {
                    Node child = this.branchNodeGetChild(i);
                    if (child == null) continue;
                    ret = ret + child.dumpStruct(indent + "  ", "[" + i + "] ");
                }
            } else if (this.getType() == NodeType.KVNodeNode) {
                ret = ret + " [" + this.kvNodeGetKey() + "]\n";
                ret = ret + this.kvNodeGetChildNode().dumpStruct(indent + "  ", "");
            } else {
                ret = ret + " [" + this.kvNodeGetKey() + "] = " + HexUtil.encode((byte[])this.kvNodeGetValue()) + "\n";
            }
            return ret;
        }

        public List<String> dumpTrieNode(boolean compact) {
            ArrayList<String> ret = new ArrayList<String>();
            if (this.hash != null) {
                ret.add(TrieImpl.hash2str(this.hash, compact) + " ==> " + this.dumpContent(false, compact));
            }
            if (this.getType() == NodeType.BranchNode) {
                for (int i = 0; i < 16; ++i) {
                    Node child = this.branchNodeGetChild(i);
                    if (child == null) continue;
                    ret.addAll(child.dumpTrieNode(compact));
                }
            } else if (this.getType() == NodeType.KVNodeNode) {
                ret.addAll(this.kvNodeGetChildNode().dumpTrieNode(compact));
            }
            return ret;
        }

        private String dumpContent(boolean recursion, boolean compact) {
            Object ret;
            if (recursion && this.hash != null) {
                return TrieImpl.hash2str(this.hash, compact);
            }
            if (this.getType() == NodeType.BranchNode) {
                ret = "[";
                for (int i = 0; i < 16; ++i) {
                    Node child = this.branchNodeGetChild(i);
                    ret = (String)ret + (i == 0 ? "" : ",");
                    ret = (String)ret + (child == null ? "" : child.dumpContent(true, compact));
                }
                byte[] value = this.branchNodeGetValue();
                ret = (String)ret + (String)(value == null ? "" : ", " + TrieImpl.val2str(value, compact));
                ret = (String)ret + "]";
            } else {
                ret = this.getType() == NodeType.KVNodeNode ? "[<" + this.kvNodeGetKey() + ">, " + this.kvNodeGetChildNode().dumpContent(true, compact) + "]" : "[<" + this.kvNodeGetKey() + ">, " + TrieImpl.val2str(this.kvNodeGetValue(), compact) + "]";
            }
            return ret;
        }

        public String toString() {
            return this.getType() + (this.dirty ? " *" : "") + (String)(this.hash == null ? "" : "(hash: " + ByteUtil.toHexString(this.hash) + " )");
        }
    }

    public static enum NodeType {
        BranchNode,
        KVNodeValue,
        KVNodeNode;

    }
}

