/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)"general");
    public static String buildHash;
    public static String buildTime;
    public static String buildBranch;

    public static void printInfo() {
        logger.debug("git.hash: [{}]", (Object)buildHash);
        logger.debug("build.time: {}", (Object)buildTime);
    }

    static {
        try {
            Properties props = new Properties();
            InputStream is = BuildInfo.class.getResourceAsStream("/build-info.properties");
            if (is != null) {
                props.load(is);
                buildHash = props.getProperty("build.hash");
                buildTime = props.getProperty("build.time");
                buildBranch = props.getProperty("build.branch");
            } else {
                logger.warn("File not found `build-info.properties`. Run `gradle build` to generate it");
            }
        }
        catch (IOException e) {
            logger.error("Error reading /build-info.properties", (Throwable)e);
        }
    }
}

