/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol;

import io.nuls.core.log.Log;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.modulebootstrap.RpcModule;
import java.util.Set;

public class ModuleHelper {
    private static boolean supportProtocolUpdate;
    private static boolean supportSmartContract;
    private static boolean supportCrossChain;

    public static boolean isSupportProtocolUpdate() {
        return supportProtocolUpdate;
    }

    public static boolean isSupportSmartContract() {
        return supportSmartContract;
    }

    public static boolean isSupportCrossChain() {
        return supportCrossChain;
    }

    public static void init(RpcModule module) {
        supportProtocolUpdate = true;
        supportSmartContract = true;
        supportCrossChain = true;
        Log.info((String)"----------------ModuleHelper----------------");
        Log.info((String)("module-" + module.toString()));
        Log.info((String)("supportProtocolUpdate-" + supportProtocolUpdate));
        Log.info((String)("supportSmartContract-" + supportSmartContract));
        Log.info((String)("supportCrossChain-" + supportCrossChain));
    }

    private static boolean enableProtocolUpdate(RpcModule module) {
        Module m = new Module(ModuleE.PU.abbr, "1.0");
        Set dependencies = module.getDependencies();
        return module.moduleInfo().equals((Object)m) || dependencies.contains(m);
    }

    private static boolean enableSmartContract(RpcModule module) {
        Module m = new Module(ModuleE.SC.abbr, "1.0");
        Set dependencies = module.getDependencies();
        return module.moduleInfo().equals((Object)m) || dependencies.contains(m);
    }

    private static boolean enableCrossChain(RpcModule module) {
        Module m = new Module(ModuleE.CC.abbr, "1.0");
        Set dependencies = module.getDependencies();
        return module.moduleInfo().equals((Object)m) || dependencies.contains(m);
    }
}

