/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol;

import io.nuls.base.protocol.MessageProcessor;
import io.nuls.base.protocol.Protocol;
import io.nuls.base.protocol.ProtocolGroup;
import io.nuls.base.protocol.RegisterHelper;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.base.protocol.cmd.MessageDispatcher;
import io.nuls.base.protocol.cmd.TransactionDispatcher;
import io.nuls.core.basic.ModuleConfig;
import io.nuls.core.basic.VersionChangeInvoker;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@Component
public class ProtocolGroupManager {
    private static boolean loadProtocol;
    @Autowired
    public static ModuleConfig moduleConfig;
    @Autowired
    private static TransactionDispatcher transactionDispatcher;
    @Autowired
    private static MessageDispatcher messageDispatcher;
    public static List<Integer> chainIds;
    private static Map<Integer, ProtocolGroup> protocolGroupMap;
    private static Map<Integer, Short> versionMap;

    public static boolean isLoadProtocol() {
        return loadProtocol;
    }

    public static void setLoadProtocol(boolean loadProtocol) {
        ProtocolGroupManager.loadProtocol = loadProtocol;
    }

    public static VersionChangeInvoker getVersionChangeInvoker() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return moduleConfig.getVersionChangeInvoker();
    }

    public static void init(int chainId, Map<Short, Protocol> protocolMap, short version) {
        if (ProtocolGroupManager.isLoadProtocol()) {
            ProtocolGroup protocolGroup = new ProtocolGroup();
            protocolGroup.setProtocolsMap(protocolMap);
            protocolGroup.setVersion(version);
            protocolGroupMap.put(chainId, protocolGroup);
        }
        chainIds.add(chainId);
        if (ProtocolGroupManager.getCurrentVersion(chainId) != null) {
            Short currentVersion = ProtocolGroupManager.getCurrentVersion(chainId);
            version = version < currentVersion ? currentVersion : version;
        }
        ProtocolGroupManager.updateProtocol(chainId, version);
    }

    public static Short getCurrentVersion(int chainId) {
        return versionMap.get(chainId);
    }

    public static Protocol getCurrentProtocol(int chainId) {
        return protocolGroupMap.get(chainId).getProtocol();
    }

    public static Protocol getOneProtocol() {
        ProtocolGroup o = (ProtocolGroup)protocolGroupMap.values().toArray()[0];
        return o.getProtocol();
    }

    public static Collection<Protocol> getProtocols(int chainId) {
        return protocolGroupMap.get(chainId).getProtocolsMap().values();
    }

    public static void updateProtocol(int chainId, short protocolVersion) {
        versionMap.put(chainId, protocolVersion);
        if (ProtocolGroupManager.isLoadProtocol()) {
            ProtocolGroup protocolGroup;
            Protocol protocol;
            if (transactionDispatcher == null) {
                transactionDispatcher = (TransactionDispatcher)((Object)SpringLiteContext.getBean(TransactionDispatcher.class));
            }
            if (messageDispatcher == null) {
                messageDispatcher = (MessageDispatcher)((Object)SpringLiteContext.getBean(MessageDispatcher.class));
            }
            if ((protocol = (protocolGroup = protocolGroupMap.get(chainId)).getProtocolsMap().get(protocolVersion)) == null) {
                Short version;
                TreeSet<Short> sortKey = new TreeSet<Short>(protocolGroup.getProtocolsMap().keySet());
                short effectiveVersion = 1;
                Iterator iterator = sortKey.iterator();
                while (iterator.hasNext() && (version = (Short)iterator.next()) <= protocolVersion) {
                    effectiveVersion = version;
                }
                protocol = protocolGroup.getProtocolsMap().get(effectiveVersion);
            }
            if (protocol != null) {
                protocolGroup.setVersion(protocolVersion);
                ArrayList<TransactionProcessor> transactionProcessors = new ArrayList<TransactionProcessor>();
                protocol.getAllowTx().forEach(e -> {
                    if (StringUtils.isNotBlank((String)e.getHandler())) {
                        transactionProcessors.add((TransactionProcessor)SpringLiteContext.getBean(TransactionProcessor.class, (String)e.getHandler()));
                    }
                });
                transactionDispatcher.setProcessors(transactionProcessors);
                ArrayList<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
                protocol.getAllowMsg().forEach(e -> {
                    for (String s : e.getHandlers().split(",")) {
                        messageProcessors.add((MessageProcessor)SpringLiteContext.getBean(MessageProcessor.class, (String)s));
                    }
                });
                messageDispatcher.setProcessors(messageProcessors);
                try {
                    RegisterHelper.registerTx(chainId, protocol);
                }
                catch (Exception e2) {
                    Log.warn((String)e2.getMessage());
                }
            }
        }
    }

    static {
        chainIds = new CopyOnWriteArrayList<Integer>();
        protocolGroupMap = new ConcurrentHashMap<Integer, ProtocolGroup>();
        versionMap = new ConcurrentHashMap<Integer, Short>();
    }
}

