/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.helper;

import io.nuls.account.config.NulsConfig;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.bo.tx.txdata.AccountContractCallData;
import io.nuls.account.util.TxUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.List;

@Component
public class AccountContractCallHelper {
    @Autowired
    private NulsCoresConfig accountConfig;

    public Result validate(Chain chain, Transaction tx) throws NulsException {
        CoinData coinData = TxUtil.getCoinData(tx);
        List listFrom = coinData.getFrom();
        List listTo = coinData.getTo();
        if (null == listFrom || listFrom.size() == 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_COINFROM_NOT_FOUND);
        }
        int chainId = chain.getConfig().getChainId();
        if (listFrom.size() > 1) {
            return Result.getFailed((ErrorCode)AccountErrorCode.COINDATA_IS_INCOMPLETE);
        }
        CoinFrom coinFrom = (CoinFrom)listFrom.get(0);
        String fromStr = AddressTool.getStringAddressByBytes((byte[])coinFrom.getAddress());
        if (!fromStr.equals(this.accountConfig.getBlockAccountManager())) {
            chain.getLogger().error("error: not manager, tx: {}, config: {}", new Object[]{fromStr, this.accountConfig.getBlockAccountManager()});
            return Result.getFailed((ErrorCode)AccountErrorCode.COINDATA_IS_INCOMPLETE);
        }
        AccountContractCallData txData = new AccountContractCallData();
        txData.parse(tx.getTxData(), 0);
        int type = txData.getType();
        if (type != 1 && type != 2) {
            chain.getLogger().error("error type: {}", new Object[]{type});
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        String[] addresses = txData.getAddresses();
        if (addresses.length == 0) {
            chain.getLogger().error("empty addresses");
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        for (String addr : addresses) {
            if (!AddressTool.validAddress((int)chainId, (String)addr)) {
                chain.getLogger().error("error address: {}", new Object[]{addr});
                return Result.getFailed((ErrorCode)AccountErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            if (!addr.equals(this.accountConfig.getBlockAccountManager())) continue;
            chain.getLogger().error("error: manager can not in it");
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        int addrChainId = AddressTool.getChainIdByAddress((byte[])coinFrom.getAddress());
        if (AddressTool.isBlackHoleAddress((byte[])NulsConfig.BLACK_HOLE_PUB_KEY, (int)addrChainId, (byte[])coinFrom.getAddress())) {
            return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_TRANSFER_BAN);
        }
        if (chainId != addrChainId) {
            return Result.getFailed((ErrorCode)AccountErrorCode.CHAINID_ERROR);
        }
        if (null == listTo || listTo.size() == 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_COINTO_NOT_FOUND);
        }
        for (CoinTo coinTo : listTo) {
            int toAddrChainId = AddressTool.getChainIdByAddress((byte[])coinTo.getAddress());
            if (chainId == toAddrChainId) continue;
            return Result.getFailed((ErrorCode)AccountErrorCode.CHAINID_ERROR);
        }
        return TxUtil.getSuccess();
    }
}

