/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.dto;

import io.nuls.account.model.bo.Account;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel(name="Offline account data")
public class AccountOfflineDTO {
    @ApiModelProperty(description="Account address")
    private String address;
    @ApiModelProperty(description="Public key")
    private String pubKey;
    @ApiModelProperty(description="Private key")
    private String priKey;
    @ApiModelProperty(description="Encrypted private key")
    private String encryptedPriKey;
    @ApiModelProperty(description="Other information")
    private String extend;
    @ApiModelProperty(description="Creation time")
    private Long createTime;
    @ApiModelProperty(description="Is the account encrypted")
    private boolean encrypted;
    @ApiModelProperty(description="Account notes")
    private String remark;

    public AccountOfflineDTO() {
    }

    public AccountOfflineDTO(Account account) {
        this.address = account.getAddress().getBase58();
        this.pubKey = HexUtil.encode((byte[])account.getPubKey());
        this.createTime = account.getCreateTime();
        if (account.getExtend() != null) {
            this.extend = HexUtil.encode((byte[])account.getExtend());
        }
        this.encrypted = account.isEncrypted();
        if (this.encrypted) {
            this.encryptedPriKey = HexUtil.encode((byte[])account.getEncryptedPriKey());
            this.priKey = "";
        } else {
            this.priKey = HexUtil.encode((byte[])account.getPriKey());
            this.encryptedPriKey = "";
        }
        this.remark = account.getRemark();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public String getPriKey() {
        return this.priKey;
    }

    public void setPriKey(String priKey) {
        this.priKey = priKey;
    }

    public String getEncryptedPriKey() {
        return this.encryptedPriKey;
    }

    public void setEncryptedPriKey(String encryptedPriKey) {
        this.encryptedPriKey = encryptedPriKey;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

