/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.po;

import io.nuls.account.model.bo.tx.txdata.Alias;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class AliasPO
extends BaseNulsData {
    private int chainId;
    private String alias;
    private byte[] address;

    public AliasPO() {
    }

    public AliasPO(Alias alias) {
        this.address = alias.getAddress();
        this.alias = alias.getAlias().trim();
    }

    public Alias toAlias() {
        return new Alias(this.address, this.getAlias().trim());
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias == null ? null : alias.trim();
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeString(this.alias);
        stream.writeBytesWithLength(this.address);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.alias = byteBuffer.readString();
        this.address = byteBuffer.readByLengthByte();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfString((String)this.alias);
        return size += SerializeUtils.sizeOfBytes((byte[])this.address);
    }
}

