/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.call;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.io.IOException;
import java.util.HashMap;

public class TransactionCall {
    public static boolean newTx(Chain chain, Transaction tx) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            Response cmdResp = null;
            try {
                params.put("tx", RPCUtil.encode((byte[])tx.serialize()));
                cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_newTx", params);
            }
            catch (IOException e) {
                chain.getLogger().error((Exception)e);
                throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
            }
            catch (Exception e) {
                chain.getLogger().error(e);
                throw new NulsException(AccountErrorCode.RPC_REQUEST_FAILD);
            }
            if (!cmdResp.isSuccess()) {
                String errorCode = cmdResp.getResponseErrorCode();
                chain.getLogger().error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{} hash:{}", new Object[]{"tx_newTx", errorCode, cmdResp.getResponseComment(), tx.getHash().toHex()});
                throw new NulsException(ErrorCode.init((String)errorCode));
            }
            return cmdResp.isSuccess();
        }
        catch (RuntimeException e) {
            throw new NulsException(AccountErrorCode.RPC_REQUEST_FAILD);
        }
    }
}

