/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.cmd;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.po.AccountBlockExtendPO;
import io.nuls.account.model.po.AccountBlockPO;
import io.nuls.account.model.vo.AccountBlockVO;
import io.nuls.account.storage.AccountBlockStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@NulsCoresCmd(module=ModuleE.AC)
public class AccountBlockCmd
extends BaseCmd {
    @Autowired
    private AccountBlockStorageService accountBlockStorageService;
    @Autowired
    private ChainManager chainManager;

    @CmdAnnotation(cmd="ac_isBlockAccount", version=1.0, description="Check if the account is locked")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="address")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Is the account locked")}))
    public Response isBlockAccount(Map params) {
        boolean isBlock;
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object addressObj = params == null ? null : params.get("address");
        try {
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            isBlock = this.accountBlockStorageService.existAccount(AddressTool.getAddress((String)address));
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
        result.put("value", isBlock);
        return this.success(result);
    }

    @CmdAnnotation(cmd="ac_getAllBlockAccount", version=1.0, description="Query all locked accounts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class))
    public Response getAllBlockAccount(Map params) {
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        try {
            if (params == null || chainIdObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            List accountList = this.accountBlockStorageService.getAccountList();
            if (accountList == null) {
                accountList = Collections.EMPTY_LIST;
            }
            List collect = accountList.stream().map(a -> AddressTool.getStringAddressByBytes((byte[])a.getAddress())).collect(Collectors.toList());
            HashMap result = new HashMap(2);
            result.put("value", collect);
            return this.success(result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_getBlockAccountBytes", version=1.0, description="Query information about locked accounts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="address")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=String.class, description="Lock the serialized string of the account")}))
    public Response getBlockAccountBytes(Map params) {
        Chain chain = null;
        try {
            Object addressObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object v0 = addressObj = params == null ? null : params.get("address");
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            byte[] bytes = this.accountBlockStorageService.getAccountBytes(AddressTool.getAddress((String)address));
            HashMap<String, String> result = new HashMap<String, String>(2);
            String resultHex = bytes == null ? "" : HexUtil.encode((byte[])bytes);
            result.put("value", resultHex);
            return this.success(result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_getBlockAccountInfo", version=1.0, description="Query information about locked accounts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="address")})
    @ResponseData(name="Return value", description="Return an object", responseType=@TypeDescriptor(value=AccountBlockVO.class))
    public Response getBlockAccountInfo(Map params) {
        Chain chain = null;
        try {
            Object addressObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object v0 = addressObj = params == null ? null : params.get("address");
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            AccountBlockPO account = this.accountBlockStorageService.getAccount(AddressTool.getAddress((String)address));
            if (account == null) {
                return this.failed(AccountErrorCode.DATA_NOT_FOUND);
            }
            AccountBlockVO vo = new AccountBlockVO();
            vo.setAddress(AddressTool.getStringAddressByBytes((byte[])account.getAddress()));
            if (account.getExtend() != null) {
                AccountBlockExtendPO extendPO = new AccountBlockExtendPO();
                extendPO.parse(account.getExtend(), 0);
                vo.setTypes(extendPO.getTypes());
                vo.setContracts(extendPO.getContracts());
            }
            return this.success(vo);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

