/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.cmd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Account;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.dto.BaseCoinDTO;
import io.nuls.account.model.dto.CoinDTO;
import io.nuls.account.model.dto.MultiSignCoinToDTO;
import io.nuls.account.model.dto.MultiSignTransactionResultDTO;
import io.nuls.account.model.dto.MultiSignTransferDTO;
import io.nuls.account.model.dto.TransferDTO;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.AliasService;
import io.nuls.account.service.MultiSignAccountService;
import io.nuls.account.service.TransactionService;
import io.nuls.account.storage.AliasStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.account.util.validator.TxValidator;
import io.nuls.base.RPCUtil;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.AC)
public class AcmTransactionCmd
extends BaseCmd {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TxValidator txValidator;
    @Autowired
    private AliasStorageService aliasStorageService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private MultiSignAccountService multiSignAccountService;
    @Autowired
    private AliasService aliasService;

    @CmdAnnotation(cmd="ac_transfer", version=1.0, description="Create a regular transfer transaction/create transfer transaction")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="inputs", requestType=@TypeDescriptor(value=List.class, collectionElement=CoinDTO.class), parameterDes="Transaction payer data"), @Parameter(parameterName="outputs", requestType=@TypeDescriptor(value=List.class, collectionElement=CoinDTO.class), parameterDes="Transaction recipient data"), @Parameter(parameterName="remark", parameterType="String", parameterDes="Transaction notes")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public Response transfer(Map params) {
        Chain chain = null;
        try {
            if (params == null) {
                LoggerUtil.LOG.warn("ac_transfer params is null");
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            JSONUtils.getInstance().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            TransferDTO transferDto = (TransferDTO)JSONUtils.map2pojo((Map)params, TransferDTO.class);
            chain = this.chainManager.getChain(transferDto.getChainId());
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            Transaction tx = this.transactionService.transfer(chain, transferDto);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("value", tx.getHash().toHex());
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_createMultiSignTransfer", version=1.0, description="Create multiple address transfer transactions/create multi sign transfer")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="inputs", requestType=@TypeDescriptor(value=List.class, collectionElement=BaseCoinDTO.class), parameterDes="Transaction payer data"), @Parameter(parameterName="outputs", requestType=@TypeDescriptor(value=List.class, collectionElement=MultiSignCoinToDTO.class), parameterDes="Transaction recipient data"), @Parameter(parameterName="remark", parameterType="String", parameterDes="Transaction notes"), @Parameter(parameterName="signAddress", parameterType="String", canNull=true, parameterDes="First signature account address(If left blank, only create transactions without signing)"), @Parameter(parameterName="signPassword", parameterType="String", canNull=true, parameterDes="First signature account password(If left blank, only create transactions without signing)")})
    @ResponseData(name="Return value", description="Return aMap,Including threekey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="tx", description="Complete transaction serialization string,If the transaction does not reach the minimum number of signatures, you can continue to sign"), @Key(name="txHash", description="transactionhash"), @Key(name="completed", valueType=boolean.class, description="true:Transaction completed(Broadcasted),false:Transaction not completed,Not reaching the minimum number of signatures")}))
    public Response multiSignTransfer(Map params) {
        Chain chain = null;
        try {
            if (params == null) {
                LoggerUtil.LOG.warn("ac_transfer params is null");
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            JSONUtils.getInstance().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            MultiSignTransferDTO multiSignTransferDTO = (MultiSignTransferDTO)JSONUtils.map2pojo((Map)params, MultiSignTransferDTO.class);
            chain = this.chainManager.getChain(multiSignTransferDTO.getChainId());
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            MultiSignTransactionResultDTO multiSignTransactionResultDto = this.transactionService.multiSignTransfer(chain, multiSignTransferDTO);
            boolean result = false;
            if (multiSignTransactionResultDto.isBroadcasted()) {
                result = true;
            }
            Transaction tx = multiSignTransactionResultDto.getTransaction();
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("completed", result);
            map.put("txHash", tx.getHash().toHex());
            map.put("tx", RPCUtil.encode((byte[])tx.serialize()));
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_signMultiSignTransaction", version=1.0, description="Multiple transaction signatures/sign MultiSign Transaction")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Transaction data string"), @Parameter(parameterName="signAddress", parameterType="String", parameterDes="Signature account address"), @Parameter(parameterName="signPassword", parameterType="String", parameterDes="Signature account password")})
    @ResponseData(name="Return value", description="Return aMap,Including threekey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="tx", description="Complete transaction serialization string,If the transaction does not reach the minimum number of signatures, you can continue to sign"), @Key(name="txHash", description="transactionhash"), @Key(name="completed", valueType=boolean.class, description="true:Transaction completed(Broadcasted),false:Transaction not completed,Not reaching the minimum number of signatures")}))
    public Response signMultiSignTransaction(Map params) {
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object passwordObj = params == null ? null : params.get("signPassword");
        Object signAddressObj = params == null ? null : params.get("signAddress");
        Object txStrObj = params == null ? null : params.get("tx");
        try {
            if (params == null || chainIdObj == null || signAddressObj == null || txStrObj == null) {
                LoggerUtil.LOG.warn("ac_signMultiSignTransaction params is null");
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            int chainId = chain.getChainId();
            String password = passwordObj;
            String signAddress = signAddressObj;
            String txStr = txStrObj;
            Account account = this.accountService.getAccount(chainId, signAddress);
            if (account == null) {
                throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST);
            }
            MultiSignTransactionResultDTO multiSignTransactionResultDto = this.transactionService.signMultiSignTransaction(chain, account, password, txStr);
            boolean result = false;
            if (multiSignTransactionResultDto.isBroadcasted()) {
                result = true;
            }
            Transaction tx = multiSignTransactionResultDto.getTransaction();
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("completed", result);
            map.put("txHash", tx.getHash().toHex());
            map.put("tx", RPCUtil.encode((byte[])tx.serialize()));
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

