/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.service.impl;

import io.nuls.account.config.NulsConfig;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Account;
import io.nuls.account.model.bo.AccountKeyStore;
import io.nuls.account.model.dto.AccountKeyStoreDTO;
import io.nuls.account.service.AccountKeyStoreService;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.AliasService;
import io.nuls.account.storage.AccountStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rockdb.util.DBUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

@Component
public class AccountKeyStoreServiceImpl
implements AccountKeyStoreService {
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountStorageService accountStorageService;
    @Autowired
    private AliasService aliasService;

    @Override
    public String backupAccountToKeyStore(String path, int chainId, String address, String password) {
        AccountKeyStore accountKeyStore = this.accountToKeyStore(chainId, address, password);
        String backupPath = this.backUpKeyStore(path, new AccountKeyStoreDTO(accountKeyStore));
        return backupPath;
    }

    @Override
    public AccountKeyStore getKeyStore(int chainId, String address, String password) {
        AccountKeyStore accountKeyStore = this.accountToKeyStore(chainId, address, password);
        return accountKeyStore;
    }

    public AccountKeyStore accountToKeyStore(int chainId, String address, String password) {
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR);
        }
        Account account = this.accountService.getAccount(chainId, address);
        if (null == account) {
            throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST);
        }
        AccountKeyStore accountKeyStore = new AccountKeyStore();
        if (!account.validatePassword(password)) {
            throw new NulsRuntimeException(AccountErrorCode.PASSWORD_IS_WRONG);
        }
        if (account.isEncrypted()) {
            accountKeyStore.setEncryptedPrivateKey(HexUtil.encode((byte[])account.getEncryptedPriKey()));
        } else {
            accountKeyStore.setPrikey(account.getPriKey());
        }
        accountKeyStore.setAddress(account.getAddress().toString());
        accountKeyStore.setPubKey(account.getPubKey());
        return accountKeyStore;
    }

    public String backUpKeyStore(String path, AccountKeyStoreDTO accountKeyStoreDto) {
        File backupFile;
        if (StringUtils.isBlank((String)path)) {
            if (StringUtils.isBlank((String)NulsConfig.ACCOUNTKEYSTORE_FOLDER_NAME)) {
                URL resource = ClassLoader.getSystemClassLoader().getResource("");
                path = resource.getPath();
            } else {
                path = NulsConfig.ACCOUNTKEYSTORE_FOLDER_NAME;
            }
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LoggerUtil.LOG.error((Exception)e);
            }
        }
        if (!(backupFile = DBUtils.loadDataPath((String)path)).isDirectory()) {
            if (!backupFile.mkdirs()) {
                throw new NulsRuntimeException(AccountErrorCode.FILE_OPERATION_FAILD);
            }
            if (!backupFile.exists() && !backupFile.mkdir()) {
                throw new NulsRuntimeException(AccountErrorCode.FILE_OPERATION_FAILD);
            }
        }
        String fileName = accountKeyStoreDto.getAddress().concat(".keystore");
        backupFile = new File(backupFile, fileName);
        try {
            if (!backupFile.exists() && !backupFile.createNewFile()) {
                throw new NulsRuntimeException(AccountErrorCode.FILE_OPERATION_FAILD);
            }
        }
        catch (IOException e) {
            throw new NulsRuntimeException(AccountErrorCode.IO_ERROR);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(backupFile);
            fileOutputStream.write(JSONUtils.obj2json((Object)accountKeyStoreDto).getBytes());
        }
        catch (Exception e) {
            throw new NulsRuntimeException(AccountErrorCode.PARSE_JSON_FAILD);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LoggerUtil.LOG.error((Exception)e);
                }
            }
        }
        if (System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = path.replace("/", "\\");
        }
        String backupFileName = path + File.separator + fileName;
        return backupFileName;
    }
}

