/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.tx.v1;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.bo.tx.txdata.Alias;
import io.nuls.account.service.AliasService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="AliasProcessorV1")
public class AliasProcessor
implements TransactionProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AliasService aliasService;

    public int getType() {
        return 3;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChain(chainId);
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        HashMap<String, Transaction> aliasNamesMap = new HashMap<String, Transaction>(16);
        HashMap<String, Transaction> accountAddressMap = new HashMap<String, Transaction>(16);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        String errorCode = null;
        for (Transaction tx : txs) {
            Alias alias = new Alias();
            try {
                Result rs = this.aliasService.aliasTxValidate(chain.getChainId(), tx);
                if (rs.isFailed()) {
                    errorCode = rs.getErrorCode().getCode();
                    txList.add(tx);
                    continue;
                }
                alias.parse(new NulsByteBuffer(tx.getTxData()));
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
                txList.add(tx);
                continue;
            }
            String address = AddressTool.getStringAddressByBytes((byte[])alias.getAddress());
            Transaction tmp = (Transaction)aliasNamesMap.get(alias.getAlias());
            if (tmp != null) {
                txList.add(tx);
                chain.getLogger().error("the alias is already exist,alias: " + alias.getAlias() + ",address: " + alias.getAddress());
                errorCode = AccountErrorCode.ALIAS_EXIST.getCode();
                continue;
            }
            aliasNamesMap.put(alias.getAlias(), tx);
            tmp = (Transaction)accountAddressMap.get(address);
            if (tmp != null) {
                txList.add(tx);
                errorCode = AccountErrorCode.ACCOUNT_ALREADY_SET_ALIAS.getCode();
                continue;
            }
            accountAddressMap.put(address, tx);
        }
        result.put("txList", txList);
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        boolean result = true;
        Chain chain = this.chainManager.getChain(chainId);
        ArrayList<Transaction> commitSucTxList = new ArrayList<Transaction>();
        for (Transaction tx : txs) {
            Alias alias = new Alias();
            try {
                alias.parse(new NulsByteBuffer(tx.getTxData()));
                result = this.aliasService.aliasTxCommit(chainId, alias);
            }
            catch (NulsException e) {
                result = false;
            }
            if (!result) {
                LoggerUtil.LOG.warn("ac_commitTx alias tx commit error");
                break;
            }
            commitSucTxList.add(tx);
        }
        try {
            if (!result) {
                boolean rollback = true;
                for (Transaction tx : commitSucTxList) {
                    Alias alias = new Alias();
                    alias.parse(new NulsByteBuffer(tx.getTxData()));
                    rollback = this.aliasService.rollbackAlias(chainId, alias);
                }
                if (!rollback) {
                    LoggerUtil.LOG.error("ac_commitTx alias tx rollback error");
                    throw new NulsException(AccountErrorCode.ALIAS_ROLLBACK_ERROR);
                }
            }
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            result = false;
        }
        return result;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        boolean result = true;
        Chain chain = this.chainManager.getChain(chainId);
        ArrayList<Transaction> rollbackSucTxList = new ArrayList<Transaction>();
        for (Transaction tx : txs) {
            Alias alias = new Alias();
            try {
                alias.parse(new NulsByteBuffer(tx.getTxData()));
                result = this.aliasService.rollbackAlias(chainId, alias);
            }
            catch (NulsException e) {
                result = false;
            }
            if (!result) {
                LoggerUtil.LOG.warn("ac_rollbackTx alias tx rollback error");
                break;
            }
            rollbackSucTxList.add(tx);
        }
        try {
            if (!result) {
                boolean commit = true;
                for (Transaction tx : rollbackSucTxList) {
                    Alias alias = new Alias();
                    alias.parse(new NulsByteBuffer(tx.getTxData()));
                    commit = this.aliasService.aliasTxCommit(chainId, alias);
                }
                if (!commit) {
                    LoggerUtil.LOG.error("ac_rollbackTx alias tx commit error");
                    throw new NulsException(AccountErrorCode.ALIAS_SAVE_ERROR);
                }
            }
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            result = false;
        }
        return result;
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

