/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.util.validator;

import io.nuls.account.config.NulsConfig;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.service.MultiSignAccountService;
import io.nuls.account.service.TransactionService;
import io.nuls.account.util.TxUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class TxValidator {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MultiSignAccountService multiSignAccountService;

    public Result validate(Chain chain, Transaction tx) throws NulsException {
        CoinData coinData = TxUtil.getCoinData(tx);
        Result result = this.validateCoinFromBase(chain, coinData.getFrom());
        if (result.isFailed()) {
            return result;
        }
        result = this.validateCoinToBase(chain, coinData.getTo());
        if (result.isFailed()) {
            return result;
        }
        result = this.validateCoinDataAsset(chain, coinData);
        if (result.isFailed()) {
            return result;
        }
        return result;
    }

    public Result validateCoinDataAsset(Chain chain, CoinData coinData) throws NulsException {
        HashMap<CallSite, BigInteger> mapFrom = new HashMap<CallSite, BigInteger>(8);
        for (CoinFrom coinFrom : coinData.getFrom()) {
            String string = coinFrom.getAssetsChainId() + "-" + coinFrom.getAssetsId();
            BigInteger amount = (BigInteger)mapFrom.get(string);
            amount = null != amount ? amount.add(coinFrom.getAmount()) : coinFrom.getAmount();
            mapFrom.put((CallSite)((Object)string), amount);
        }
        HashMap<CallSite, BigInteger> mapTo = new HashMap<CallSite, BigInteger>(8);
        for (CoinTo coinTo : coinData.getTo()) {
            String key = coinTo.getAssetsChainId() + "-" + coinTo.getAssetsId();
            BigInteger amount = (BigInteger)mapTo.get(key);
            amount = null != amount ? amount.add(coinTo.getAmount()) : coinTo.getAmount();
            mapTo.put((CallSite)((Object)key), amount);
        }
        for (Map.Entry entry : mapTo.entrySet()) {
            BigInteger value = (BigInteger)mapFrom.get(entry.getKey());
            if (null == value) {
                return Result.getFailed((ErrorCode)AccountErrorCode.COINFROM_UNDERPAYMENT);
            }
            if (((BigInteger)entry.getValue()).compareTo(value) != 1) continue;
            return Result.getFailed((ErrorCode)AccountErrorCode.COINFROM_UNDERPAYMENT);
        }
        return TxUtil.getSuccess();
    }

    public Result validateCoinFromBase(Chain chain, List<CoinFrom> listFrom) throws NulsException {
        if (null == listFrom || listFrom.size() == 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_COINFROM_NOT_FOUND);
        }
        int chainId = chain.getConfig().getChainId();
        for (CoinFrom coinFrom : listFrom) {
            int addrChainId = AddressTool.getChainIdByAddress((byte[])coinFrom.getAddress());
            if (AddressTool.isBlackHoleAddress((byte[])NulsConfig.BLACK_HOLE_PUB_KEY, (int)addrChainId, (byte[])coinFrom.getAddress())) {
                return Result.getFailed((ErrorCode)AccountErrorCode.ADDRESS_TRANSFER_BAN);
            }
            if (chainId == addrChainId) continue;
            return Result.getFailed((ErrorCode)AccountErrorCode.CHAINID_ERROR);
        }
        return TxUtil.getSuccess();
    }

    public Result validateCoinToBase(Chain chain, List<CoinTo> listTo) throws NulsException {
        if (null == listTo || listTo.size() == 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.TX_COINTO_NOT_FOUND);
        }
        int chainId = chain.getConfig().getChainId();
        for (CoinTo coinTo : listTo) {
            int addrChainId = AddressTool.getChainIdByAddress((byte[])coinTo.getAddress());
            if (chainId == addrChainId) continue;
            return Result.getFailed((ErrorCode)AccountErrorCode.CHAINID_ERROR);
        }
        return TxUtil.getSuccess();
    }
}

