/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.manager;

import io.nuls.block.manager.ContextManager;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.service.BlockService;
import io.nuls.block.utils.ConfigLoader;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.List;

@Component
public class ChainManager {
    @Autowired
    private BlockService service;

    public void initChain() throws Exception {
        ConfigLoader.load();
        List<Integer> chainIds = ContextManager.CHAIN_ID_LIST;
        for (Integer chainId : chainIds) {
            this.initTable(chainId);
        }
    }

    public void runChain() throws InterruptedException {
        List<Integer> chainIds = ContextManager.CHAIN_ID_LIST;
        for (Integer chainId : chainIds) {
            List<Integer> systemTypes = TransactionCall.getSystemTypes(chainId);
            while (systemTypes == null || systemTypes.isEmpty() || !systemTypes.contains(1)) {
                Thread.sleep(1000L);
                LoggerUtil.COMMON_LOG.warn("systemTypes doesn't contains coin_base");
                systemTypes = TransactionCall.getSystemTypes(chainId);
            }
            this.service.init(chainId);
        }
    }

    public void stopChain(int chainId) {
    }

    private void initTable(int chainId) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            RocksDBService.createTable((String)("block_header_" + chainId));
            RocksDBService.createTable((String)("block_header_index_" + chainId));
            if (RocksDBService.existTable((String)("cached_block_" + chainId))) {
                RocksDBService.destroyTable((String)("cached_block_" + chainId));
            }
            RocksDBService.createTable((String)("cached_block_" + chainId));
        }
        catch (Exception e) {
            logger.error(e);
        }
    }
}

