/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseBusinessMessage;
import io.nuls.base.data.NulsHash;
import io.nuls.core.basic.VarInt;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HashListMessage
extends BaseBusinessMessage {
    private NulsHash blockHash;
    private List<NulsHash> txHashList = new ArrayList<NulsHash>();

    public NulsHash getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(NulsHash blockHash) {
        this.blockHash = blockHash;
    }

    public List<NulsHash> getTxHashList() {
        return this.txHashList;
    }

    public void setTxHashList(List<NulsHash> txHashList) {
        this.txHashList = txHashList;
    }

    public int size() {
        int size = 0;
        size += 32;
        size += VarInt.sizeOf((long)this.txHashList.size());
        return size += this.getTxHashBytesLength();
    }

    private int getTxHashBytesLength() {
        int size = 0;
        return size += this.txHashList.size() * 32;
    }

    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.blockHash.getBytes());
        stream.writeVarInt(this.txHashList.size());
        for (NulsHash data : this.txHashList) {
            stream.write(data.getBytes());
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.blockHash = byteBuffer.readHash();
        long txCount = byteBuffer.readVarInt();
        this.txHashList = new ArrayList<NulsHash>();
        int i = 0;
        while ((long)i < txCount) {
            this.txHashList.add(byteBuffer.readHash());
            ++i;
        }
    }
}

