/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.BlockMessage;
import io.nuls.block.message.HeightMessage;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.service.BlockService;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.ByteUtils;

@Component(value="GetBlockByHeightHandlerV1")
public class GetBlockByHeightHandler
implements MessageProcessor {
    @Autowired
    private BlockService service;

    private void sendBlock(int chainId, Block block, String nodeId, NulsHash requestHash) {
        BlockMessage message = new BlockMessage();
        message.setRequestHash(requestHash);
        if (block != null) {
            message.setBlock(block);
        }
        message.setSyn(false);
        NetworkCall.sendToNode(chainId, message, nodeId, "block");
    }

    public String getCmd() {
        return "getBlockH";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        HeightMessage message = (HeightMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, HeightMessage.class));
        if (message == null) {
            return;
        }
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        long height = message.getHeight();
        logger.debug("recieve " + message + " from node-" + nodeId + ", height:" + height);
        this.sendBlock(chainId, this.service.getBlock(chainId, height), nodeId, NulsHash.calcHash((byte[])ByteUtils.longToBytes((long)height)));
    }
}

