/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.BlockMessage;
import io.nuls.block.message.HashMessage;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.service.BlockService;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;

@Component(value="GetBlockHandlerV1")
public class GetBlockHandler
implements MessageProcessor {
    @Autowired
    private BlockService service;

    private void sendBlock(int chainId, Block block, String nodeId, NulsHash requestHash) {
        BlockMessage message = new BlockMessage();
        message.setRequestHash(requestHash);
        if (block != null) {
            message.setBlock(block);
        }
        message.setSyn(false);
        NetworkCall.sendToNode(chainId, message, nodeId, "block");
    }

    public String getCmd() {
        return "getBlock";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        HashMessage message = (HashMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, HashMessage.class));
        if (message == null) {
            return;
        }
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        NulsHash requestHash = message.getRequestHash();
        logger.debug("recieve " + message + " from node-" + nodeId + ", hash:" + requestHash);
        Block block = this.service.getBlock(chainId, requestHash);
        if (block == null) {
            logger.debug("recieve invalid " + message + " from node-" + nodeId + ", hash:" + requestHash);
        }
        this.sendBlock(chainId, block, nodeId, requestHash);
    }
}

