/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.HashListMessage;
import io.nuls.block.message.TxGroupMessage;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import java.util.List;

@Component(value="GetTxGroupHandlerV1")
public class GetTxGroupHandler
implements MessageProcessor {
    public String getCmd() {
        return "getTxs";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        HashListMessage message = (HashListMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, HashListMessage.class));
        if (message == null) {
            return;
        }
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        List<NulsHash> hashList = message.getTxHashList();
        TxGroupMessage request = new TxGroupMessage();
        List<Transaction> transactions = TransactionCall.getTransactions(chainId, hashList, true);
        if (transactions.isEmpty()) {
            return;
        }
        request.setBlockHash(message.getBlockHash());
        request.setTransactions(transactions);
        NetworkCall.sendToNode(chainId, request, nodeId, "txs");
    }
}

