/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.SmallBlock;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.constant.BlockForwardEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.TxGroupMessage;
import io.nuls.block.model.CachedSmallBlock;
import io.nuls.block.service.BlockService;
import io.nuls.block.thread.monitor.TxGroupRequestor;
import io.nuls.block.utils.BlockUtil;
import io.nuls.block.utils.SmallBlockCacher;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import java.util.List;
import java.util.Map;

@Component(value="TxGroupHandlerV1")
public class TxGroupHandler
implements MessageProcessor {
    @Autowired
    private BlockService blockService;

    public String getCmd() {
        return "txs";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        TxGroupMessage message = (TxGroupMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, TxGroupMessage.class));
        if (message == null) {
            return;
        }
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        List<Transaction> transactions = message.getTransactions();
        if (null == transactions || transactions.isEmpty()) {
            logger.warn("recieved a null txGroup form " + nodeId);
            return;
        }
        NulsHash blockHash = message.getBlockHash();
        BlockForwardEnum status = SmallBlockCacher.getStatus(chainId, blockHash);
        if (BlockForwardEnum.COMPLETE.equals((Object)status)) {
            return;
        }
        if (BlockForwardEnum.INCOMPLETE.equals((Object)status)) {
            CachedSmallBlock cachedSmallBlock = SmallBlockCacher.getCachedSmallBlock(chainId, blockHash);
            if (cachedSmallBlock == null) {
                return;
            }
            SmallBlock smallBlock = cachedSmallBlock.getSmallBlock();
            BlockHeader header = smallBlock.getHeader();
            Map<NulsHash, Transaction> txMap = cachedSmallBlock.getTxMap();
            for (Transaction tx : transactions) {
                txMap.put(tx.getHash(), tx);
            }
            Block block = BlockUtil.assemblyBlock(header, txMap, smallBlock.getTxHashList());
            block.setNodeId(nodeId);
            TxGroupRequestor.removeTask(chainId, blockHash);
            boolean b = this.blockService.saveBlock(chainId, block, 1, true, false, true);
            if (!b) {
                SmallBlockCacher.setStatus(chainId, blockHash, BlockForwardEnum.ERROR);
            }
            return;
        }
        if (BlockForwardEnum.EMPTY.equals((Object)status)) {
            logger.error("It is theoretically impossible to enter this branch");
        }
    }
}

