/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.model;

import io.nuls.block.message.HashListMessage;
import java.util.StringJoiner;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class TxGroupTask
implements Delayed {
    private long id;
    private HashListMessage request;
    private String nodeId;
    private long excuteTime;

    public TxGroupTask() {
    }

    public TxGroupTask(long id, HashListMessage request, long delayTime) {
        this.id = id;
        this.request = request;
        this.excuteTime = TimeUnit.NANOSECONDS.convert(delayTime, TimeUnit.MILLISECONDS) + System.nanoTime();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public HashListMessage getRequest() {
        return this.request;
    }

    public void setRequest(HashListMessage request) {
        this.request = request;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public long getExcuteTime() {
        return this.excuteTime;
    }

    public void setExcuteTime(long excuteTime) {
        this.excuteTime = excuteTime;
    }

    @Override
    public int compareTo(Delayed delayed) {
        TxGroupTask msg = (TxGroupTask)delayed;
        return Long.compare(this.id, msg.id);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.excuteTime - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return new StringJoiner(", ", TxGroupTask.class.getSimpleName() + "[", "]").add("id=" + this.id).add("request=" + this.request).add("nodeId='" + this.nodeId + "'").add("excuteTime=" + this.excuteTime).toString();
    }
}

