/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.rpc;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.po.BlockHeaderPo;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.constant.BlockForwardEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.ChainContext;
import io.nuls.block.service.BlockService;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.block.utils.SmallBlockCacher;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.BL)
public class BlockResource
extends BaseCmd {
    @Autowired
    private BlockService service;

    @CmdAnnotation(cmd="info", version=1.0, description="returns network node height and local node height")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Return aMapObject, containing two properties", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="networkHeight", valueType=Long.class, description="The latest block height of network nodes"), @Key(name="localHeight", valueType=Long.class, description="The latest block height of the local node")}))
    public Response info(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        HashMap<String, Long> responseData = new HashMap<String, Long>(2);
        ChainContext context = ContextManager.getContext(chainId);
        if (context == null) {
            return this.success();
        }
        responseData.put("networkHeight", context.getNetworkHeight());
        responseData.put("localHeight", context.getLatestHeight());
        return this.success(responseData);
    }

    @CmdAnnotation(cmd="latestHeight", version=1.0, description="the latest height of master chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Return aMapObject, containing a property", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Long.class, description="Latest main chain height")}))
    public Response latestHeight(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        HashMap<String, Long> responseData = new HashMap<String, Long>(2);
        ChainContext context = ContextManager.getContext(chainId);
        if (context == null) {
            return this.success();
        }
        responseData.put("value", context.getLatestHeight());
        return this.success(responseData);
    }

    @CmdAnnotation(cmd="latestBlockHeader", version=1.0, description="the latest block header of master chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Returns a serialized block headerHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response latestBlockHeader(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            BlockHeader blockHeader = this.service.getLatestBlockHeader(chainId);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            responseData.put("value", RPCUtil.encode((byte[])blockHeader.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="latestBlockHeaderPo", version=1.0, description="the latest block header po of master chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Return a block headerPOSerializedHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response latestBlockHeaderPo(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            BlockHeaderPo blockHeader = this.service.getLatestBlockHeaderPo(chainId);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            responseData.put("value", RPCUtil.encode((byte[])blockHeader.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="latestBlock", version=1.0, description="the latest block of master chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Returns a serialized blockHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response bestBlock(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            Block block = this.service.getLatestBlock(chainId);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            responseData.put("value", RPCUtil.encode((byte[])block.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHeaderByHeight", version=1.0, description="get a block header by height")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Returns a serialized block headerHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockHeaderByHeight(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long height = Long.parseLong(map.get("height").toString());
            BlockHeader blockHeader = this.service.getBlockHeader(chainId, height);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (blockHeader != null) {
                responseData.put("value", RPCUtil.encode((byte[])blockHeader.serialize()));
                return this.success(responseData);
            }
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHeaderPoByHeight", version=1.0, description="get a block header po by height")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return a block headerPOSerializedHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockHeaderPoByHeight(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long height = Long.parseLong(map.get("height").toString());
            BlockHeaderPo po = this.service.getBlockHeaderPo(chainId, height);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (po != null) {
                responseData.put("value", RPCUtil.encode((byte[])po.serialize()));
                return this.success(responseData);
            }
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getLatestBlockHeaders", version=1.0, description="get the latest number of block headers")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="size", requestType=@TypeDescriptor(value=int.class), parameterDes="quantity")})
    @ResponseData(name="Return value", description="Returns the serialized block headerHEXcharacter stringList", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getLatestBlockHeaders(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            int size = Integer.parseInt(map.get("size").toString());
            long latestHeight = ContextManager.getContext(chainId).getLatestHeight();
            long startHeight = latestHeight - (long)size + 1L;
            startHeight = startHeight < 0L ? 0L : startHeight;
            List<BlockHeader> blockHeaders = this.service.getBlockHeader(chainId, startHeight, latestHeight);
            ArrayList<String> hexList = new ArrayList<String>();
            for (BlockHeader blockHeader : blockHeaders) {
                hexList.add(RPCUtil.encode((byte[])blockHeader.serialize()));
            }
            HashMap<String, ArrayList<String>> responseData = new HashMap<String, ArrayList<String>>(2);
            responseData.put("value", hexList);
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getRoundBlockHeaders", version=1.0, description="get the latest several rounds of block headers")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="Starting height"), @Parameter(parameterName="round", requestType=@TypeDescriptor(value=int.class), parameterDes="Consensus round")})
    @ResponseData(name="Return value", description="Returns the serialized block headerHEXcharacter stringList", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getRoundBlockHeaders(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long height = Long.parseLong(map.get("height").toString());
            int round = Integer.parseInt(map.get("round").toString());
            height = height - 1L < 0L ? 0L : height - 1L;
            List<BlockHeader> blockHeaders = this.service.getBlockHeaderByRound(chainId, height, round);
            ArrayList<String> hexList = new ArrayList<String>();
            for (BlockHeader e : blockHeaders) {
                hexList.add(RPCUtil.encode((byte[])e.serialize()));
            }
            HashMap<String, ArrayList<String>> responseData = new HashMap<String, ArrayList<String>>(2);
            responseData.put("value", hexList);
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getLatestRoundBlockHeaders", version=1.0, description="get the latest several rounds of block headers")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="round", requestType=@TypeDescriptor(value=int.class), parameterDes="Consensus round")})
    @ResponseData(name="Return value", description="Returns the serialized block headerHEXcharacter stringList", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getLatestRoundBlockHeaders(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            int round = Integer.parseInt(map.get("round").toString());
            List<BlockHeader> blockHeaders = this.service.getBlockHeaderByRound(chainId, context.getLatestHeight(), round);
            ArrayList<String> hexList = new ArrayList<String>();
            for (BlockHeader e : blockHeaders) {
                hexList.add(RPCUtil.encode((byte[])e.serialize()));
            }
            HashMap<String, ArrayList<String>> responseData = new HashMap<String, ArrayList<String>>(2);
            responseData.put("value", hexList);
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHeadersForProtocol", version=1.0, description="get block headers for protocol upgrade module")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="interval", requestType=@TypeDescriptor(value=int.class), parameterDes="Protocol upgrade statistics interval")})
    @ResponseData(name="Return value", description="Returns the serialized block headerHEXcharacter stringList", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getBlockHeadersForProtocol(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long interval = Integer.parseInt(map.get("interval").toString());
            long latestHeight = context.getLatestHeight();
            HashMap responseData = new HashMap(2);
            if (latestHeight % interval == 0L) {
                return this.success(responseData);
            }
            List<BlockHeader> blockHeaders = this.service.getBlockHeader(chainId, latestHeight - latestHeight % interval + 1L, latestHeight);
            ArrayList<String> hexList = new ArrayList<String>();
            for (BlockHeader blockHeader : blockHeaders) {
                hexList.add(RPCUtil.encode((byte[])blockHeader.serialize()));
            }
            responseData.put("value", hexList);
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHeadersByHeightRange", version=1.0, description="get the block headers according to the height range")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="begin", requestType=@TypeDescriptor(value=long.class), parameterDes="Starting height"), @Parameter(parameterName="end", requestType=@TypeDescriptor(value=long.class), parameterDes="End height")})
    @ResponseData(name="Return value", description="Returns the serialized block headerHEXcharacter stringList", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getBlockHeadersByHeightRange(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long startHeight = Long.parseLong(map.get("begin").toString());
            long endheight = Long.parseLong(map.get("end").toString());
            List<BlockHeader> blockHeaders = this.service.getBlockHeader(chainId, startHeight, endheight);
            ArrayList<String> hexList = new ArrayList<String>();
            for (BlockHeader blockHeader : blockHeaders) {
                hexList.add(RPCUtil.encode((byte[])blockHeader.serialize()));
            }
            HashMap<String, ArrayList<String>> responseData = new HashMap<String, ArrayList<String>>(2);
            responseData.put("value", hexList);
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockByHeight", version=1.0, description="get a block by height")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return the serialized blockHEXcharacter stringList", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockByHeight(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long height = Long.parseLong(map.get("height").toString());
            Block block = this.service.getBlock(chainId, height);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (block == null) {
                return this.success(responseData);
            }
            responseData.put("value", RPCUtil.encode((byte[])block.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="roll_back", version=1.0, description="Roll back a number of blocks")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="successful", responseType=@TypeDescriptor(value=String.class))
    public Response rollback(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long count = Long.parseLong(map.get("height").toString());
            Block block = this.service.getLatestBlock(chainId);
            for (long height = block.getHeader().getHeight(); height > block.getHeader().getHeight() - count; --height) {
                this.service.rollbackBlock(chainId, height, true);
            }
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (block == null) {
                return this.success(responseData);
            }
            responseData.put("value", "success");
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHeaderByHash", version=1.0, description="get a block header by hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="hash", requestType=@TypeDescriptor(value=String.class), parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Returns the serialized block headerHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockHeaderByHash(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            NulsHash hash = NulsHash.fromHex((String)map.get("hash").toString());
            BlockHeader blockHeader = this.service.getBlockHeader(chainId, hash);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (blockHeader == null) {
                return this.success(responseData);
            }
            responseData.put("value", RPCUtil.encode((byte[])blockHeader.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHeaderPoByHash", version=1.0, description="get a block header po by hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="hash", requestType=@TypeDescriptor(value=String.class), parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Return block headerPOSerializedHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockHeaderPoByHash(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            NulsHash hash = NulsHash.fromHex((String)map.get("hash").toString());
            BlockHeaderPo blockHeader = this.service.getBlockHeaderPo(chainId, hash);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (blockHeader == null) {
                return this.success(responseData);
            }
            responseData.put("value", RPCUtil.encode((byte[])blockHeader.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHexByHash", version=1.0, description="get a block header po by hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="hash", requestType=@TypeDescriptor(value=String.class), parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Return block headerPOSerializedHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockHexPoByHash(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            NulsHash hash = NulsHash.fromHex((String)map.get("hash").toString());
            Block block = this.service.getBlock(chainId, hash);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (block == null) {
                return this.success(responseData);
            }
            responseData.put("value", RPCUtil.encode((byte[])block.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockHexByHeight", version=1.0, description="get a block header po by hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return block headerPOSerializedHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockHexPoByHeight(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            long height = Long.parseLong(map.get("height").toString());
            Block block = this.service.getBlock(chainId, height);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (block == null) {
                return this.success(responseData);
            }
            responseData.put("value", RPCUtil.encode((byte[])block.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getBlockByHash", version=1.0, description="get a block by hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="hash", requestType=@TypeDescriptor(value=String.class), parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Return the serialized blockHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public Response getBlockByHash(Map map) {
        try {
            int chainId = Integer.parseInt(map.get("chainId").toString());
            ChainContext context = ContextManager.getContext(chainId);
            if (context == null) {
                return this.success();
            }
            NulsHash hash = NulsHash.fromHex((String)map.get("hash").toString());
            Block block = this.service.getBlock(chainId, hash);
            HashMap<String, String> responseData = new HashMap<String, String>(2);
            if (block == null) {
                return this.success(responseData);
            }
            responseData.put("value", RPCUtil.encode((byte[])block.serialize()));
            return this.success(responseData);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="receivePackingBlock", version=1.0, description="receive the new packaged block")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="block", requestType=@TypeDescriptor(value=String.class), parameterDes="Block serializedHEXcharacter string")})
    @ResponseData(name="Return value", description="No return value")
    public Response receivePackingBlock(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        ChainContext context = ContextManager.getContext(chainId);
        if (context == null) {
            return this.success();
        }
        NulsLogger logger = context.getLogger();
        try {
            Block block = new Block();
            block.parse(new NulsByteBuffer(RPCUtil.decode((String)((String)map.get("block")))));
            logger.debug("recieve block from local node, height:" + block.getHeader().getHeight() + ", hash:" + block.getHeader().getHash());
            if (this.service.saveBlock(chainId, block, 1, true, true, false)) {
                return this.success();
            }
            SmallBlockCacher.setStatus(chainId, block.getHeader().getHash(), BlockForwardEnum.ERROR);
            return this.failed(BlockErrorCode.PARAMETER_ERROR);
        }
        catch (Exception e) {
            logger.error("", e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="getStatus", version=1.0, description="receive the new packaged block")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Return aMapObject, containing a property", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="status", valueType=Integer.class, description="running state")}))
    public Response getStatus(Map map) {
        int chainId = Integer.parseInt(map.get("chainId").toString());
        ChainContext context = ContextManager.getContext(chainId);
        if (context == null) {
            return this.success();
        }
        HashMap<String, Integer> responseData = new HashMap<String, Integer>(2);
        switch (context.getStatus()) {
            case INITIALIZING: 
            case WAITING: 
            case SYNCHRONIZING: {
                responseData.put("status", 0);
                break;
            }
            default: {
                responseData.put("status", 1);
            }
        }
        return this.success(responseData);
    }
}

