/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread;

import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.constant.NodeEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.HeightRangeMessage;
import io.nuls.block.model.BlockDownloaderParams;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.Node;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.common.ConfigBean;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.logback.NulsLogger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class BlockDownloader
implements Callable<Boolean> {
    private int chainId;

    BlockDownloader(int chainId) {
        this.chainId = chainId;
    }

    @Override
    public Boolean call() {
        ChainContext context = ContextManager.getContext(this.chainId);
        BlockDownloaderParams downloaderParams = context.getDownloaderParams();
        List<Node> nodes = downloaderParams.getNodes();
        long netLatestHeight = downloaderParams.getNetLatestHeight();
        long startHeight = downloaderParams.getLocalLatestHeight() + 1L;
        NulsLogger logger = context.getLogger();
        try {
            logger.info("BlockDownloader start work from " + startHeight + " to " + netLatestHeight + ", nodes-" + nodes);
            ConfigBean chainParameters = context.getParameters();
            long cachedBlockSizeLimit = chainParameters.getCachedBlockSizeLimit();
            byte downloadNumber = chainParameters.getDownloadNumber();
            AtomicInteger cachedBlockSize = context.getCachedBlockSize();
            long limit = context.getParameters().getCachedBlockSizeLimit() * 80L / 100L;
            while (startHeight <= netLatestHeight && context.isNeedSyn()) {
                long endHeight;
                HeightRangeMessage message;
                boolean b;
                Node node;
                int cachedSize = cachedBlockSize.get();
                while ((long)cachedSize > cachedBlockSizeLimit) {
                    logger.info("BlockDownloader wait! cached block:" + context.getBlockMap().size() + ", total block size:" + cachedSize);
                    nodes.forEach(e -> e.setCredit(20));
                    Thread.sleep(3000L);
                    cachedSize = cachedBlockSize.get();
                    if (context.isNeedSyn()) continue;
                    return false;
                }
                if ((long)cachedSize > limit) {
                    nodes.forEach(e -> e.setCredit(e.getCredit() / 2));
                }
                if ((node = this.getNode(nodes)) == null) {
                    Thread.sleep(100L);
                    continue;
                }
                int credit = node.getCredit();
                int size = downloadNumber * credit / 100;
                int n = size = size <= 0 ? 1 : size;
                if (startHeight + (long)size > netLatestHeight) {
                    size = (int)(netLatestHeight - startHeight + 1L);
                }
                if (b = NetworkCall.sendToNode(this.chainId, message = new HeightRangeMessage(startHeight, endHeight = startHeight + (long)size - 1L), node.getId(), "getBlocks")) {
                    node.setNodeEnum(NodeEnum.WORKING);
                    node.setStartTime(System.currentTimeMillis());
                    node.setStartHeight(startHeight);
                    node.setEndHeight(endHeight);
                    startHeight += (long)size;
                    continue;
                }
                logger.error("BlockDownloader sendToNode failed!");
            }
            logger.info("BlockDownloader stop work, flag-" + context.isNeedSyn());
        }
        catch (Exception e2) {
            logger.error("", e2);
            context.setNeedSyn(false);
        }
        return context.isNeedSyn();
    }

    private Node getNode(List<Node> nodes) {
        int count = 0;
        for (Node node : nodes) {
            if (node.getNodeEnum().equals((Object)NodeEnum.IDLE)) {
                return node;
            }
            if (!node.getNodeEnum().equals((Object)NodeEnum.TIMEOUT)) continue;
            ++count;
        }
        if (count == nodes.size()) {
            throw new NulsRuntimeException(BlockErrorCode.BLOCK_SYN_ERROR);
        }
        return null;
    }
}

