/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread;

import com.google.common.collect.Lists;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.po.BlockHeaderPo;
import io.nuls.block.BlockBootstrap;
import io.nuls.block.constant.LocalBlockStateEnum;
import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.BlockDownloaderParams;
import io.nuls.block.model.Chain;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.CheckResult;
import io.nuls.block.model.Node;
import io.nuls.block.model.RollbackInfoPo;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.ProtocolCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.service.BlockService;
import io.nuls.block.storage.BlockStorageService;
import io.nuls.block.storage.RollbackStorageService;
import io.nuls.block.thread.BlockConsumer;
import io.nuls.block.thread.BlockDownloader;
import io.nuls.block.utils.BlockUtil;
import io.nuls.block.utils.ChainGenerator;
import io.nuls.common.CommonContext;
import io.nuls.common.ConfigBean;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.DoubleUtils;
import io.nuls.core.thread.ThreadUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.StampedLock;

public class BlockSynchronizer
implements Runnable {
    private static Map<Integer, BlockSynchronizer> synMap = new HashMap<Integer, BlockSynchronizer>();
    private int chainId;
    private boolean running;
    private static boolean firstStart = true;
    private BlockService blockService;

    BlockSynchronizer(int chainId) {
        this.chainId = chainId;
        this.running = false;
        this.blockService = (BlockService)SpringLiteContext.getBean(BlockService.class);
    }

    public static void syn(int chainId) {
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        BlockSynchronizer blockSynchronizer = synMap.computeIfAbsent(chainId, BlockSynchronizer::new);
        if (!blockSynchronizer.isRunning()) {
            logger.info("blockSynchronizer run......");
            ThreadUtils.createAndRunThread((String)"block-synchronizer", (Runnable)blockSynchronizer);
        } else {
            logger.info("blockSynchronizer already running......");
        }
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setRunning(true);
        ChainContext context = ContextManager.getContext(this.chainId);
        context.setStatus(StatusEnum.SYNCHRONIZING);
        NulsLogger logger = context.getLogger();
        try {
            CommonContext.START_BOOT.await();
            BlockStorageService blockStorageService = (BlockStorageService)SpringLiteContext.getBean(BlockStorageService.class);
            long latestHeight = blockStorageService.queryLatestHeight(this.chainId);
            BlockHeaderPo blockHeaderPo = blockStorageService.query(this.chainId, latestHeight);
            if (!blockHeaderPo.isComplete()) {
                logger.info("clean incomplete block between block-syn, incomplete block generated by last failed block-syn");
                if (!ProtocolCall.rollbackNotice(this.chainId, BlockUtil.fromBlockHeaderPo(blockHeaderPo))) {
                    logger.error("ProtocolCall rollback error when clean incomplete block ");
                    System.exit(1);
                }
                if (!TransactionCall.rollback(this.chainId, blockHeaderPo)) {
                    logger.error("TransactionCall rollback error when clean incomplete block ");
                    System.exit(1);
                }
                if (!blockStorageService.remove(this.chainId, latestHeight)) {
                    logger.error("blockStorageService remove error when clean incomplete block ");
                    System.exit(1);
                }
                if (!blockStorageService.setLatestHeight(this.chainId, --latestHeight)) {
                    logger.error("blockStorageService setLatestHeight error when clean incomplete block ");
                    System.exit(1);
                }
                Block block = this.blockService.getBlock(this.chainId, latestHeight);
                context.setLatestBlock(block);
                BlockChainManager.setMasterChain(this.chainId, ChainGenerator.generateMasterChain(this.chainId, block, this.blockService));
            }
            if (firstStart) {
                firstStart = false;
                int testAutoRollbackAmount = BlockBootstrap.blockConfig.getTestAutoRollbackAmount();
                if (testAutoRollbackAmount > 0) {
                    boolean b;
                    if (latestHeight < (long)testAutoRollbackAmount) {
                        testAutoRollbackAmount = (int)latestHeight;
                    }
                    for (int i = 0; i < testAutoRollbackAmount && (b = this.blockService.rollbackBlock(this.chainId, latestHeight--, true)) && latestHeight != 0L; ++i) {
                    }
                }
                this.rollbackToHeight(latestHeight, this.chainId);
            }
            while (!this.synchronize()) {
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
        finally {
            this.setRunning(false);
        }
    }

    private void rollbackToHeight(long latestHeight, int chainId) {
        RollbackStorageService rollbackService;
        RollbackInfoPo po;
        NulsCoresConfig blockConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
        long height = blockConfig.getRollbackHeight();
        if (height > 0L && ((po = (rollbackService = (RollbackStorageService)SpringLiteContext.getBean(RollbackStorageService.class)).get(chainId)) == null || po.getHeight() != height)) {
            if (latestHeight > height + 1000L) {
                ContextManager.getContext(chainId).getLogger().warn("If the rollback height is greater than 1000,p;ease replace the data package");
                System.exit(1);
            }
            while (latestHeight >= height) {
                if (!this.blockService.rollbackBlock(chainId, latestHeight--, true)) {
                    ++latestHeight;
                }
                if (latestHeight != 0L) continue;
            }
            po = new RollbackInfoPo(height);
            rollbackService.save(po, chainId);
        }
    }

    private List<Node> waitUntilNetworkStable() throws InterruptedException {
        ChainContext context = ContextManager.getContext(this.chainId);
        ConfigBean parameters = context.getParameters();
        int waitNetworkInterval = parameters.getWaitNetworkInterval();
        byte minNodeAmount = parameters.getMinNodeAmount();
        NulsLogger logger = context.getLogger();
        int count = 0;
        while (true) {
            List<Node> availableNodes;
            int nodeAmount;
            count = (nodeAmount = (availableNodes = NetworkCall.getAvailableNodes(this.chainId)).size()) >= minNodeAmount ? ++count : 0;
            logger.info("minNodeAmount = " + minNodeAmount + ", current nodes amount=" + nodeAmount + ", wait until network stable......");
            if (count >= 5) {
                return availableNodes;
            }
            Thread.sleep(waitNetworkInterval);
        }
    }

    private boolean synchronize() throws Exception {
        NulsLogger logger = ContextManager.getContext(this.chainId).getLogger();
        List<Node> availableNodes = this.waitUntilNetworkStable();
        ChainContext context = ContextManager.getContext(this.chainId);
        ConfigBean parameters = context.getParameters();
        byte minNodeAmount = parameters.getMinNodeAmount();
        if (minNodeAmount == 0 && availableNodes.isEmpty()) {
            logger.info("Skip block syn, because minNodeAmount is set to 0, minNodeAmount should't set to 0 otherwise you want run local node without connect with network");
            context.setStatus(StatusEnum.RUNNING);
            ConsensusCall.notice(this.chainId, 1);
            TransactionCall.notice(this.chainId, 1);
            return true;
        }
        BlockDownloaderParams downloaderParams = this.statistics(availableNodes, context);
        context.setDownloaderParams(downloaderParams);
        if (downloaderParams.getNodes() == null || downloaderParams.getNodes().isEmpty()) {
            logger.warn("There are no consistent nodes available on the network, availableNodes-" + availableNodes);
            return false;
        }
        int size = downloaderParams.getNodes().size();
        if (downloaderParams.getNetLatestHeight() == 0L && size == availableNodes.size()) {
            logger.info("This blockchain just started running, no one has been generated a block");
            context.setStatus(StatusEnum.RUNNING);
            ConsensusCall.notice(this.chainId, 1);
            TransactionCall.notice(this.chainId, 1);
            return true;
        }
        LocalBlockStateEnum stateEnum = this.checkLocalBlock(downloaderParams);
        if (stateEnum.equals((Object)LocalBlockStateEnum.CONSISTENT)) {
            logger.info("The local node's block is the latest height and does not need to be synchronized");
            context.setStatus(StatusEnum.RUNNING);
            ConsensusCall.notice(this.chainId, 1);
            TransactionCall.notice(this.chainId, 1);
            return true;
        }
        if (stateEnum.equals((Object)LocalBlockStateEnum.UNCERTAINTY)) {
            logger.warn("The number of rolled back blocks exceeded the configured value");
            NetworkCall.resetNetwork(this.chainId);
            return false;
        }
        if (stateEnum.equals((Object)LocalBlockStateEnum.CONFLICT)) {
            logger.error("The local genesis block is different from networks");
            System.exit(1);
        }
        long netLatestHeight = downloaderParams.getNetLatestHeight();
        context.setNetworkHeight(netLatestHeight);
        long startHeight = downloaderParams.getLocalLatestHeight() + 1L;
        long total = netLatestHeight - startHeight + 1L;
        long start = System.currentTimeMillis();
        BlockDownloader downloader = new BlockDownloader(this.chainId);
        Future downloadFutrue = ThreadUtils.asynExecuteCallable((Callable)downloader);
        BlockConsumer consumer = new BlockConsumer(this.chainId);
        Future consumerFuture = ThreadUtils.asynExecuteCallable((Callable)consumer);
        Boolean downResult = (Boolean)downloadFutrue.get();
        Boolean storageResult = (Boolean)consumerFuture.get();
        boolean success = downResult != null && downResult != false && storageResult != null && storageResult != false;
        long end = System.currentTimeMillis();
        if (success) {
            logger.info("Block syn complete, total download:" + total + ", total time:" + (end - start) + ", average time:" + (end - start) / total);
            if (this.checkIsNewest(context)) {
                logger.info("Block syn complete successfully, current height-" + downloaderParams.getNetLatestHeight());
                context.setNeedSyn(false);
                context.setStatus(StatusEnum.RUNNING);
                ConsensusCall.notice(this.chainId, 1);
                TransactionCall.notice(this.chainId, 1);
                return true;
            }
            logger.info("Block syn complete but another syn is needed");
        } else {
            logger.error("Block syn fail, downResult:" + downResult + ", storageResult:" + storageResult);
        }
        context.setNeedSyn(true);
        context.getBlockMap().clear();
        context.getCachedBlockSize().set(0);
        context.setDownloaderParams(null);
        return false;
    }

    private boolean checkIsNewest(ChainContext context) {
        BlockDownloaderParams newestParams = this.statistics(NetworkCall.getAvailableNodes(this.chainId), context);
        return newestParams.getNetLatestHeight() <= context.getLatestBlock().getHeader().getHeight();
    }

    BlockDownloaderParams statistics(List<Node> availableNodes, ChainContext context) {
        byte percent;
        BlockDownloaderParams params = new BlockDownloaderParams();
        List<Node> filterAvailableNodes = this.filterNodes(availableNodes, context);
        params.setAvailableNodesCount(filterAvailableNodes.size());
        if (filterAvailableNodes.isEmpty()) {
            return params;
        }
        Object key = "";
        int count = 0;
        HashMap<CallSite, ArrayList> nodeMap = new HashMap<CallSite, ArrayList>(filterAvailableNodes.size());
        HashMap<CallSite, Integer> countMap = new HashMap<CallSite, Integer>(filterAvailableNodes.size());
        String highestKey = null;
        long highest = 0L;
        for (Node node : filterAvailableNodes) {
            String tempKey = node.getHash().toHex() + node.getHeight();
            if (node.getHeight() > highest) {
                highestKey = tempKey;
                highest = node.getHeight();
            }
            if (countMap.containsKey(tempKey)) {
                countMap.put((CallSite)((Object)tempKey), (Integer)countMap.get(tempKey) + 1);
            } else {
                countMap.put((CallSite)((Object)tempKey), 1);
            }
            if (nodeMap.containsKey(tempKey)) {
                List nodes = (List)nodeMap.get(tempKey);
                nodes.add(node);
                continue;
            }
            nodeMap.put((CallSite)((Object)tempKey), Lists.newArrayList((Object[])new Node[]{node}));
        }
        for (Map.Entry entry : countMap.entrySet()) {
            Integer value = (Integer)entry.getValue();
            if (value <= count) continue;
            count = value;
            key = (String)entry.getKey();
        }
        ConfigBean parameters = context.getParameters();
        double d = DoubleUtils.div((double)count, (double)filterAvailableNodes.size(), (int)2);
        if (d * 100.0 < (double)(percent = this.calculateConsistencyNodePercent(parameters.getConsistencyNodePercent(), filterAvailableNodes.size()))) {
            key = highestKey;
        }
        List nodeList = (List)nodeMap.get(key);
        params.setNodes(nodeList);
        ConcurrentHashMap<String, Node> statusMap = new ConcurrentHashMap<String, Node>();
        nodeList.forEach(e -> statusMap.put(e.getId(), (Node)e));
        params.setNodeMap(statusMap);
        Node node = (Node)nodeList.get(0);
        params.setNetLatestHash(node.getHash());
        params.setNetLatestHeight(node.getHeight());
        StampedLock lock = context.getLock();
        long stamp = lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    params.setLocalLatestHeight(context.getLatestHeight());
                    params.setLocalLatestHash(context.getLatestBlock().getHeader().getHash());
                    if (lock.validate(stamp)) {
                        BlockDownloaderParams blockDownloaderParams = params;
                        return blockDownloaderParams;
                    }
                }
                stamp = lock.readLock();
            }
        }
        finally {
            if (StampedLock.isReadLockStamp(stamp)) {
                lock.unlockRead(stamp);
            }
        }
    }

    private List<Node> filterNodes(List<Node> availableNodes, ChainContext context) {
        availableNodes.removeIf(availableNode -> availableNode.getHeight() < context.getLatestHeight() - (long)context.getParameters().getHeightRange());
        Chain masterChain = BlockChainManager.getMasterChain(this.chainId);
        availableNodes.removeIf(availableNode -> masterChain.getHashList().contains(availableNode.getHash()) && availableNode.getHeight() < context.getLatestHeight());
        return availableNodes;
    }

    private byte calculateConsistencyNodePercent(byte consistencyNodePercent, int size) {
        byte percent = consistencyNodePercent;
        return (percent = (byte)(percent - (size / 4 - 1) * 5)) < 50 ? (byte)50 : (byte)percent;
    }

    private LocalBlockStateEnum checkLocalBlock(BlockDownloaderParams params) {
        long localHeight = params.getLocalLatestHeight();
        long netHeight = params.getNetLatestHeight();
        long commonHeight = Math.min(localHeight, netHeight);
        CheckResult result = this.checkHashEquality(params);
        if (result.isResult() || result.isTimeout()) {
            if (commonHeight < netHeight) {
                return LocalBlockStateEnum.INCONSISTENT;
            }
            return LocalBlockStateEnum.CONSISTENT;
        }
        return this.checkRollback(0, params);
    }

    private LocalBlockStateEnum checkRollback(int rollbackCount, BlockDownloaderParams params) {
        ConfigBean parameters = ContextManager.getContext(this.chainId).getParameters();
        if (params.getLocalLatestHeight() == 0L) {
            return LocalBlockStateEnum.CONFLICT;
        }
        if (rollbackCount >= parameters.getMaxRollback()) {
            return LocalBlockStateEnum.UNCERTAINTY;
        }
        this.blockService.rollbackBlock(this.chainId, params.getLocalLatestHeight(), true);
        BlockHeader latestBlockHeader = this.blockService.getLatestBlockHeader(this.chainId);
        params.setLocalLatestHeight(latestBlockHeader.getHeight());
        params.setLocalLatestHash(latestBlockHeader.getHash());
        CheckResult result = this.checkHashEquality(params);
        if (result.isResult() || result.isTimeout()) {
            return LocalBlockStateEnum.INCONSISTENT;
        }
        return this.checkRollback(rollbackCount + 1, params);
    }

    private CheckResult checkHashEquality(BlockDownloaderParams params) {
        NulsHash localHash = params.getLocalLatestHash();
        long localHeight = params.getLocalLatestHeight();
        long netHeight = params.getNetLatestHeight();
        NulsHash netHash = params.getNetLatestHash();
        long commonHeight = Math.min(localHeight, netHeight);
        if (commonHeight < netHeight) {
            for (Node node : params.getNodes()) {
                Block remoteBlock = BlockUtil.downloadBlockByHash(this.chainId, localHash, node.getId(), commonHeight);
                if (remoteBlock == null) continue;
                netHash = remoteBlock.getHeader().getHash();
                return new CheckResult(localHash.equals((Object)netHash), false);
            }
            return new CheckResult(false, true);
        }
        if (commonHeight < localHeight) {
            localHash = this.blockService.getBlockHash(this.chainId, commonHeight);
        }
        return new CheckResult(localHash.equals((Object)netHash), false);
    }
}

