/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.utils;

import io.nuls.base.cache.DataCacher;
import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.block.message.BlockMessage;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class SingleBlockCacher {
    private static Map<Integer, DataCacher<Block>> blockCacher = new ConcurrentHashMap<Integer, DataCacher<Block>>();

    public static void init(int chainId) {
        blockCacher.put(chainId, (DataCacher<Block>)new DataCacher());
    }

    public static CompletableFuture<Block> addRequest(int chainId, NulsHash requestHash) {
        return blockCacher.get(chainId).addFuture(requestHash);
    }

    public static void receiveBlock(int chainId, BlockMessage message) {
        NulsHash requestHash = message.getRequestHash();
        Block block = message.getBlock();
        blockCacher.get(chainId).complete(requestHash, (Object)block);
    }

    public static void removeRequest(int chainId, NulsHash hash) {
        blockCacher.get(chainId).removeFuture(hash);
    }
}

