/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel(description="Asset Chain Information")
public class RegChainDto {
    @ApiModelProperty(description="chainid")
    private int chainId;
    @ApiModelProperty(description="Chain Name")
    private String chainName;
    @ApiModelProperty(description="Address type\uff081\uff1aNulsEcology,2\uff1aother\uff09")
    private String addressType;
    @ApiModelProperty(description="Address prefix")
    private String addressPrefix;
    @ApiModelProperty(description="Magic parameters")
    private long magicNumber;
    @ApiModelProperty(description="Minimum number of available nodes")
    private int minAvailableNodeNum;
    @ApiModelProperty(description="Number of transaction confirmation blocks")
    private int txConfirmedBlockNum;
    @ApiModelProperty(description="Has it been cancelled")
    private boolean isDelete = false;
    @ApiModelProperty(description="Creation time")
    private long createTime;
    @ApiModelProperty(description="The address used when registering the chain")
    private String regAddress;
    @ApiModelProperty(description="Transaction hash during registration chain")
    private String regTxHash;
    @ApiModelProperty(description="Asset serial number added during registration chain")
    private int regAssetId;
    @ApiModelProperty(description="All assets created in this chain,Key=chaiId_assetId")
    List<String> selfAssetKeyList = new ArrayList<String>();
    @ApiModelProperty(description="All assets circulating on the chain,Key=chaiId_assetId")
    List<String> totalAssetKeyList = new ArrayList<String>();
    @ApiModelProperty(description="Verifier List")
    List<String> verifierList = new ArrayList<String>();
    @ApiModelProperty(description="Byzantine proportion")
    int signatureByzantineRatio = 0;
    @ApiModelProperty(description="Maximum number of signatures")
    int maxSignatureCount = 0;
    @ApiModelProperty(description="List of main network validators,Comma separated")
    String mainNetVerifierSeeds = "";
    @ApiModelProperty(description="Main network connection seeds provided across chains,Comma separated")
    String mainNetCrossConnectSeeds = "";
    @ApiModelProperty(description="Is it available")
    boolean enable = true;

    public void buildRegChainDto(BlockChain blockChain) {
        this.addressType = blockChain.getAddressType();
        this.addressPrefix = blockChain.getAddressPrefix();
        this.chainId = blockChain.getChainId();
        this.regAssetId = blockChain.getRegAssetId();
        this.chainName = blockChain.getChainName();
        this.magicNumber = blockChain.getMagicNumber();
        this.regTxHash = blockChain.getRegTxHash();
        this.isDelete = blockChain.isDelete();
        this.minAvailableNodeNum = blockChain.getMinAvailableNodeNum();
        this.selfAssetKeyList = blockChain.getSelfAssetKeyList();
        this.totalAssetKeyList = blockChain.getTotalAssetKeyList();
        this.regAddress = AddressTool.getStringAddressByBytes((byte[])blockChain.getRegAddress());
        this.createTime = blockChain.getCreateTime();
        this.verifierList = blockChain.getVerifierList();
        this.maxSignatureCount = blockChain.getMaxSignatureCount();
        this.signatureByzantineRatio = blockChain.getSignatureByzantineRatio();
        if (blockChain.isDelete()) {
            this.enable = false;
        }
    }

    public List<String> getVerifierList() {
        return this.verifierList;
    }

    public void setVerifierList(List<String> verifierList) {
        this.verifierList = verifierList;
    }

    public int getSignatureByzantineRatio() {
        return this.signatureByzantineRatio;
    }

    public void setSignatureByzantineRatio(int signatureByzantineRatio) {
        this.signatureByzantineRatio = signatureByzantineRatio;
    }

    public int getMaxSignatureCount() {
        return this.maxSignatureCount;
    }

    public void setMaxSignatureCount(int maxSignatureCount) {
        this.maxSignatureCount = maxSignatureCount;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    public int getMinAvailableNodeNum() {
        return this.minAvailableNodeNum;
    }

    public void setMinAvailableNodeNum(int minAvailableNodeNum) {
        this.minAvailableNodeNum = minAvailableNodeNum;
    }

    public int getTxConfirmedBlockNum() {
        return this.txConfirmedBlockNum;
    }

    public void setTxConfirmedBlockNum(int txConfirmedBlockNum) {
        this.txConfirmedBlockNum = txConfirmedBlockNum;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setDelete(boolean delete) {
        this.isDelete = delete;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getRegAddress() {
        return this.regAddress;
    }

    public void setRegAddress(String regAddress) {
        this.regAddress = regAddress;
    }

    public String getRegTxHash() {
        return this.regTxHash;
    }

    public void setRegTxHash(String regTxHash) {
        this.regTxHash = regTxHash;
    }

    public int getRegAssetId() {
        return this.regAssetId;
    }

    public void setRegAssetId(int regAssetId) {
        this.regAssetId = regAssetId;
    }

    public List<String> getSelfAssetKeyList() {
        return this.selfAssetKeyList;
    }

    public void setSelfAssetKeyList(List<String> selfAssetKeyList) {
        this.selfAssetKeyList = selfAssetKeyList;
    }

    public List<String> getTotalAssetKeyList() {
        return this.totalAssetKeyList;
    }

    public void setTotalAssetKeyList(List<String> totalAssetKeyList) {
        this.totalAssetKeyList = totalAssetKeyList;
    }

    public String getAddressPrefix() {
        return this.addressPrefix;
    }

    public void setAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
    }

    public String getMainNetVerifierSeeds() {
        return this.mainNetVerifierSeeds;
    }

    public void setMainNetVerifierSeeds(String mainNetVerifierSeeds) {
        this.mainNetVerifierSeeds = mainNetVerifierSeeds;
    }

    public String getMainNetCrossConnectSeeds() {
        return this.mainNetCrossConnectSeeds;
    }

    public void setMainNetCrossConnectSeeds(String mainNetCrossConnectSeeds) {
        this.mainNetCrossConnectSeeds = mainNetCrossConnectSeeds;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

