/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.chain.info.CmConstants;
import io.nuls.chain.info.CmErrorCode;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.AccountBalance;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.message.Response;
import java.math.BigInteger;
import java.util.List;

public class BaseChainCmd
extends BaseCmd {
    boolean isMainAsset(String assetKey) {
        return CmRuntimeInfo.getMainAssetKey().equals(assetKey);
    }

    Response parseTxs(List<String> txHexList, List<Transaction> txList) {
        for (String txHex : txHexList) {
            if (StringUtils.isBlank((String)txHex)) {
                return this.failed("txHex is blank");
            }
            byte[] txStream = RPCUtil.decode((String)txHex);
            Transaction tx = new Transaction();
            try {
                tx.parse(new NulsByteBuffer(txStream));
                txList.add(tx);
            }
            catch (NulsException e) {
                LoggerUtil.logger().error("transaction parse error", (Exception)((Object)e));
                return this.failed("transaction parse error");
            }
        }
        return this.success();
    }

    CoinData getRegCoinData(Asset asset, int nulsChainId, int nulsAssetId, int txSize, AccountBalance accountBalance) throws NulsRuntimeException {
        txSize += 110;
        CoinData coinData = new CoinData();
        BigInteger lockAmount = asset.getDepositNuls().subtract(asset.getDestroyNuls());
        CoinTo to1 = new CoinTo(asset.getAddress(), nulsChainId, nulsAssetId, lockAmount, -1L);
        CoinTo to2 = new CoinTo(CmConstants.BLACK_HOLE_ADDRESS, nulsChainId, nulsAssetId, asset.getDestroyNuls(), 0L);
        coinData.addTo(to1);
        coinData.addTo(to2);
        CoinFrom from = new CoinFrom(asset.getAddress(), nulsChainId, nulsAssetId, asset.getDepositNuls(), accountBalance.getNonce(), 0);
        coinData.addFrom(from);
        txSize += to1.size();
        txSize += to2.size();
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)(txSize += from.size()), (long)100000L);
        String fromAmount = BigIntegerUtils.bigIntegerToString((BigInteger)asset.getDepositNuls().add(fee));
        if (BigIntegerUtils.isLessThan((String)accountBalance.getAvailable(), (String)fromAmount)) {
            throw new NulsRuntimeException(CmErrorCode.BALANCE_NOT_ENOUGH);
        }
        from.setAmount(BigIntegerUtils.stringToBigInteger((String)fromAmount));
        return coinData;
    }

    CoinData getRegCoinDataV7(Asset asset, int nulsChainId, int nulsAssetId, int txSize, AccountBalance accountBalance) throws NulsRuntimeException {
        txSize += 110;
        CoinData coinData = new CoinData();
        CoinFrom from = new CoinFrom(asset.getAddress(), nulsChainId, nulsAssetId, BigInteger.ZERO, accountBalance.getNonce(), 0);
        CoinTo to = new CoinTo(CmConstants.BLACK_HOLE_ADDRESS, nulsChainId, nulsAssetId, BigInteger.ZERO, 0L);
        coinData.addFrom(from);
        coinData.addTo(to);
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)(txSize += from.size()), (long)100000L);
        String fromAmount = BigIntegerUtils.bigIntegerToString((BigInteger)fee);
        if (BigIntegerUtils.isLessThan((String)accountBalance.getAvailable(), (String)fromAmount)) {
            throw new NulsRuntimeException(CmErrorCode.BALANCE_NOT_ENOUGH);
        }
        from.setAmount(BigIntegerUtils.stringToBigInteger((String)fromAmount));
        return coinData;
    }

    CoinData getDisableCoinData(Asset asset, int nulsChainId, int nulsAssetId, int txSize, AccountBalance accountBalance) throws NulsRuntimeException {
        txSize += 110;
        BigInteger lockAmount = asset.getDepositNuls().subtract(asset.getDestroyNuls());
        CoinTo to = new CoinTo(asset.getAddress(), nulsChainId, nulsAssetId, lockAmount, 0L);
        CoinData coinData = new CoinData();
        if (lockAmount.equals(BigInteger.ZERO)) {
            CoinFrom from = new CoinFrom(asset.getAddress(), nulsChainId, nulsAssetId, BigInteger.ZERO, accountBalance.getNonce(), 0);
            coinData.addFrom(from);
            coinData.addTo(to);
            BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)(txSize += from.size()), (long)100000L);
            String fromAmount = BigIntegerUtils.bigIntegerToString((BigInteger)fee);
            if (BigIntegerUtils.isLessThan((String)accountBalance.getAvailable(), (String)fromAmount)) {
                throw new NulsRuntimeException(CmErrorCode.BALANCE_NOT_ENOUGH);
            }
            from.setAmount(fee);
        } else {
            CoinFrom from = new CoinFrom(asset.getAddress(), nulsChainId, nulsAssetId, lockAmount, TxUtil.getNonceByTxHash(asset.getTxHash()), -1);
            coinData.addFrom(from);
            coinData.addTo(to);
            txSize += to.size();
            BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)(txSize += from.size()), (long)100000L);
            to.setAmount(lockAmount.subtract(fee));
        }
        return coinData;
    }
}

