/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.impl;

import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.storage.AssetStorage;
import io.nuls.chain.storage.ChainAssetStorage;
import io.nuls.chain.storage.ChainCirculateStorage;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class AssetServiceImpl
implements AssetService {
    @Autowired
    private AssetStorage assetStorage;
    @Autowired
    private ChainAssetStorage chainAssetStorage;
    @Autowired
    private ChainService chainService;
    @Autowired
    private RpcService rpcService;
    @Autowired
    private NulsCoresConfig nulsChainConfig;
    @Autowired
    private ChainCirculateStorage chainCirculateStorage;

    @Override
    public void deleteAsset(Asset asset) throws Exception {
        String assetKey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId());
        asset.setAvailable(false);
        this.assetStorage.save(assetKey, asset);
    }

    @Override
    public void createAsset(Asset asset) throws Exception {
        String assetKey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId());
        String key = CmRuntimeInfo.getChainAssetKey(asset.getChainId(), assetKey);
        asset.addChainId(asset.getChainId());
        this.assetStorage.save(assetKey, asset);
        ChainAsset chainAsset = new ChainAsset();
        chainAsset.setAddressChainId(asset.getChainId());
        chainAsset.setAssetChainId(asset.getChainId());
        chainAsset.setAssetId(asset.getAssetId());
        chainAsset.setInitNumber(asset.getInitNumber());
        this.chainAssetStorage.save(key, chainAsset);
    }

    @Override
    public void saveOrUpdateChainAsset(int chainId, ChainAsset chainAsset) throws Exception {
        String assetKey = CmRuntimeInfo.getAssetKey(chainAsset.getAssetChainId(), chainAsset.getAssetId());
        String key = CmRuntimeInfo.getChainAssetKey(chainId, assetKey);
        LoggerUtil.logger().debug("key={},assetInfo:inAmount={},outAmount={}", new Object[]{key, chainAsset.getInNumber(), chainAsset.getOutNumber()});
        this.chainAssetStorage.save(key, chainAsset);
    }

    @Override
    public void batchSaveOrUpdateChainAsset(Map<String, ChainAsset> chainAssets) throws Exception {
        HashMap<byte[], byte[]> kvs = new HashMap<byte[], byte[]>();
        for (Map.Entry<String, ChainAsset> entry : chainAssets.entrySet()) {
            kvs.put(entry.getKey().getBytes(this.nulsChainConfig.getEncoding()), entry.getValue().serialize());
        }
        this.chainAssetStorage.batchSave(kvs);
    }

    @Override
    public void saveMsgChainCirculateAmount(String key, BigInteger amount) throws Exception {
        this.chainCirculateStorage.save(key, amount);
    }

    @Override
    public void registerAsset(Asset asset) throws Exception {
        this.createAsset(asset);
        BlockChain dbChain = this.chainService.getChain(asset.getChainId());
        List<String> selfAssets = dbChain.getSelfAssetKeyList();
        boolean notExist = true;
        for (String assetKey : selfAssets) {
            String addAssetkey;
            if (!assetKey.equalsIgnoreCase(addAssetkey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()))) continue;
            notExist = false;
            break;
        }
        if (notExist) {
            dbChain.addCreateAssetId(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()));
            dbChain.addCirculateAssetId(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()));
        } else {
            dbChain.setSelfAssetKeyList(TxUtil.moveRepeatInfo(dbChain.getSelfAssetKeyList()));
            dbChain.setTotalAssetKeyList(TxUtil.moveRepeatInfo(dbChain.getTotalAssetKeyList()));
        }
        this.chainService.updateChain(dbChain);
    }

    @Override
    public void updateAsset(Asset asset) throws Exception {
        String assetKey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId());
        this.assetStorage.save(assetKey, asset);
    }

    @Override
    public void batchUpdateAsset(Map<String, Asset> assetMap) throws Exception {
        HashMap<byte[], byte[]> kvs = new HashMap<byte[], byte[]>();
        for (Map.Entry<String, Asset> entry : assetMap.entrySet()) {
            kvs.put(entry.getKey().getBytes(this.nulsChainConfig.getEncoding()), entry.getValue().serialize());
        }
        this.assetStorage.batchSave(kvs);
    }

    @Override
    public Asset getAsset(String assetKey) throws Exception {
        Asset asset = this.assetStorage.load(assetKey);
        return asset;
    }

    @Override
    public void setStatus(String assetKey, boolean available) throws Exception {
        Asset asset = this.assetStorage.load(assetKey);
        if (asset == null) {
            throw new Exception("assetKey not exist: " + assetKey);
        }
        asset.setAvailable(available);
        asset.setLastUpdateTime(NulsDateUtils.getCurrentTimeMillis());
        this.assetStorage.save(assetKey, asset);
    }

    @Override
    public List<Asset> getAssets(List<String> assetKeys) throws Exception {
        ArrayList<Asset> rtList = new ArrayList<Asset>();
        for (String assetKey : assetKeys) {
            Asset asset = this.getAsset(assetKey);
            if (null == asset) continue;
            rtList.add(asset);
        }
        return rtList;
    }

    @Override
    public boolean assetExist(Asset asset) throws Exception {
        Asset dbAsset = this.assetStorage.load(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()));
        return dbAsset != null;
    }

    @Override
    public boolean assetExistAndAvailable(Asset asset) throws Exception {
        Asset dbAsset = this.assetStorage.load(CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId()));
        return dbAsset != null && dbAsset.isAvailable();
    }

    @Override
    public boolean assetExist(Asset asset, Map<String, Integer> map) throws Exception {
        String assetKey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId());
        Asset dbAsset = this.assetStorage.load(assetKey);
        return dbAsset != null || null != map.get(assetKey);
    }

    @Override
    public boolean regChainAssetExist(Asset asset, Map<String, Integer> map) throws Exception {
        String assetKey = CmRuntimeInfo.getAssetKey(asset.getChainId(), asset.getAssetId());
        Asset dbAsset = this.assetStorage.load(assetKey);
        return dbAsset != null && dbAsset.isAvailable() || null != map.get(assetKey);
    }

    @Override
    public ChainAsset getChainAsset(int chainId, String assetKey) throws Exception {
        BigInteger amount;
        String chainAssetKey = CmRuntimeInfo.getChainAssetKey(chainId, assetKey);
        ChainAsset chainAsset = this.chainAssetStorage.load(chainAssetKey);
        if (null != chainAsset && BigIntegerUtils.isGreaterThan((BigInteger)chainAsset.getInitNumber(), (BigInteger)BigInteger.ZERO) && CmRuntimeInfo.isAddressChainEqAssetChain(chainId, assetKey) && null != (amount = this.chainCirculateStorage.load(assetKey))) {
            chainAsset.setInitNumber(amount);
        }
        return chainAsset;
    }

    @Override
    public ChainAsset getChainAsset(String chainAssetKey) throws Exception {
        return this.chainAssetStorage.load(chainAssetKey);
    }
}

