/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.service.impl;

import io.nuls.base.data.Transaction;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.storage.ChainStorage;
import io.nuls.chain.util.TxUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.model.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Service
public class ChainServiceImpl
implements ChainService {
    @Autowired
    private NulsCoresConfig nulsChainConfig;
    @Autowired
    private ChainStorage chainStorage;
    @Autowired
    private AssetService assetService;
    @Autowired
    private RpcService rpcService;
    private static Map<String, Object> chainNetMagicNumberMap = new HashMap<String, Object>();
    private static Map<String, Object> chainNameMap = new HashMap<String, Object>();

    @Override
    public void addChainMapInfo(BlockChain blockChain) {
        chainNetMagicNumberMap.put(String.valueOf(blockChain.getMagicNumber()), 1);
        chainNameMap.put(blockChain.getChainName(), 1);
    }

    public void removeChainMapInfo(long magicNumber, String chainName) {
        chainNetMagicNumberMap.remove(String.valueOf(magicNumber));
        chainNameMap.remove(chainName);
    }

    @Override
    public boolean hadExistMagicNumber(long magicNumber) {
        return null != chainNetMagicNumberMap.get(String.valueOf(magicNumber));
    }

    @Override
    public boolean hadExistChainName(String chainName) {
        return null != chainNameMap.get(chainName);
    }

    @Override
    public void initRegChainDatas(long mainNetMagicNumber) throws Exception {
        chainNetMagicNumberMap.put(String.valueOf(mainNetMagicNumber), 1);
        List<BlockChain> list = this.getBlockList();
        for (BlockChain blockChain : list) {
            chainNetMagicNumberMap.put(String.valueOf(blockChain.getMagicNumber()), 1);
            chainNameMap.put(blockChain.getChainName(), 1);
        }
    }

    @Override
    public void initMainChain() throws Exception {
        int chainId = this.nulsChainConfig.getMainChainId();
        BlockChain chain = this.getChain(chainId);
        if (chain != null) {
            return;
        }
        chain = new BlockChain();
        int assetId = this.nulsChainConfig.getMainAssetId();
        chain.setChainId(chainId);
        chain.setRegAssetId(assetId);
        chain.setChainName(this.nulsChainConfig.getChainName());
        chain.setAddressPrefix(this.nulsChainConfig.getAddressPrefix());
        chain.addCreateAssetId(CmRuntimeInfo.getAssetKey(chainId, assetId));
        chain.addCirculateAssetId(CmRuntimeInfo.getAssetKey(chainId, assetId));
        this.chainStorage.save(chainId, chain);
        Asset asset = new Asset();
        asset.setChainId(chainId);
        asset.setAssetId(assetId);
        asset.setInitNumber(new BigInteger(this.nulsChainConfig.getNulsAssetInitNumberMax()));
        asset.setSymbol(this.nulsChainConfig.getMainSymbol());
        this.assetService.createAsset(asset);
        if (chainId == 1) {
            BlockChain chain2 = new BlockChain();
            chain2.setChainId(2);
            chain2.setRegAssetId(1);
            chain2.setChainName("NULS-testnet");
            chain2.setAddressPrefix("tNULS");
            chain2.addCreateAssetId("2-1");
            chain2.addCirculateAssetId("2-1");
            this.chainStorage.save(2, chain2);
            Asset asset2 = new Asset();
            asset2.setChainId(2);
            asset2.setAssetId(1);
            asset2.setInitNumber(BigInteger.valueOf(10000000000000000L));
            asset2.setSymbol("tNULS");
            this.assetService.createAsset(asset2);
        }
    }

    @Override
    public void saveChain(BlockChain blockChain) throws Exception {
        this.addChainMapInfo(blockChain);
        this.chainStorage.save(blockChain.getChainId(), blockChain);
    }

    @Override
    public void updateChain(BlockChain blockChain) throws Exception {
        this.chainStorage.update(blockChain.getChainId(), blockChain);
    }

    @Override
    public void batchUpdateChain(Map<String, BlockChain> assetMap) throws Exception {
        HashMap<byte[], byte[]> kvs = new HashMap<byte[], byte[]>();
        for (Map.Entry<String, BlockChain> entry : assetMap.entrySet()) {
            kvs.put(ByteUtils.intToBytes((int)entry.getValue().getChainId()), entry.getValue().serialize());
        }
        this.chainStorage.batchUpdate(kvs);
    }

    @Override
    public void delChain(BlockChain blockChain) throws Exception {
        this.chainStorage.delete(blockChain.getChainId());
    }

    @Override
    public BlockChain getChain(int chainId) throws Exception {
        return this.chainStorage.load(chainId);
    }

    @Override
    public boolean chainExist(int chainId) throws Exception {
        BlockChain blockChain = this.getChain(chainId);
        return null != blockChain && !blockChain.isDelete();
    }

    @Override
    public void registerBlockChain(BlockChain blockChain, Asset asset) throws Exception {
        this.assetService.createAsset(asset);
        this.saveChain(blockChain);
        this.rpcService.createCrossGroup(blockChain);
    }

    @Override
    public void rpcBlockChainRollback(List<Transaction> txs, long time) throws Exception {
        for (Transaction tx : txs) {
            switch (tx.getType()) {
                case 11: {
                    BlockChain blockChain = TxUtil.buildChainWithTxData(tx, false);
                    this.rpcService.destroyCrossGroup(blockChain);
                    HashMap<String, Object> chainAssetId = new HashMap<String, Object>();
                    chainAssetId.put("chainId", blockChain.getChainId());
                    chainAssetId.put("assetId", 0);
                    this.rpcService.cancelCrossChain(chainAssetId, time);
                    this.removeChainMapInfo(blockChain.getMagicNumber(), blockChain.getChainName());
                    break;
                }
                case 12: {
                    BlockChain delBlockChain = TxUtil.buildChainWithTxData(tx, true);
                    BlockChain dbRegChain = this.getChain(delBlockChain.getChainId());
                    this.rpcService.createCrossGroup(dbRegChain);
                    this.rpcService.registerCrossChain(delBlockChain);
                    this.addChainMapInfo(delBlockChain);
                    break;
                }
                case 13: {
                    Asset asset = TxUtil.buildAssetWithTxChain(tx);
                    HashMap<String, Object> chainAssetIdAdd = new HashMap<String, Object>();
                    chainAssetIdAdd.put("chainId", asset.getChainId());
                    chainAssetIdAdd.put("assetId", asset.getAssetId());
                    this.rpcService.cancelCrossChain(chainAssetIdAdd, time);
                    break;
                }
                case 14: {
                    Asset assetDel = TxUtil.buildAssetWithTxChain(tx);
                    this.rpcService.registerCrossAsset(assetDel, time);
                    break;
                }
            }
        }
    }

    @Override
    public void rpcBlockChainRollbackV4(List<Transaction> txs, long time) throws Exception {
        for (Transaction tx : txs) {
            switch (tx.getType()) {
                case 11: {
                    BlockChain blockChain = TxUtil.buildChainWithTxDataV4(tx, false);
                    this.rpcService.destroyCrossGroup(blockChain);
                    HashMap<String, Object> chainAssetId = new HashMap<String, Object>();
                    chainAssetId.put("chainId", blockChain.getChainId());
                    chainAssetId.put("assetId", 0);
                    this.rpcService.cancelCrossChain(chainAssetId, time);
                    this.removeChainMapInfo(blockChain.getMagicNumber(), blockChain.getChainName());
                    break;
                }
                case 12: {
                    BlockChain delBlockChain = TxUtil.buildChainWithTxDataV4(tx, true);
                    BlockChain dbRegChain = this.getChain(delBlockChain.getChainId());
                    this.rpcService.createCrossGroup(dbRegChain);
                    this.rpcService.registerCrossChain(delBlockChain);
                    this.addChainMapInfo(delBlockChain);
                    break;
                }
                case 13: {
                    Asset asset = TxUtil.buildAssetWithTxChainV4(tx);
                    HashMap<String, Object> chainAssetIdAdd = new HashMap<String, Object>();
                    chainAssetIdAdd.put("chainId", asset.getChainId());
                    chainAssetIdAdd.put("assetId", asset.getAssetId());
                    this.rpcService.cancelCrossChain(chainAssetIdAdd, time);
                    break;
                }
                case 14: {
                    Asset assetDel = TxUtil.buildAssetWithTxChainV4(tx);
                    this.rpcService.registerCrossAsset(assetDel, time);
                    break;
                }
            }
        }
    }

    @Override
    public BlockChain destroyBlockChain(BlockChain blockChain) throws Exception {
        this.assetService.setStatus(CmRuntimeInfo.getAssetKey(blockChain.getChainId(), blockChain.getDelAssetId()), false);
        BlockChain dbChain = this.getChain(blockChain.getChainId());
        dbChain.setDelAddress(blockChain.getDelAddress());
        dbChain.setDelAssetId(blockChain.getDelAssetId());
        dbChain.setDelTxHash(blockChain.getDelTxHash());
        dbChain.setDelete(true);
        this.updateChain(dbChain);
        this.rpcService.destroyCrossGroup(dbChain);
        this.removeChainMapInfo(blockChain.getMagicNumber(), blockChain.getChainName());
        return dbChain;
    }

    @Override
    public List<BlockChain> getBlockList() throws Exception {
        return this.chainStorage.loadAllRegChains();
    }

    @Override
    public Map<String, Object> getBlockAssetsInfo(BlockChain blockChain) throws Exception {
        HashMap<String, Object> chainInfoMap = new HashMap<String, Object>();
        chainInfoMap.put("chainId", blockChain.getChainId());
        chainInfoMap.put("chainName", blockChain.getChainName());
        chainInfoMap.put("minAvailableNodeNum", blockChain.getMinAvailableNodeNum());
        chainInfoMap.put("maxSignatureCount", blockChain.getMaxSignatureCount());
        chainInfoMap.put("addressPrefix", blockChain.getAddressPrefix());
        chainInfoMap.put("signatureByzantineRatio", blockChain.getSignatureByzantineRatio());
        chainInfoMap.put("verifierList", new HashSet<String>(blockChain.getVerifierList()));
        chainInfoMap.put("registerTime", blockChain.getCreateTime());
        List<Asset> assets = this.assetService.getAssets(blockChain.getSelfAssetKeyList());
        ArrayList rtAssetList = new ArrayList();
        for (Asset asset : assets) {
            HashMap<String, Object> assetMap = new HashMap<String, Object>();
            assetMap.put("assetId", asset.getAssetId());
            assetMap.put("symbol", asset.getSymbol());
            assetMap.put("assetName", asset.getAssetName());
            assetMap.put("usable", asset.isAvailable());
            assetMap.put("decimalPlaces", asset.getDecimalPlaces());
            rtAssetList.add(assetMap);
        }
        chainInfoMap.put("assetInfoList", rtAssetList);
        return chainInfoMap;
    }

    @Override
    public Map<String, Object> getChainAssetsSimpleInfo(BlockChain blockChain) throws Exception {
        HashMap<String, Object> chainInfoMap = new HashMap<String, Object>();
        chainInfoMap.put("chainId", blockChain.getChainId());
        chainInfoMap.put("chainName", blockChain.getChainName());
        chainInfoMap.put("addressPrefix", blockChain.getAddressPrefix());
        chainInfoMap.put("registerTime", blockChain.getCreateTime());
        chainInfoMap.put("enable", !blockChain.isDelete());
        return chainInfoMap;
    }
}

