/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.task;

import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.ChainAssetTotalCirculate;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.rpc.call.impl.RpcServiceImpl;
import io.nuls.chain.service.impl.ChainServiceImpl;
import io.nuls.chain.service.impl.MessageServiceImpl;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.core.core.ioc.SpringLiteContext;
import java.util.List;

public class ChainAssetUpdateTask
implements Runnable {
    @Override
    public void run() {
        ChainServiceImpl chainService = (ChainServiceImpl)SpringLiteContext.getBean(ChainServiceImpl.class);
        RpcServiceImpl rpcService = (RpcServiceImpl)SpringLiteContext.getBean(RpcServiceImpl.class);
        MessageServiceImpl messageService = (MessageServiceImpl)SpringLiteContext.getBean(MessageServiceImpl.class);
        try {
            List<BlockChain> blockChainList = chainService.getBlockList();
            for (BlockChain blockChain : blockChainList) {
                if (blockChain.isDelete()) continue;
                List<String> assetKeys = blockChain.getSelfAssetKeyList();
                StringBuilder assets = new StringBuilder();
                for (String assetKey : assetKeys) {
                    assets.append(CmRuntimeInfo.getAssetIdByAssetKey(assetKey)).append(",");
                }
                LoggerUtil.logger().debug("chainId={}=====assets={}", new Object[]{blockChain.getChainId(), assets});
                if (blockChain.getChainId() == CmRuntimeInfo.getMainIntChainId()) {
                    if (assets.length() <= 0) continue;
                    List<ChainAssetTotalCirculate> mainChainAssets = rpcService.getLgAssetsById(blockChain.getChainId(), assets.substring(0, assets.length() - 1));
                    messageService.dealMainChainIssuingAssets(mainChainAssets);
                    continue;
                }
                messageService.initChainIssuingAssets(blockChain.getChainId());
                if (assets.length() > 0) {
                    rpcService.requestCrossIssuingAssets(blockChain.getChainId(), assets.substring(0, assets.length() - 1));
                }
                Thread.sleep(30000L);
                messageService.dealChainIssuingAssets(blockChain.getChainId());
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
        }
    }
}

