/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.economic.nuls.service;

import io.nuls.base.data.CoinTo;
import io.nuls.consensus.economic.base.service.EconomicService;
import io.nuls.consensus.economic.nuls.model.bo.AgentInfo;
import io.nuls.consensus.economic.nuls.model.bo.ConsensusConfigInfo;
import io.nuls.consensus.economic.nuls.model.bo.RoundInfo;
import io.nuls.consensus.economic.nuls.util.manager.EconomicManager;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class EconomicServiceImpl
implements EconomicService {
    @Override
    public Result registerConfig(Map<String, Object> params) {
        if (params == null || params.get("consensusConfig") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        ConsensusConfigInfo consensusConfig = (ConsensusConfigInfo)params.get("consensusConfig");
        EconomicManager.configMap.put(consensusConfig.getChainId(), consensusConfig);
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    @Override
    public Result calcReward(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("roundInfo") == null || params.get("agentInfo") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        ConsensusConfigInfo consensusConfigInfo = EconomicManager.configMap.get(chainId);
        RoundInfo roundInfo = (RoundInfo)params.get("roundInfo");
        AgentInfo agentInfo = (AgentInfo)params.get("agentInfo");
        long nowHeight = (Long)params.get("nowHeight");
        HashMap<String, BigInteger> awardAssetMap = new HashMap(4);
        if (params.get("awardAssetMap") != null) {
            awardAssetMap = (Map)params.get("awardAssetMap");
        }
        try {
            HashMap<String, List<CoinTo>> result = new HashMap<String, List<CoinTo>>(2);
            List<CoinTo> coinToList = EconomicManager.getRewardCoin(agentInfo, roundInfo, consensusConfigInfo, 0L, awardAssetMap, nowHeight);
            result.put("coinToList", coinToList);
            return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }
}

