/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.dto.transaction;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.model.dto.transaction.CoinFromDto;
import io.nuls.consensus.model.dto.transaction.CoinToDto;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.DateUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.util.List;
import java.util.stream.Collectors;

@ApiModel
public class TransactionDto {
    @ApiModelProperty(description="Transactionalhashvalue")
    private String hash;
    @ApiModelProperty(description="Transaction type")
    private int type;
    @ApiModelProperty(description="Transaction time")
    private String time;
    @ApiModelProperty(description="block height")
    private long blockHeight = -1L;
    @ApiModelProperty(description="blockhash")
    private String blockHash;
    @ApiModelProperty(description="Transaction notes")
    private String remark;
    @ApiModelProperty(description="Transaction signature")
    private String transactionSignature;
    @ApiModelProperty(description="Transaction business data serialization string")
    private String txDataHex;
    @ApiModelProperty(description="Transaction status 0:unConfirm(To be confirmed), 1:confirm(Confirmed)")
    private int status = 0;
    @ApiModelProperty(description="Transaction size")
    private int size;
    @ApiModelProperty(description="Order in blocks, stored inrocksDBThe middle is unordered, assigned values when saving blocks, sorted based on this value after retrieval")
    private int inBlockIndex;
    @ApiModelProperty(description="input", type=@TypeDescriptor(value=List.class, collectionElement=CoinFromDto.class))
    private List<CoinFromDto> from;
    @ApiModelProperty(description="output", type=@TypeDescriptor(value=List.class, collectionElement=CoinToDto.class))
    private List<CoinToDto> to;

    public TransactionDto() {
    }

    public TransactionDto(Transaction transaction) throws NulsException {
        this.blockHeight = transaction.getBlockHeight();
        this.status = transaction.getStatus().getStatus();
        this.hash = transaction.getHash().toString();
        this.remark = ByteUtils.asString((byte[])transaction.getRemark());
        this.inBlockIndex = transaction.getInBlockIndex();
        this.size = transaction.getSize();
        this.time = DateUtils.timeStamp2DateStr((long)(transaction.getTime() * 1000L));
        this.transactionSignature = RPCUtil.encode((byte[])transaction.getTransactionSignature());
        this.txDataHex = RPCUtil.encode((byte[])transaction.getTxData());
        this.type = transaction.getType();
        if (transaction.getCoinData() != null) {
            CoinData coinData = transaction.getCoinDataInstance();
            this.from = coinData.getFrom().stream().map(from -> new CoinFromDto((CoinFrom)from)).collect(Collectors.toList());
            this.to = coinData.getTo().stream().map(to -> new CoinToDto((CoinTo)to)).collect(Collectors.toList());
        }
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTransactionSignature() {
        return this.transactionSignature;
    }

    public void setTransactionSignature(String transactionSignature) {
        this.transactionSignature = transactionSignature;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public String getTxDataHex() {
        return this.txDataHex;
    }

    public void setTxDataHex(String txDataHex) {
        this.txDataHex = txDataHex;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getInBlockIndex() {
        return this.inBlockIndex;
    }

    public void setInBlockIndex(int inBlockIndex) {
        this.inBlockIndex = inBlockIndex;
    }

    public List<CoinFromDto> getFrom() {
        return this.from;
    }

    public void setFrom(List<CoinFromDto> from) {
        this.from = from;
    }

    public List<CoinToDto> getTo() {
        return this.to;
    }

    public void setTo(List<CoinToDto> to) {
        this.to = to;
    }
}

