/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class DepositPo
extends BaseNulsData {
    private NulsHash txHash;
    private BigInteger deposit;
    private NulsHash agentHash;
    private byte[] address;
    private long time;
    private long blockHeight = -1L;
    private long delHeight = -1L;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeBigInteger(this.deposit);
        stream.write(this.agentHash.getBytes());
        stream.write(this.address);
        stream.writeUint48(this.time);
        stream.write(this.txHash.getBytes());
        stream.writeVarInt(this.blockHeight);
        stream.writeVarInt(this.delHeight);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.deposit = byteBuffer.readBigInteger();
        this.agentHash = byteBuffer.readHash();
        this.address = byteBuffer.readBytes(23);
        this.time = byteBuffer.readUint48();
        this.txHash = byteBuffer.readHash();
        this.blockHeight = byteBuffer.readVarInt();
        this.delHeight = byteBuffer.readVarInt();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfBigInteger();
        size += 32;
        size += this.address.length;
        size += SerializeUtils.sizeOfUint48();
        size += 32;
        size += SerializeUtils.sizeOfVarInt((Long)this.blockHeight);
        return size += SerializeUtils.sizeOfVarInt((Long)this.delHeight);
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public NulsHash getAgentHash() {
        return this.agentHash;
    }

    public void setAgentHash(NulsHash agentHash) {
        this.agentHash = agentHash;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public NulsHash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(NulsHash txHash) {
        this.txHash = txHash;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public long getDelHeight() {
        return this.delHeight;
    }

    public void setDelHeight(long delHeight) {
        this.delHeight = delHeight;
    }
}

