/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.dto.input.CreateAgentDTO;
import io.nuls.consensus.model.dto.input.SearchAgentDTO;
import io.nuls.consensus.model.dto.input.SearchAllAgentDTO;
import io.nuls.consensus.model.dto.input.StopAgentDTO;
import io.nuls.consensus.model.dto.output.AgentDTO;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.service.AgentService;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.utils.TxUtil;
import io.nuls.consensus.utils.enumeration.ConsensusStatus;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.manager.RoundManager;
import io.nuls.consensus.utils.validator.TxValidator;
import io.nuls.core.basic.Page;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class AgentServiceImpl
implements AgentService {
    @Autowired
    private AgentStorageService agentService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private TxValidator validatorManager;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private RoundManager roundManager;

    @Override
    public Result createAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        CreateAgentDTO dto = (CreateAgentDTO)JSONUtils.map2pojo(params, CreateAgentDTO.class);
        try {
            ObjectUtils.canNotEmpty((Object)dto);
            ObjectUtils.canNotEmpty((Object)dto.getChainId(), (String)"chainId can not be null");
            ObjectUtils.canNotEmpty((Object)dto.getAgentAddress(), (String)"agent address can not be null");
            ObjectUtils.canNotEmpty((Object)dto.getCommissionRate(), (String)"commission rate can not be null");
            ObjectUtils.canNotEmpty((Object)dto.getDeposit(), (String)"deposit can not be null");
            ObjectUtils.canNotEmpty((Object)dto.getPackingAddress(), (String)"packing address can not be null");
        }
        catch (RuntimeException e) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            Log.error((String)ConsensusErrorCode.CHAIN_NOT_EXIST.getMsg());
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            if (!AddressTool.isNormalAddress((String)dto.getPackingAddress(), (int)dto.getChainId())) {
                throw new NulsRuntimeException(ConsensusErrorCode.ADDRESS_ERROR);
            }
            HashMap callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getAgentAddress(), dto.getPassword());
            Transaction tx = new Transaction(4);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Agent agent = TxUtil.createAgent(dto);
            tx.setTxData(agent.serialize());
            CoinData coinData = this.coinDataManager.getCoinData(agent.getAgentAddress(), chain, new BigInteger(dto.getDeposit()), -1L, tx.size() + 110, chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId());
            tx.setCoinData(coinData.serialize());
            String priKey = (String)callResult.get("priKey");
            CallMethodUtils.transactionSignature(dto.getChainId(), dto.getAgentAddress(), dto.getPassword(), priKey, tx);
            String txStr = RPCUtil.encode((byte[])tx.serialize());
            boolean validResult = this.validatorManager.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            CallMethodUtils.sendTx(chain, txStr);
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("txHash", tx.getHash().toHex());
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.INTERFACE_CALL_FAILED);
        }
    }

    @Override
    public Result createAgentValid(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("tx") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        String txHex = (String)params.get("tx");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            Transaction transaction = new Transaction(4);
            transaction.parse(RPCUtil.decode((String)txHex), 0);
            boolean result = this.validatorManager.validateTx(chain, transaction);
            if (!result) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result getStopAgentCoinData(Map<String, Object> params) {
        long lockHeight;
        String agentHash;
        int chainId;
        try {
            chainId = (Integer)params.get("chainId");
            agentHash = (String)params.get("agentHash");
            lockHeight = Long.parseLong("" + params.get("lockHeight"));
            ObjectUtils.canNotEmpty((Object)agentHash, (String)"agentHash can not be null");
        }
        catch (Exception e) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        List<Agent> agentList = chain.getAgentList();
        Agent agent = null;
        for (Agent a : agentList) {
            if (!a.getTxHash().toHex().equals(agentHash)) continue;
            agent = a;
            break;
        }
        try {
            CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, agent, lockHeight);
            if (null != coinData) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("value", HexUtil.encode((byte[])coinData.serialize()));
                return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
        return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_NOT_FOUND);
    }

    @Override
    public Result stopAgent(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        StopAgentDTO dto = (StopAgentDTO)JSONUtils.map2pojo(params, StopAgentDTO.class);
        try {
            ObjectUtils.canNotEmpty((Object)dto);
            ObjectUtils.canNotEmpty((Object)dto.getChainId(), (String)"chainId can not be null");
            ObjectUtils.canNotEmpty((Object)dto.getAddress(), (String)"address can not be null");
        }
        catch (RuntimeException e) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        if (!AddressTool.validAddress((int)dto.getChainId(), (String)dto.getAddress())) {
            throw new NulsRuntimeException(ConsensusErrorCode.ADDRESS_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(dto.getChainId());
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            HashMap callResult = CallMethodUtils.accountValid(dto.getChainId(), dto.getAddress(), dto.getPassword());
            Transaction tx = new Transaction(9);
            StopAgent stopAgent = new StopAgent();
            stopAgent.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            List<Agent> agentList = chain.getAgentList();
            Agent agent = null;
            for (Agent a : agentList) {
                if (a.getDelHeight() > 0L || !Arrays.equals(a.getAgentAddress(), AddressTool.getAddress((String)dto.getAddress()))) continue;
                agent = a;
                break;
            }
            if (agent == null || agent.getDelHeight() > 0L) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
            }
            stopAgent.setCreateTxHash(agent.getTxHash());
            tx.setTxData(stopAgent.serialize());
            long txTime = NulsDateUtils.getCurrentTimeSeconds();
            tx.setTime(txTime);
            CoinData coinData = this.coinDataManager.getStopAgentCoinData(chain, agent, txTime + chain.getConfig().getStopAgentLockTime());
            int agentChainId = chain.getConfig().getAgentChainId();
            int agentAssetId = chain.getConfig().getAgentAssetId();
            BigInteger fee = TransactionFeeCalculator.getConsensusTxFee((int)(tx.size() + 110 + coinData.serialize().length), (long)chain.getConfig().getFeeUnit(agentChainId + "-" + agentAssetId));
            ((CoinTo)coinData.getTo().get(0)).setAmount(((CoinTo)coinData.getTo().get(0)).getAmount().subtract(fee));
            tx.setCoinData(coinData.serialize());
            String priKey = (String)callResult.get("priKey");
            CallMethodUtils.transactionSignature(dto.getChainId(), dto.getAddress(), dto.getPassword(), priKey, tx);
            String txStr = RPCUtil.encode((byte[])tx.serialize());
            boolean validResult = this.validatorManager.validateTx(chain, tx);
            if (!validResult) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            CallMethodUtils.sendTx(chain, txStr);
            HashMap<String, String> result = new HashMap<String, String>(16);
            result.put("txHash", tx.getHash().toHex());
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_PARSE_ERROR);
        }
    }

    @Override
    public Result stopAgentValid(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("tx") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            String txHex = (String)params.get("tx");
            Transaction transaction = new Transaction(9);
            transaction.parse(RPCUtil.decode((String)txHex), 0);
            boolean result = this.validatorManager.validateTx(chain, transaction);
            if (!result) {
                return Result.getFailed((ErrorCode)ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            HashMap<String, Boolean> validResult = new HashMap<String, Boolean>(2);
            validResult.put("value", true);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(validResult);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result getAgentList(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        SearchAllAgentDTO dto = (SearchAllAgentDTO)JSONUtils.map2pojo(params, SearchAllAgentDTO.class);
        int pageNumber = dto.getPageNumber();
        int pageSize = dto.getPageSize();
        int chainId = dto.getChainId();
        if (pageNumber == 0) {
            pageNumber = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (pageNumber < 0 || pageSize < 0 || pageSize > 300 || chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        List<Agent> agentList = chain.getAgentList();
        ArrayList<Agent> handleList = new ArrayList<Agent>();
        String keyword = dto.getKeyWord();
        long startBlockHeight = chain.getNewestHeader().getHeight();
        for (Agent agent : agentList) {
            if (agent.getDelHeight() != -1L && agent.getDelHeight() <= startBlockHeight || agent.getBlockHeight() > startBlockHeight || agent.getBlockHeight() < 0L) continue;
            if (StringUtils.isNotBlank((String)keyword)) {
                keyword = keyword.toUpperCase();
                String agentAddress = AddressTool.getStringAddressByBytes((byte[])agent.getAgentAddress()).toUpperCase();
                String packingAddress = AddressTool.getStringAddressByBytes((byte[])agent.getPackingAddress()).toUpperCase();
                String agentId = this.agentManager.getAgentId(agent.getTxHash()).toUpperCase();
                String agentAlias = CallMethodUtils.getAlias(chain, agentAddress);
                String packingAlias = CallMethodUtils.getAlias(chain, packingAddress);
                boolean b = agentId.contains(keyword);
                boolean bl = b = b || agentAddress.equals(keyword) || packingAddress.equals(keyword);
                if (StringUtils.isNotBlank((String)agentAlias)) {
                    b = b || agentAlias.toUpperCase().contains(keyword);
                    agent.setAlais(agentAlias);
                }
                if (!b && StringUtils.isNotBlank((String)packingAlias)) {
                    b = agentAlias.toUpperCase().contains(keyword);
                }
                if (!b) continue;
            }
            handleList.add(agent);
        }
        int start = pageNumber * pageSize - pageSize;
        Page page = new Page(pageNumber, pageSize, handleList.size());
        if ((long)start >= page.getTotal()) {
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)page);
        }
        this.agentManager.fillAgentList(chain, handleList, null);
        ArrayList<AgentDTO> resultList = new ArrayList<AgentDTO>();
        for (int i = start; i < handleList.size() && i < start + pageSize; ++i) {
            resultList.add(new AgentDTO((Agent)((Object)handleList.get(i))));
        }
        page.setList(resultList);
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)page);
    }

    @Override
    public Result getAgentInfo(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        SearchAgentDTO dto = (SearchAgentDTO)JSONUtils.map2pojo(params, SearchAgentDTO.class);
        String agentHash = dto.getAgentHash();
        if (!NulsHash.validHash((String)agentHash)) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        int chainId = dto.getChainId();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        NulsHash agentHashData = NulsHash.fromHex((String)agentHash);
        List<Agent> agentList = chain.getAgentList();
        for (Agent agent : agentList) {
            if (!agent.getTxHash().equals((Object)agentHashData)) continue;
            MeetingRound round = this.roundManager.getCurrentRound(chain);
            if (agent.getDelHeight() == -1L) {
                this.agentManager.fillAgent(chain, agent, round, null);
            } else {
                agent.setMemberCount(0);
                agent.setTotalDeposit(BigInteger.ZERO);
                agent.setStatus(0);
                agent.setCreditVal(0.0);
            }
            AgentDTO result = new AgentDTO(agent);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData((Object)result);
        }
        return Result.getFailed((ErrorCode)ConsensusErrorCode.AGENT_NOT_EXIST);
    }

    @Override
    public Result getAgentStatus(Map<String, Object> params) {
        if (params == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        SearchAgentDTO dto = (SearchAgentDTO)JSONUtils.map2pojo(params, SearchAgentDTO.class);
        int chainId = dto.getChainId();
        if (dto.getChainId() <= 0 || dto.getAgentHash() == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        try {
            AgentPo agent = this.agentService.get(NulsHash.fromHex((String)dto.getAgentHash()), chainId);
            if (agent.getDelHeight() > 0L) {
                result.put("status", 0);
            } else {
                result.put("status", 1);
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(result);
    }

    @Override
    public Result updateAgentConsensusStatus(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        chain.setConsensusStatus(ConsensusStatus.RUNNING);
        chain.getLogger().info("updateAgentConsensusStatus-Successfully modified node consensus status......");
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS);
    }

    @Override
    public Result updateAgentStatus(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("status") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        int status = (Integer)params.get("status");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        if (status == 1) {
            chain.setCanPacking(true);
            chain.getLogger().info("updateAgentStatus--The node packaging status has been successfully modified, and the modified status is\uff1aPackable status");
        } else {
            chain.setCanPacking(false);
            chain.getLogger().info("updateAgentStatus--The node packaging status has been successfully modified, and the modified status is\uff1aUnpackable status");
        }
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS);
    }

    @Override
    public Result getNodePackingAddress(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_getUnencryptedAddressList", params);
            List accountAddressList = (List)((HashMap)((HashMap)cmdResp.getResponseData()).get("ac_getUnencryptedAddressList")).get("list");
            List<Agent> workAgentList = chain.getWorkAgentList(chain.getNewestHeader().getHeight());
            String packAddress = null;
            for (Agent agent : workAgentList) {
                String address = AddressTool.getStringAddressByBytes((byte[])agent.getPackingAddress());
                if (!accountAddressList.contains(address)) continue;
                packAddress = address;
                break;
            }
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            resultMap.put("packAddress", packAddress);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(resultMap);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result getAgentAddressList(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(2);
        resultMap.put("packAddress", chain.getWorkAddressList(chain.getNewestHeader().getHeight()));
        return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(resultMap);
    }

    @Override
    public Result getPackerInfo(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            MeetingRound round = this.roundManager.getCurrentRound(chain);
            List<MeetingMember> members = null;
            if (round != null) {
                members = round.getLocalMembers();
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            if (members != null) {
                ArrayList<String> localPackAddressList = new ArrayList<String>();
                for (MeetingMember meetingMember : members) {
                    localPackAddressList.add(AddressTool.getStringAddressByBytes((byte[])meetingMember.getAgent().getPackingAddress()));
                }
                if (null != localPackAddressList && !localPackAddressList.isEmpty()) {
                    resultMap.put("address", localPackAddressList.get(0));
                }
                resultMap.put("addresses", localPackAddressList);
                resultMap.put("password", chain.getConfig().getPassword());
            }
            ArrayList<String> packAddressList = new ArrayList<String>();
            if (round != null) {
                for (MeetingMember meetingMember : round.getMemberList()) {
                    packAddressList.add(AddressTool.getStringAddressByBytes((byte[])meetingMember.getAgent().getPackingAddress()));
                }
            } else if (chain.isCacheLoaded()) {
                packAddressList = new ArrayList<String>(Arrays.asList(chain.getConfig().getSeedNodes().split(",")));
            }
            resultMap.put("packAddressList", packAddressList);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(resultMap);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }

    @Override
    public Result getSeedNodeInfo(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.PARAM_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)ConsensusErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            String address;
            List<String> packAddressList = Arrays.asList(chain.getConfig().getSeedNodes().split(","));
            MeetingRound round = this.roundManager.getCurrentRound(chain);
            MeetingMember member = null;
            if (round != null) {
                member = round.getMyMember();
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            if (member != null && packAddressList.contains(address = AddressTool.getStringAddressByBytes((byte[])member.getAgent().getPackingAddress()))) {
                resultMap.put("address", address);
                resultMap.put("password", chain.getConfig().getPassword());
            }
            resultMap.put("packAddressList", packAddressList);
            return Result.getSuccess((ErrorCode)ConsensusErrorCode.SUCCESS).setData(resultMap);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)ConsensusErrorCode.DATA_ERROR);
        }
    }
}

