/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v1;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.PunishManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component(value="YellowPunishProcessorV1")
public class YellowPunishProcessor
implements TransactionProcessor {
    @Autowired
    private PunishManager punishManager;
    @Autowired
    private ChainManager chainManager;

    public int getType() {
        return 7;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        return null;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        boolean commitResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.punishManager.yellowPunishCommit(tx, chain, blockHeader)) continue;
                commitSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to yellow punish transaction submission");
                chain.getLogger().error(e);
                commitResult = false;
            }
        }
        if (!commitResult) {
            for (Transaction rollbackTx : commitSuccessList) {
                try {
                    this.punishManager.yellowPunishRollback(rollbackTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to yellow punish transaction rollback");
                    chain.getLogger().error(e);
                }
            }
        }
        return commitResult;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> rollbackSuccessList = new ArrayList<Transaction>();
        boolean rollbackResult = true;
        for (Transaction tx : txs) {
            try {
                if (!this.punishManager.yellowPunishRollback(tx, chain, blockHeader)) continue;
                rollbackSuccessList.add(tx);
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to yellow punish transaction rollback");
                chain.getLogger().error(e);
                rollbackResult = false;
            }
        }
        if (!rollbackResult) {
            for (Transaction commitTx : rollbackSuccessList) {
                try {
                    this.punishManager.yellowPunishCommit(commitTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to yellow punish transaction submission");
                    chain.getLogger().error(e);
                }
            }
        }
        return rollbackResult;
    }
}

