/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.tx.v4;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.RedPunishData;
import io.nuls.consensus.utils.LoggerUtil;
import io.nuls.consensus.utils.enumeration.PunishReasonEnum;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.PunishManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component(value="RedPunishProcessorV4")
public class RedPunishProcessor
implements TransactionProcessor {
    @Autowired
    private PunishManager punishManager;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AgentManager agentManager;

    public int getType() {
        return 8;
    }

    public int getPriority() {
        return 10;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            result.put("txList", txs);
            result.put("errorCode", ConsensusErrorCode.CHAIN_NOT_EXIST.getCode());
            return result;
        }
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        String errorCode = null;
        HashSet<String> addressHexSet = new HashSet<String>();
        for (Transaction tx : txs) {
            try {
                RedPunishData redPunishData = new RedPunishData();
                redPunishData.parse(tx.getTxData(), 0);
                if (!this.verifyV4(chain, redPunishData)) {
                    invalidTxList.add(tx);
                    errorCode = ConsensusErrorCode.BLOCK_RED_PUNISH_ERROR.getCode();
                    continue;
                }
                String addressHex = HexUtil.encode((byte[])redPunishData.getAddress());
                if (addressHexSet.add(addressHex)) continue;
                invalidTxList.add(tx);
                errorCode = ConsensusErrorCode.CONFLICT_ERROR.getCode();
            }
            catch (NulsException e) {
                invalidTxList.add(tx);
                chain.getLogger().error("Intelligent Contract Creation Node Transaction Verification Failed");
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        boolean commitResult = true;
        for (Transaction tx : txs) {
            try {
                if (this.punishManager.redPunishCommit(tx, chain, blockHeader)) {
                    commitSuccessList.add(tx);
                    continue;
                }
                commitResult = false;
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to red punish transaction submission");
                chain.getLogger().error(e);
                commitResult = false;
            }
        }
        if (!commitResult) {
            for (Transaction rollbackTx : commitSuccessList) {
                try {
                    this.punishManager.redPunishRollback(rollbackTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to red punish transaction rollback");
                    chain.getLogger().error(e);
                }
            }
        }
        return commitResult;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chains do not exist.");
            return false;
        }
        ArrayList<Transaction> rollbackSuccessList = new ArrayList<Transaction>();
        boolean rollbackResult = true;
        for (Transaction tx : txs) {
            try {
                if (this.punishManager.redPunishRollback(tx, chain, blockHeader)) {
                    rollbackSuccessList.add(tx);
                    continue;
                }
                rollbackResult = false;
            }
            catch (NulsException e) {
                chain.getLogger().error("Failure to red punish transaction rollback");
                chain.getLogger().error(e);
                rollbackResult = false;
            }
        }
        if (!rollbackResult) {
            for (Transaction commitTx : rollbackSuccessList) {
                try {
                    this.punishManager.redPunishCommit(commitTx, chain, blockHeader);
                }
                catch (NulsException e) {
                    chain.getLogger().error("Failure to red punish transaction submission");
                    chain.getLogger().error(e);
                }
            }
        }
        return rollbackResult;
    }

    private boolean verifyV4(Chain chain, RedPunishData punishData) {
        if (punishData.getReasonCode() == PunishReasonEnum.BIFURCATION.getCode()) {
            NulsByteBuffer byteBuffer = new NulsByteBuffer(punishData.getEvidence());
            HashSet<Long> heightSet = new HashSet<Long>();
            for (int i = 0; i < 3 && !byteBuffer.isFinished(); ++i) {
                BlockHeader header2;
                BlockHeader header1;
                try {
                    header1 = (BlockHeader)byteBuffer.readNulsData((BaseNulsData)new BlockHeader());
                    header2 = (BlockHeader)byteBuffer.readNulsData((BaseNulsData)new BlockHeader());
                }
                catch (NulsException e) {
                    chain.getLogger().error(e.getMessage());
                    return false;
                }
                if (heightSet.contains(header1.getHeight())) {
                    chain.getLogger().error("Bifurcated evidence with duplicate data");
                    return false;
                }
                if (header1.getBlockSignature().verifySignature(header1.getHash()).isFailed() || header2.getBlockSignature().verifySignature(header2.getHash()).isFailed()) {
                    chain.getLogger().error("Signature verification failed in branching evidence");
                    return false;
                }
                Agent agent = this.agentManager.getAgentByAgentAddress(chain, punishData.getAddress());
                if (!Arrays.equals(AddressTool.getAddress((byte[])header1.getBlockSignature().getPublicKey(), (int)chain.getConfig().getChainId()), agent.getPackingAddress()) || !Arrays.equals(AddressTool.getAddress((byte[])header2.getBlockSignature().getPublicKey(), (int)chain.getConfig().getChainId()), agent.getPackingAddress())) {
                    chain.getLogger().error("Whether there is a block out of the penalty node in the branch evidence block!");
                    return false;
                }
                heightSet.add(header1.getHeight());
            }
        }
        return true;
    }
}

