/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.manager;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.common.NulsCoresConfig;
import io.nuls.consensus.economic.base.service.EconomicService;
import io.nuls.consensus.economic.nuls.model.bo.AgentInfo;
import io.nuls.consensus.economic.nuls.model.bo.DepositInfo;
import io.nuls.consensus.economic.nuls.model.bo.RoundInfo;
import io.nuls.consensus.model.bo.BlockData;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.ChargeResultData;
import io.nuls.consensus.model.bo.round.MeetingMember;
import io.nuls.consensus.model.bo.round.MeetingRound;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.manager.PunishManager;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ConsensusManager {
    @Autowired
    private PunishManager punishManager;
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private EconomicService economicService;

    public void addConsensusTx(Chain chain, BlockHeader bestBlock, List<Transaction> txList, MeetingMember self, MeetingRound round, BlockExtendsData extendsData) throws Exception {
        Transaction coinBaseTransaction = this.createCoinBaseTx(chain, self, txList, round, 0L, bestBlock.getHeight() + 1L);
        if (AddressTool.validContractAddress((byte[])self.getAgent().getRewardAddress(), (int)chain.getConfig().getChainId())) {
            String stateRoot = CallMethodUtils.triggerContract(chain.getConfig().getChainId(), RPCUtil.encode((byte[])extendsData.getStateRoot()), bestBlock.getHeight(), AddressTool.getStringAddressByBytes((byte[])self.getAgent().getRewardAddress()), RPCUtil.encode((byte[])coinBaseTransaction.serialize()));
            extendsData.setStateRoot(RPCUtil.decode((String)stateRoot));
        } else if (this.coinDataManager.hasContractAddress(coinBaseTransaction.getCoinDataInstance(), chain.getConfig().getChainId())) {
            String stateRoot = CallMethodUtils.triggerContract(chain.getConfig().getChainId(), RPCUtil.encode((byte[])extendsData.getStateRoot()), bestBlock.getHeight(), null, RPCUtil.encode((byte[])coinBaseTransaction.serialize()));
            extendsData.setStateRoot(RPCUtil.decode((String)stateRoot));
        }
        txList.add(0, coinBaseTransaction);
        this.punishManager.punishTx(chain, bestBlock, txList, self, round);
    }

    public Transaction createCoinBaseTx(Chain chain, MeetingMember member, List<Transaction> txList, MeetingRound localRound, long unlockHeight, long nowHeight) throws IOException, NulsException {
        Transaction tx = new Transaction(1);
        CoinData coinData = new CoinData();
        List<CoinTo> rewardList = this.calcReward(chain, txList, member, localRound, unlockHeight, nowHeight);
        for (CoinTo coin : rewardList) {
            coinData.addTo(coin);
        }
        try {
            tx.setCoinData(coinData.serialize());
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            coinData = new CoinData();
            rewardList = this.calcReward(chain, new ArrayList<Transaction>(), member, localRound, unlockHeight, nowHeight);
            for (CoinTo coin : rewardList) {
                coinData.addTo(coin);
            }
            tx.setCoinData(coinData.serialize());
        }
        tx.setTime(member.getPackEndTime());
        tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
        return tx;
    }

    private List<CoinTo> calcReward(Chain chain, List<Transaction> txList, MeetingMember self, MeetingRound localRound, long unlockHeight, long nowHeight) throws NulsException {
        int chainId = chain.getConfig().getChainId();
        HashMap<String, BigInteger> awardAssetMap = new HashMap<String, BigInteger>(16);
        BigInteger returnGas = BigInteger.ZERO;
        HashMap<CallSite, BigInteger> gasReturnMap = new HashMap<CallSite, BigInteger>();
        for (Transaction transaction : txList) {
            int txType = transaction.getType();
            if (txType != 1 && txType != 18 && txType != 19 && txType != 20 && txType != 23 && txType != 21 && txType != 22) {
                List<ChargeResultData> resultData = null;
                resultData = ProtocolGroupManager.getCurrentVersion((int)chainId) < 20 ? this.getFeeV1(transaction, chain) : this.getFeeV20(transaction, chain);
                for (ChargeResultData data : resultData) {
                    String key = data.getKey();
                    if (awardAssetMap.keySet().contains(key)) {
                        awardAssetMap.put(key, ((BigInteger)awardAssetMap.get(key)).add(data.getFee()));
                        continue;
                    }
                    awardAssetMap.put(key, data.getFee());
                }
            }
            if (txType != 19) continue;
            CoinData coinData = new CoinData();
            coinData.parse(transaction.getCoinData(), 0);
            for (CoinTo to : coinData.getTo()) {
                returnGas = returnGas.add(to.getAmount());
                String chainKey = to.getAssetsChainId() + "_" + to.getAssetsId();
                BigInteger amount = (BigInteger)gasReturnMap.get(chainKey);
                if (null == amount) {
                    gasReturnMap.put((CallSite)((Object)chainKey), to.getAmount());
                    continue;
                }
                gasReturnMap.put((CallSite)((Object)chainKey), to.getAmount().add(amount));
            }
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) < 20) {
            int assetsId = chain.getConfig().getAssetId();
            String string = chainId + "_" + assetsId;
            BigInteger chainFee = (BigInteger)awardAssetMap.get(string);
            if (returnGas.compareTo(BigInteger.ZERO) > 0) {
                chainFee = ((BigInteger)awardAssetMap.get(string)).subtract(returnGas);
            }
            if (chainFee == null || chainFee.compareTo(BigInteger.ZERO) <= 0) {
                awardAssetMap.remove(string);
            } else {
                awardAssetMap.put(string, chainFee);
            }
        } else {
            for (Map.Entry entry : gasReturnMap.entrySet()) {
                String chainKey = (String)entry.getKey();
                BigInteger _returnGas = (BigInteger)entry.getValue();
                BigInteger chainFee = (BigInteger)awardAssetMap.get(chainKey);
                if (_returnGas.compareTo(BigInteger.ZERO) > 0) {
                    chainFee = ((BigInteger)awardAssetMap.get(chainKey)).subtract(_returnGas);
                }
                if (chainFee == null || chainFee.compareTo(BigInteger.ZERO) <= 0) {
                    awardAssetMap.remove(chainKey);
                    continue;
                }
                awardAssetMap.put(chainKey, chainFee);
            }
        }
        return this.getRewardCoin(self, localRound, unlockHeight, awardAssetMap, chain, nowHeight);
    }

    public Block createBlock(Chain chain, BlockData blockData, byte[] packingAddress, String packingAddressString) {
        try {
            String password = chain.getConfig().getPassword();
            CallMethodUtils.accountValid(chain.getConfig().getChainId(), packingAddressString, password);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return null;
        }
        Block block = new Block();
        block.setTxs(blockData.getTxList());
        BlockHeader header = new BlockHeader();
        block.setHeader(header);
        try {
            header.setExtend(blockData.getExtendsData().serialize());
        }
        catch (IOException e) {
            chain.getLogger().error(e.getMessage());
            throw new NulsRuntimeException((Throwable)e);
        }
        header.setHeight(blockData.getHeight());
        header.setTime(blockData.getTime());
        header.setPreHash(blockData.getPreHash());
        header.setTxCount(blockData.getTxList().size());
        header.setPackingAddress(packingAddress);
        ArrayList<NulsHash> txHashList = new ArrayList<NulsHash>();
        for (int i = 0; i < blockData.getTxList().size(); ++i) {
            Transaction tx = blockData.getTxList().get(i);
            tx.setBlockHeight(header.getHeight());
            txHashList.add(tx.getHash());
        }
        header.setMerkleHash(NulsHash.calcMerkleHash(txHashList));
        try {
            CallMethodUtils.blockSignature(chain, packingAddressString, header);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return null;
        }
        return block;
    }

    private List<ChargeResultData> getFeeV20(Transaction tx, Chain chain) throws NulsException {
        boolean isCrossTx;
        ArrayList<ChargeResultData> list = new ArrayList<ChargeResultData>();
        CoinData coinData = new CoinData();
        coinData.parse(tx.getCoinData(), 0);
        boolean bl = isCrossTx = tx.getType() == 10;
        if (this.config.getMainChainId() == chain.getConfig().getChainId()) {
            boolean bl2 = isCrossTx = isCrossTx || tx.getType() == 26;
        }
        if (isCrossTx) {
            int feeChainId = chain.getConfig().getChainId();
            int feeAssetId = chain.getConfig().getAssetId();
            if (AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress()) == feeChainId && feeChainId != this.config.getMainChainId()) {
                list.add(new ChargeResultData(this.getFee(coinData, feeChainId, feeAssetId), feeChainId, feeAssetId));
                return list;
            }
            BigInteger fee = this.getFee(coinData, this.config.getMainChainId(), this.config.getMainAssetId());
            int mainCommissionRatio = this.config.getMainChainCommissionRatio();
            if (feeChainId == this.config.getMainChainId()) {
                int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)coinData.getTo().get(0)).getAddress());
                if (toChainId == this.config.getMainChainId()) {
                    list.add(new ChargeResultData(fee, this.config.getMainChainId(), this.config.getMainAssetId()));
                    return list;
                }
                list.add(new ChargeResultData(fee.multiply(new BigInteger(String.valueOf(mainCommissionRatio))).divide(new BigInteger(String.valueOf(100))), this.config.getMainChainId(), this.config.getMainAssetId()));
                return list;
            }
            list.add(new ChargeResultData(fee.multiply(new BigInteger(String.valueOf(100 - mainCommissionRatio))).divide(new BigInteger(String.valueOf(100))), this.config.getMainChainId(), this.config.getMainAssetId()));
            return list;
        }
        if (tx.getType() == 4 || tx.getType() == 9 || tx.getType() == 5 || tx.getType() == 6) {
            int feeChainId = chain.getConfig().getChainId();
            int feeAssetId = chain.getConfig().getAssetId();
            list.add(new ChargeResultData(this.getFee(coinData, feeChainId, feeAssetId), feeChainId, feeAssetId));
        } else {
            for (CoinFrom from : coinData.getFrom()) {
                BigInteger amount = this.getFee(coinData, from.getAssetsChainId(), from.getAssetsId());
                if (amount == null || amount.compareTo(BigInteger.ZERO) <= 0) continue;
                list.add(new ChargeResultData(amount, from.getAssetsChainId(), from.getAssetsId()));
            }
        }
        if (list.isEmpty()) {
            int feeChainId = chain.getConfig().getChainId();
            int feeAssetId = chain.getConfig().getAssetId();
            list.add(new ChargeResultData(BigInteger.ZERO, feeChainId, feeAssetId));
        }
        return list;
    }

    private List<ChargeResultData> getFeeV1(Transaction tx, Chain chain) throws NulsException {
        ArrayList<ChargeResultData> list = new ArrayList<ChargeResultData>();
        list.add(this.getRealFeeV1(tx, chain));
        return list;
    }

    private ChargeResultData getRealFeeV1(Transaction tx, Chain chain) throws NulsException {
        boolean isCrossTx;
        CoinData coinData = new CoinData();
        int feeChainId = chain.getConfig().getChainId();
        int feeAssetId = chain.getConfig().getAssetId();
        coinData.parse(tx.getCoinData(), 0);
        boolean bl = isCrossTx = tx.getType() == 10;
        if (this.config.getMainChainId() == chain.getConfig().getChainId()) {
            boolean bl2 = isCrossTx = isCrossTx || tx.getType() == 26;
        }
        if (isCrossTx) {
            if (AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress()) == feeChainId && feeChainId != this.config.getMainChainId()) {
                return new ChargeResultData(this.getFee(coinData, feeChainId, feeAssetId), feeChainId, feeAssetId);
            }
            BigInteger fee = this.getFee(coinData, this.config.getMainChainId(), this.config.getMainAssetId());
            int mainCommissionRatio = this.config.getMainChainCommissionRatio();
            if (feeChainId == this.config.getMainChainId()) {
                int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)coinData.getTo().get(0)).getAddress());
                if (toChainId == this.config.getMainChainId()) {
                    return new ChargeResultData(fee, this.config.getMainChainId(), this.config.getMainAssetId());
                }
                return new ChargeResultData(fee.multiply(new BigInteger(String.valueOf(mainCommissionRatio))).divide(new BigInteger(String.valueOf(100))), this.config.getMainChainId(), this.config.getMainAssetId());
            }
            return new ChargeResultData(fee.multiply(new BigInteger(String.valueOf(100 - mainCommissionRatio))).divide(new BigInteger(String.valueOf(100))), this.config.getMainChainId(), this.config.getMainAssetId());
        }
        if (tx.getType() == 4 || tx.getType() == 9 || tx.getType() == 5 || tx.getType() == 6) {
            feeChainId = chain.getConfig().getAgentChainId();
            feeAssetId = chain.getConfig().getAgentAssetId();
        }
        return new ChargeResultData(this.getFee(coinData, feeChainId, feeAssetId), feeChainId, feeAssetId);
    }

    public BigInteger getFee(CoinData coinData, int assetChainId, int assetId) {
        BigInteger fromAmount = BigInteger.ZERO;
        BigInteger toAmount = BigInteger.ZERO;
        for (CoinFrom from : coinData.getFrom()) {
            if (from.getAssetsChainId() != assetChainId || from.getAssetsId() != assetId) continue;
            fromAmount = fromAmount.add(from.getAmount());
        }
        for (CoinTo to : coinData.getTo()) {
            if (to.getAssetsChainId() != assetChainId || to.getAssetsId() != assetId) continue;
            toAmount = toAmount.add(to.getAmount());
        }
        return fromAmount.subtract(toAmount);
    }

    private List<CoinTo> getRewardCoin(MeetingMember self, MeetingRound localRound, long unlockHeight, Map<String, BigInteger> awardAssetMap, Chain chain, long nowHeight) throws NulsException {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        RoundInfo roundInfo = new RoundInfo(localRound.getTotalWeight(), localRound.getStartTime(), localRound.getEndTime(), localRound.getMemberCount());
        ArrayList<DepositInfo> depositList = new ArrayList<DepositInfo>();
        for (Deposit deposit : self.getDepositList()) {
            DepositInfo depositInfo = new DepositInfo(deposit.getDeposit(), deposit.getAddress());
            depositList.add(depositInfo);
        }
        Agent agent = self.getAgent();
        AgentInfo agentInfo = new AgentInfo(agent.getCommissionRate(), agent.getDeposit(), agent.getRewardAddress(), agent.getTotalDeposit(), agent.getCreditVal(), depositList);
        param.put("chainId", chain.getConfig().getChainId());
        param.put("roundInfo", roundInfo);
        param.put("agentInfo", agentInfo);
        param.put("awardAssetMap", awardAssetMap);
        param.put("nowHeight", nowHeight);
        Result result = this.economicService.calcReward(param);
        if (result.isFailed()) {
            chain.getLogger().error("Miscalculation of Consensus Reward");
            throw new NulsException(result.getErrorCode());
        }
        return (List)((Map)result.getData()).get("coinToList");
    }
}

