/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.consensus.utils.validator;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.consensus.constant.ConsensusErrorCode;
import io.nuls.consensus.model.bo.Chain;
import io.nuls.consensus.model.bo.tx.txdata.Agent;
import io.nuls.consensus.model.bo.tx.txdata.CancelDeposit;
import io.nuls.consensus.model.bo.tx.txdata.DelayStopAgent;
import io.nuls.consensus.model.bo.tx.txdata.Deposit;
import io.nuls.consensus.model.bo.tx.txdata.RedPunishData;
import io.nuls.consensus.model.bo.tx.txdata.StopAgent;
import io.nuls.consensus.model.po.AgentPo;
import io.nuls.consensus.model.po.DepositPo;
import io.nuls.consensus.model.po.PunishLogPo;
import io.nuls.consensus.rpc.call.CallMethodUtils;
import io.nuls.consensus.storage.AgentStorageService;
import io.nuls.consensus.storage.DepositStorageService;
import io.nuls.consensus.utils.compare.CoinFromComparator;
import io.nuls.consensus.utils.compare.CoinToComparator;
import io.nuls.consensus.utils.manager.AgentManager;
import io.nuls.consensus.utils.manager.ChainManager;
import io.nuls.consensus.utils.manager.CoinDataManager;
import io.nuls.consensus.utils.manager.ConsensusManager;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ArraysTool;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.StringUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Component
public class TxValidator {
    @Autowired
    private AgentStorageService agentStorageService;
    @Autowired
    private DepositStorageService depositStorageService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private CoinDataManager coinDataManager;
    @Autowired
    private ConsensusManager consensusManager;

    public boolean validateTx(Chain chain, Transaction tx) throws NulsException, IOException {
        switch (tx.getType()) {
            case 4: 
            case 20: {
                return this.validateCreateAgent(chain, tx);
            }
            case 9: 
            case 23: {
                return this.validateStopAgent(chain, tx);
            }
            case 5: 
            case 21: {
                return this.validateDeposit(chain, tx);
            }
            case 6: 
            case 22: {
                return this.validateWithdraw(chain, tx);
            }
            case 34: {
                return this.validateDelayStopAgent(chain, tx);
            }
        }
        return false;
    }

    private boolean validateDelayStopAgent(Chain chain, Transaction tx) throws NulsException, IOException {
        DelayStopAgent txData = new DelayStopAgent();
        txData.parse(tx.getTxData(), 0);
        AgentPo agentPo = this.agentStorageService.get(txData.getAgentHash(), chain.getConfig().getChainId());
        if (null == agentPo || agentPo.getDelHeight() <= 1L) {
            chain.getLogger().warn("agent hash not right,{}", new Object[]{txData.getAgentHash().toHex()});
            return false;
        }
        if (txData.getHeight() != agentPo.getDelHeight()) {
            chain.getLogger().warn("agent delHeight not right,{}", new Object[]{txData.getAgentHash().toHex()});
            return false;
        }
        Agent agent = null;
        for (Agent a : chain.getAgentList()) {
            if (!a.getTxHash().equals((Object)agentPo.getHash())) continue;
            agent = a;
            break;
        }
        if (null == agent || agent.getDelHeight() <= 1L) {
            chain.getLogger().warn("Cache agent deleteHeight not right,{}", new Object[]{txData.getAgentHash().toHex()});
            return false;
        }
        CoinData csCoinData = this.coinDataManager.getStopAgentCoinData(chain, agent, 1L);
        if (!ArraysTool.arrayEquals((byte[])csCoinData.serialize(), (byte[])tx.getCoinData())) {
            chain.getLogger().warn("Delay stop agent coindata not right,{}", new Object[]{txData.getAgentHash().toHex()});
            return false;
        }
        TransactionSignature signature = new TransactionSignature();
        signature.parse(tx.getTransactionSignature(), 0);
        if (signature.getSignersCount() > 1) {
            chain.getLogger().warn("Delay stop agent signature count not right,{}", new Object[]{txData.getAgentHash().toHex()});
            return false;
        }
        P2PHKSignature sig = (P2PHKSignature)signature.getP2PHKSignatures().get(0);
        if (!ECKey.verify((byte[])tx.getHash().getBytes(), (byte[])sig.getSignData().getSignBytes(), (byte[])sig.getPublicKey())) {
            chain.getLogger().warn("Delay stop agent signature not right,{}", new Object[]{txData.getAgentHash().toHex()});
            return false;
        }
        byte[] address = AddressTool.getAddress((byte[])sig.getPublicKey(), (int)chain.getConfig().getChainId());
        String addr = AddressTool.getStringAddressByBytes((byte[])address);
        ArrayList<String> seedList = new ArrayList<String>(Arrays.asList(chain.getConfig().getSeedNodes().split(",")));
        if (!seedList.contains(addr)) {
            chain.getLogger().warn("Delay stop agent tx must sended by a seed address,{}", new Object[]{txData.getAgentHash().toHex()});
            return false;
        }
        return true;
    }

    private boolean validateCreateAgent(Chain chain, Transaction tx) throws NulsException {
        if (tx.getTxData() == null) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        Agent agent = new Agent();
        agent.parse(tx.getTxData(), 0);
        if (!this.createAgentBasicValid(chain, tx, agent)) {
            return false;
        }
        return this.createAgentAddrValid(chain, tx, agent);
    }

    private boolean validateStopAgent(Chain chain, Transaction tx) throws NulsException, IOException {
        if (tx.getTxData() == null) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        StopAgent stopAgent = new StopAgent();
        stopAgent.parse(tx.getTxData(), 0);
        AgentPo agentPo = this.agentStorageService.get(stopAgent.getCreateTxHash(), chain.getConfig().getChainId());
        if (agentPo == null || agentPo.getDelHeight() > 0L) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        CoinData coinData = new CoinData();
        coinData.parse(tx.getCoinData(), 0);
        if (coinData.getTo() == null || coinData.getTo().isEmpty()) {
            throw new NulsException(ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        if (!this.stopAgentCoinDataValid(chain, tx, agentPo, stopAgent, coinData)) {
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        return true;
    }

    private boolean validateDeposit(Chain chain, Transaction tx) throws NulsException {
        if (null == tx || null == tx.getTxData() || tx.getCoinData() == null) {
            throw new NulsException(ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        Deposit deposit = new Deposit();
        deposit.parse(tx.getTxData(), 0);
        if (deposit.getAddress() == null || deposit.getAgentHash() == null || deposit.getDeposit() == null) {
            throw new NulsException(ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        if (!this.createDepositInfoValid(chain, deposit)) {
            return false;
        }
        CoinData coinData = new CoinData();
        coinData.parse(tx.getCoinData(), 0);
        if (!this.isDepositOk(deposit.getDeposit(), coinData)) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_ERROR);
        }
        if (tx.getType() == 5) {
            try {
                BigInteger fee;
                int size = tx.serialize().length;
                if (AddressTool.isMultiSignAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress())) {
                    MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
                    transactionSignature.parse(tx.getTransactionSignature(), 0);
                    size += transactionSignature.getM() * 110;
                    size -= tx.getTransactionSignature().length;
                }
                if ((fee = TransactionFeeCalculator.getConsensusTxFee((int)size, (long)chain.getConfig().getFeeUnit(chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId()))).compareTo(this.consensusManager.getFee(coinData, chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId())) > 0) {
                    chain.getLogger().error("Insufficient handling fees\uff01");
                    throw new NulsException(ConsensusErrorCode.FEE_NOT_ENOUGH);
                }
            }
            catch (IOException e) {
                chain.getLogger().error("Data serialization error\uff01");
                throw new NulsException(ConsensusErrorCode.SERIALIZE_ERROR);
            }
        }
        HashSet<String> addressSet = new HashSet<String>();
        int lockCount = 0;
        for (CoinTo coin : coinData.getTo()) {
            if (coin.getLockTime() == -1L) {
                ++lockCount;
            }
            addressSet.add(AddressTool.getStringAddressByBytes((byte[])coin.getAddress()));
        }
        if (lockCount > 1 || addressSet.size() > 1) {
            throw new NulsException(ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        return true;
    }

    private boolean validateWithdraw(Chain chain, Transaction tx) throws NulsException {
        CancelDeposit cancelDeposit = new CancelDeposit();
        cancelDeposit.parse(tx.getTxData(), 0);
        DepositPo depositPo = this.depositStorageService.get(cancelDeposit.getJoinTxHash(), chain.getConfig().getChainId());
        if (depositPo == null || depositPo.getDelHeight() > 0L) {
            throw new NulsException(ConsensusErrorCode.DATA_NOT_EXIST);
        }
        CoinData coinData = new CoinData();
        coinData.parse(tx.getCoinData(), 0);
        if (coinData.getFrom().size() == 0 || coinData.getTo().size() == 0) {
            throw new NulsException(ConsensusErrorCode.DATA_ERROR);
        }
        if (!Arrays.equals(((CoinFrom)coinData.getFrom().get(0)).getAddress(), ((CoinTo)coinData.getTo().get(0)).getAddress()) || ((CoinFrom)coinData.getFrom().get(0)).getAssetsId() != ((CoinTo)coinData.getTo().get(0)).getAssetsId()) {
            throw new NulsException(ConsensusErrorCode.DATA_ERROR);
        }
        if (!ArraysTool.arrayEquals((byte[])CallMethodUtils.getNonce(cancelDeposit.getJoinTxHash().getBytes()), (byte[])((CoinFrom)coinData.getFrom().get(0)).getNonce())) {
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        if (depositPo.getDeposit().compareTo(((CoinFrom)coinData.getFrom().get(0)).getAmount()) != 0 || ((CoinTo)coinData.getTo().get(0)).getAmount().compareTo(BigInteger.ZERO) <= 0) {
            throw new NulsException(ConsensusErrorCode.DATA_ERROR);
        }
        if (tx.getType() == 22 && ((CoinTo)coinData.getTo().get(0)).getAmount().compareTo(depositPo.getDeposit()) > 0) {
            throw new NulsException(ConsensusErrorCode.DATA_ERROR);
        }
        if (tx.getType() == 6 && ((CoinTo)coinData.getTo().get(0)).getAmount().compareTo(depositPo.getDeposit()) >= 0) {
            throw new NulsException(ConsensusErrorCode.DATA_ERROR);
        }
        return true;
    }

    private boolean createAgentBasicValid(Chain chain, Transaction tx, Agent agent) throws NulsException {
        if (!AddressTool.validNormalAddress((byte[])agent.getPackingAddress(), (int)chain.getConfig().getChainId())) {
            throw new NulsException(ConsensusErrorCode.ADDRESS_ERROR);
        }
        if (Arrays.equals(agent.getAgentAddress(), agent.getPackingAddress())) {
            throw new NulsException(ConsensusErrorCode.AGENTADDR_AND_PACKING_SAME);
        }
        if (Arrays.equals(agent.getRewardAddress(), agent.getPackingAddress())) {
            throw new NulsException(ConsensusErrorCode.REWARDADDR_AND_PACKING_SAME);
        }
        if (tx.getTime() <= 0L) {
            throw new NulsException(ConsensusErrorCode.DATA_ERROR);
        }
        byte commissionRate = agent.getCommissionRate();
        if (commissionRate < chain.getConfig().getCommissionRateMin() || commissionRate > chain.getConfig().getCommissionRateMax()) {
            throw new NulsException(ConsensusErrorCode.COMMISSION_RATE_OUT_OF_RANGE);
        }
        BigInteger deposit = agent.getDeposit();
        if (deposit.compareTo(chain.getConfig().getDepositMin()) < 0 || deposit.compareTo(chain.getConfig().getDepositMax()) > 0) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_OUT_OF_RANGE);
        }
        CoinData coinData = new CoinData();
        coinData.parse(tx.getCoinData(), 0);
        if (!this.isDepositOk(agent.getDeposit(), coinData)) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_ERROR);
        }
        if (tx.getType() == 4) {
            try {
                BigInteger fee;
                int size = tx.serialize().length;
                if (AddressTool.isMultiSignAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress())) {
                    MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
                    transactionSignature.parse(tx.getTransactionSignature(), 0);
                    size += transactionSignature.getM() * 110;
                    size -= tx.getTransactionSignature().length;
                }
                if ((fee = TransactionFeeCalculator.getConsensusTxFee((int)size, (long)chain.getConfig().getFeeUnit(chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId()))).compareTo(this.consensusManager.getFee(coinData, chain.getConfig().getAgentChainId(), chain.getConfig().getAgentAssetId())) > 0) {
                    chain.getLogger().error("Insufficient handling fees\uff01");
                    throw new NulsException(ConsensusErrorCode.FEE_NOT_ENOUGH);
                }
            }
            catch (IOException e) {
                chain.getLogger().error("Data serialization error\uff01");
                throw new NulsException(ConsensusErrorCode.SERIALIZE_ERROR);
            }
        }
        HashSet<String> addressSet = new HashSet<String>();
        int lockCount = 0;
        for (CoinTo coin : coinData.getTo()) {
            if (coin.getAssetsChainId() != chain.getConfig().getAgentChainId() || coin.getAssetsId() != chain.getConfig().getAgentAssetId()) {
                chain.getLogger().error("Illegal locking of assets");
                throw new NulsException(ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
            }
            if (coin.getLockTime() == -1L) {
                ++lockCount;
            }
            addressSet.add(AddressTool.getStringAddressByBytes((byte[])coin.getAddress()));
        }
        if (lockCount > 1 || addressSet.size() > 1) {
            throw new NulsException(ConsensusErrorCode.TX_DATA_VALIDATION_ERROR);
        }
        return true;
    }

    private boolean createAgentAddrValid(Chain chain, Transaction tx, Agent agent) throws NulsException {
        long count;
        String seedNodesStr = chain.getConfig().getSeedNodes();
        if (StringUtils.isBlank((String)seedNodesStr)) {
            return true;
        }
        String splitSign = ",";
        for (String nodeAddress : seedNodesStr.split(splitSign)) {
            byte[] nodeAddressBytes = AddressTool.getAddress((String)nodeAddress);
            if (Arrays.equals(nodeAddressBytes, agent.getAgentAddress())) {
                throw new NulsException(ConsensusErrorCode.AGENT_EXIST);
            }
            if (!Arrays.equals(nodeAddressBytes, agent.getPackingAddress())) continue;
            throw new NulsException(ConsensusErrorCode.AGENT_PACKING_EXIST);
        }
        List<Agent> agentList = chain.getNewOrWorkAgentList(chain.getNewestHeader().getHeight());
        if (agentList != null && agentList.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (Agent agentTemp : agentList) {
                if (agentTemp.getTxHash().equals((Object)tx.getHash())) {
                    throw new NulsException(ConsensusErrorCode.TRANSACTION_REPEATED);
                }
                set.add(HexUtil.encode((byte[])agentTemp.getAgentAddress()));
                set.add(HexUtil.encode((byte[])agentTemp.getPackingAddress()));
            }
            boolean b = set.contains(HexUtil.encode((byte[])agent.getAgentAddress()));
            if (b) {
                throw new NulsException(ConsensusErrorCode.AGENT_EXIST);
            }
            b = set.contains(HexUtil.encode((byte[])agent.getPackingAddress()));
            if (b) {
                throw new NulsException(ConsensusErrorCode.AGENT_PACKING_EXIST);
            }
        }
        if ((count = this.getRedPunishCount(chain, agent.getAgentAddress())) > 0L) {
            throw new NulsException(ConsensusErrorCode.LACK_OF_CREDIT);
        }
        return true;
    }

    private boolean stopAgentCoinDataValid(Chain chain, Transaction tx, AgentPo agentPo, StopAgent stopAgent, CoinData coinData) throws NulsException, IOException {
        Agent agent = this.agentManager.poToAgent(agentPo);
        CoinData localCoinData = this.coinDataManager.getStopAgentCoinData(chain, agent, ((CoinTo)coinData.getTo().get(0)).getLockTime());
        CoinFromComparator fromComparator = new CoinFromComparator();
        CoinToComparator toComparator = new CoinToComparator();
        coinData.getFrom().sort(fromComparator);
        coinData.getTo().sort(toComparator);
        localCoinData.getFrom().sort(fromComparator);
        localCoinData.getTo().sort(toComparator);
        CoinTo last = (CoinTo)localCoinData.getTo().get(localCoinData.getTo().size() - 1);
        if (tx.getType() == 9) {
            int size = tx.size();
            if (!AddressTool.isMultiSignAddress((byte[])agentPo.getAgentAddress())) {
                size += 110;
            } else {
                MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                size += transactionSignature.getM() * 110;
            }
            BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)(size -= tx.getTransactionSignature().length), (long)chain.getConfig().getFeeUnit(chain.getConfig().getChainId(), 1));
            last.setAmount(last.getAmount().subtract(fee));
        }
        return Arrays.equals(coinData.serialize(), localCoinData.serialize());
    }

    private boolean createDepositInfoValid(Chain chain, Deposit deposit) throws NulsException {
        AgentPo agentPo = this.agentStorageService.get(deposit.getAgentHash(), chain.getConfig().getChainId());
        if (agentPo == null || agentPo.getDelHeight() > 0L) {
            throw new NulsException(ConsensusErrorCode.AGENT_NOT_EXIST);
        }
        List<DepositPo> poList = this.getDepositListByAgent(chain, deposit.getAgentHash());
        BigInteger total = deposit.getDeposit();
        if (total.compareTo(chain.getConfig().getEntrusterDepositMin()) < 0) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_NOT_ENOUGH);
        }
        BigInteger commissionMax = chain.getConfig().getCommissionMax();
        if (ProtocolGroupManager.getCurrentVersion((int)chain.getConfig().getChainId()) >= 23) {
            commissionMax = chain.getConfig().getCommissionMaxV23();
        }
        if (total.compareTo(commissionMax) > 0) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_OVER_AMOUNT);
        }
        for (DepositPo cd : poList) {
            total = total.add(cd.getDeposit());
        }
        if (total.compareTo(commissionMax) > 0) {
            throw new NulsException(ConsensusErrorCode.DEPOSIT_OVER_AMOUNT);
        }
        return true;
    }

    private boolean isDepositOk(BigInteger deposit, CoinData coinData) throws NulsException {
        if (coinData == null || coinData.getTo().size() == 0) {
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        CoinTo coin = (CoinTo)coinData.getTo().get(0);
        if (!BigIntegerUtils.isEqual((BigInteger)deposit, (BigInteger)coin.getAmount())) {
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        if (coin.getLockTime() != -1L) {
            throw new NulsException(ConsensusErrorCode.COIN_DATA_VALID_ERROR);
        }
        return true;
    }

    private long getRedPunishCount(Chain chain, byte[] address) {
        List<PunishLogPo> list = chain.getRedPunishList();
        if (null == list || list.isEmpty()) {
            return 0L;
        }
        long count = 0L;
        for (PunishLogPo po : list) {
            if (!Arrays.equals(address, po.getAddress())) continue;
            ++count;
        }
        return count;
    }

    public List<DepositPo> getDepositListByAgent(Chain chain, NulsHash agentHash) throws NulsException {
        List<DepositPo> depositList;
        try {
            depositList = this.depositStorageService.getList(chain.getConfig().getChainId());
        }
        catch (Exception e) {
            throw new NulsException(ConsensusErrorCode.DATA_PARSE_ERROR);
        }
        long startBlockHeight = chain.getNewestHeader().getHeight();
        ArrayList<DepositPo> resultList = new ArrayList<DepositPo>();
        for (DepositPo deposit : depositList) {
            if (deposit.getDelHeight() != -1L && deposit.getDelHeight() <= startBlockHeight || deposit.getBlockHeight() > startBlockHeight || deposit.getBlockHeight() < 0L || !deposit.getAgentHash().equals((Object)agentHash)) continue;
            resultList.add(deposit);
        }
        return resultList;
    }

    public Set<NulsHash> getInvalidAgentHash(List<Transaction> redPunishTxs, List<Transaction> contractStopAgentTxs, List<Transaction> stopAgentTxs, Chain chain) {
        HashSet<String> redPunishAddressSet = new HashSet<String>();
        if (redPunishTxs != null && redPunishTxs.size() > 0) {
            for (Transaction redPunishTx : redPunishTxs) {
                RedPunishData redPunishData = new RedPunishData();
                try {
                    redPunishData.parse(redPunishTx.getTxData(), 0);
                    String addressHex = HexUtil.encode((byte[])redPunishData.getAddress());
                    redPunishAddressSet.add(addressHex);
                }
                catch (NulsException e) {
                    chain.getLogger().error(e);
                }
            }
        }
        HashSet<NulsHash> agentHashSet = new HashSet<NulsHash>();
        List<Agent> agentList = chain.getAgentList();
        long startBlockHeight = chain.getNewestHeader().getHeight();
        if (!redPunishAddressSet.isEmpty()) {
            for (Agent agent : agentList) {
                if (agent.getDelHeight() != -1L && agent.getDelHeight() <= startBlockHeight || agent.getBlockHeight() > startBlockHeight || agent.getBlockHeight() < 0L || !redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getAgentAddress())) && !redPunishAddressSet.contains(HexUtil.encode((byte[])agent.getPackingAddress()))) continue;
                agentHashSet.add(agent.getTxHash());
            }
        }
        try {
            StopAgent stopAgent;
            if (stopAgentTxs != null) {
                stopAgent = new StopAgent();
                for (Transaction tx : stopAgentTxs) {
                    stopAgent.parse(tx.getTxData(), 0);
                    agentHashSet.add(stopAgent.getCreateTxHash());
                }
            }
            if (contractStopAgentTxs != null) {
                stopAgent = new StopAgent();
                for (Transaction tx : contractStopAgentTxs) {
                    stopAgent.parse(tx.getTxData(), 0);
                    agentHashSet.add(stopAgent.getCreateTxHash());
                }
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
        return agentHashSet;
    }
}

