/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.callable;

import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.helper.ContractConflictChecker;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.helper.ContractNewTxHandler;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.CallableResult;
import io.nuls.contract.model.bo.ContractContainer;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.service.ContractExecutor;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.core.basic.Result;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ContractTxCallable
implements Callable<ContractResult> {
    private ContractExecutor contractExecutor;
    private ContractHelper contractHelper;
    private ContractNewTxHandler contractNewTxHandler;
    private ContractTempBalanceManager tempBalanceManager;
    private ProgramExecutor executor;
    private String contract;
    private ContractWrapperTransaction tx;
    private long number;
    private String preStateRoot;
    private ContractConflictChecker checker;
    private ContractContainer container;
    private int chainId;
    private int blockType;
    private long blockTime;

    public ContractTxCallable(int chainId, int blockType, long blockTime, ProgramExecutor executor, String contract, ContractWrapperTransaction tx, long number, String preStateRoot, ContractConflictChecker checker, ContractContainer container) {
        this.chainId = chainId;
        this.blockType = blockType;
        this.blockTime = blockTime;
        this.contractExecutor = (ContractExecutor)SpringLiteContext.getBean(ContractExecutor.class);
        this.contractHelper = (ContractHelper)SpringLiteContext.getBean(ContractHelper.class);
        this.contractNewTxHandler = (ContractNewTxHandler)SpringLiteContext.getBean(ContractNewTxHandler.class);
        this.tempBalanceManager = this.contractHelper.getBatchInfoTempBalanceManager(chainId);
        this.executor = executor;
        this.contract = contract;
        this.tx = tx;
        this.number = number;
        this.preStateRoot = preStateRoot;
        this.checker = checker;
        this.container = container;
    }

    @Override
    public ContractResult call() throws Exception {
        ChainManager.chainHandle(this.chainId, this.blockType);
        BatchInfo batchInfo = this.contractHelper.getChain(this.chainId).getBatchInfo();
        String hash = this.tx.getHash().toHex();
        if (!batchInfo.checkGasCostTotal(this.tx.getHash().toHex())) {
            Log.error("Exceed tx count [600] or gas limit of block [13,000,000 gas], the contract transaction [{}] revert to package queue.", hash);
            return null;
        }
        long start = 0L;
        if (Log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        CallableResult callableResult = this.container.getCallableResult();
        ContractResult contractResult = null;
        ContractData contractData = this.tx.getContractData();
        int type = this.tx.getType();
        if (this.container.isHasCreate()) {
            contractResult = this.contractHelper.makeFailedContractResult(this.chainId, this.tx, callableResult, "contract lock or not exist.");
        } else if (this.container.isDelete()) {
            contractResult = this.contractHelper.makeFailedContractResult(this.chainId, this.tx, callableResult, "contract has been terminated.");
        } else if (type != 17 && !ContractUtil.checkPrice(contractData.getPrice())) {
            contractResult = this.contractHelper.makeFailedContractResult(this.chainId, this.tx, callableResult, "The gas price is error.");
        } else {
            switch (type) {
                case 15: {
                    this.container.setHasCreate(true);
                    contractResult = this.contractExecutor.create(this.executor, contractData, this.number, this.preStateRoot, ContractUtil.extractPublicKey(this.tx));
                    if (!ContractUtil.makeContractResultAndCheckGasSerial(this.tx, contractResult, batchInfo)) break;
                    this.checkCreateResult(this.tx, callableResult, contractResult);
                    break;
                }
                case 10: {
                    if (ProtocolGroupManager.getCurrentVersion((int)this.chainId) < ContractContext.UPDATE_VERSION_V250) break;
                }
                case 16: {
                    contractResult = this.contractExecutor.call(this.executor, contractData, this.number, this.preStateRoot, ContractUtil.extractPublicKey(this.tx));
                    boolean bool = ContractUtil.makeContractResultAndCheckGasSerial(this.tx, contractResult, batchInfo);
                    if (!bool) break;
                    this.checkCallResult(this.tx, callableResult, contractResult);
                    break;
                }
                case 17: {
                    contractResult = this.contractExecutor.delete(this.executor, contractData, this.number, this.preStateRoot);
                    boolean isDelete = this.checkDeleteResult(this.tx, callableResult, contractResult);
                    this.container.setDelete(isDelete);
                    break;
                }
            }
        }
        if (contractResult != null && !contractResult.isSuccess()) {
            Log.error("Failed TxType [{}] Execute ContractResult is {}", this.tx.getType(), contractResult.toString());
            if (ProtocolGroupManager.getCurrentVersion((int)this.chainId) >= ContractContext.UPDATE_VERSION_V240) {
                contractResult.setGasUsed(contractData.getGasLimit());
            }
        }
        Log.info("[Per Contract Execution Cost Time] TxType is {}, TxHash is {}, Cost Time is {}", this.tx.getType(), this.tx.getHash().toString(), System.currentTimeMillis() - start);
        return contractResult;
    }

    private void checkCreateResult(ContractWrapperTransaction tx, CallableResult callableResult, ContractResult contractResult) {
        if (contractResult.isSuccess()) {
            Result checkResult = this.contractHelper.validateNrc20Contract(this.chainId, (ProgramExecutor)contractResult.getTxTrack(), tx, contractResult);
            if (checkResult.isFailed()) {
                Log.error("check validateNrc20Contract Result is {}", checkResult.toString());
            }
            if (checkResult.isSuccess()) {
                this.container.getCommitSet().add(this.contract);
                this.commitContract(contractResult);
            }
            callableResult.getResultList().add(contractResult);
        } else {
            callableResult.putFailed(this.chainId, contractResult);
        }
    }

    private void checkCallResult(ContractWrapperTransaction tx, CallableResult callableResult, ContractResult contractResult) throws IOException, NulsException {
        List<ContractResult> reCallList = callableResult.getReCallList();
        boolean isConflict = this.checker.checkConflict(this.chainId, tx, contractResult, this.container.getCommitSet());
        if (isConflict) {
            if (!ContractUtil.isNotEnoughGasError(contractResult)) {
                Log.error("Conflict TxType [{}] Execute ContractResult is {}", tx.getType(), contractResult.toString());
                reCallList.add(contractResult);
            } else {
                callableResult.putFailed(this.chainId, contractResult);
            }
        } else {
            this.dealCallResult(tx, callableResult, contractResult, this.chainId, this.blockTime);
        }
    }

    private void dealCallResult(ContractWrapperTransaction tx, CallableResult callableResult, ContractResult contractResult, int chainId, long blockTime) throws IOException, NulsException {
        if (contractResult.isSuccess()) {
            this.checkConflictWithFailedMap(callableResult, contractResult);
            this.contractNewTxHandler.handleContractNewTx(chainId, blockTime, tx, contractResult, this.tempBalanceManager);
        }
        if (contractResult.isSuccess()) {
            callableResult.getResultList().add(contractResult);
            this.commitContract(contractResult);
        } else {
            callableResult.putFailed(chainId, contractResult);
        }
    }

    private void commitContract(ContractResult contractResult) {
        if (!contractResult.isSuccess()) {
            return;
        }
        Object txTrackObj = contractResult.getTxTrack();
        if (txTrackObj != null && txTrackObj instanceof ProgramExecutor) {
            ProgramExecutor txTrack = (ProgramExecutor)txTrackObj;
            txTrack.commit();
        }
    }

    private void checkConflictWithFailedMap(CallableResult callableResult, ContractResult contractResult) {
        Map<String, Set<ContractResult>> failedMap = callableResult.getFailedMap();
        Set<String> addressSet = ContractUtil.collectAddress(this.chainId, contractResult);
        for (String address : addressSet) {
            Set<ContractResult> removedSet = failedMap.get(address);
            if (removedSet == null) continue;
            ArrayList<ContractResult> recallList = new ArrayList<ContractResult>();
            for (ContractResult _contractResult : removedSet) {
                if (ContractUtil.isNotEnoughGasError(_contractResult)) continue;
                callableResult.getReCallList().add(_contractResult);
                recallList.add(_contractResult);
            }
            if (recallList.size() <= 0) continue;
            if (recallList.size() == removedSet.size()) {
                failedMap.remove(address);
                continue;
            }
            removedSet.removeAll(recallList);
        }
    }

    private boolean checkDeleteResult(ContractWrapperTransaction tx, CallableResult callableResult, ContractResult contractResult) {
        ContractUtil.makeContractResult(tx, contractResult);
        boolean result = false;
        if (contractResult.isSuccess()) {
            result = true;
            this.commitContract(contractResult);
            callableResult.getResultList().add(contractResult);
        } else {
            callableResult.putFailed(this.chainId, contractResult);
        }
        return result;
    }
}

