/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.helper;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ContractTxValidatorManager;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractBalance;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.dto.AccountAmountDto;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.model.txdata.CallContractData;
import io.nuls.contract.model.txdata.CreateContractData;
import io.nuls.contract.model.txdata.DeleteContractData;
import io.nuls.contract.rpc.call.AccountCall;
import io.nuls.contract.rpc.call.BlockCall;
import io.nuls.contract.rpc.call.TransactionCall;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramCall;
import io.nuls.contract.vm.program.ProgramCreate;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramInternalCall;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.contract.vm.program.ProgramStatus;
import io.nuls.core.basic.NulsData;
import io.nuls.core.basic.Result;
import io.nuls.core.basic.VarInt;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ArraysTool;
import io.nuls.core.model.LongUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class ContractTxHelper {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractTxValidatorManager contractTxValidatorManager;

    public Result<CreateContractTransaction> makeCreateTx(int chainId, String sender, String alias, Long gasLimit, Long price, byte[] contractCode, String[][] args, String password, String remark) {
        try {
            Result accountResult = AccountCall.validationPassword(chainId, sender, password);
            if (accountResult.isFailed()) {
                return accountResult;
            }
            String contractAddress = AccountCall.createContractAddress(chainId);
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            byte[] senderBytes = AddressTool.getAddress((String)sender);
            Result validateCreate = this.validateCreate(chainId, senderBytes, contractAddressBytes, gasLimit, price, contractCode, args);
            if (validateCreate.isFailed()) {
                return validateCreate;
            }
            Result<CreateContractTransaction> result = this.newCreateTx(chainId, sender, senderBytes, contractAddressBytes, alias, gasLimit, price, contractCode, args, remark);
            return result;
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    public Result<CreateContractTransaction> newCreateTx(int chainId, String sender, byte[] senderBytes, byte[] contractAddressBytes, String alias, Long gasLimit, Long price, byte[] contractCode, String[][] args, String remark) {
        try {
            BigInteger value = BigInteger.ZERO;
            CreateContractTransaction tx = new CreateContractTransaction();
            if (StringUtils.isNotBlank((String)remark)) {
                tx.setRemark(remark.getBytes(StandardCharsets.UTF_8));
            }
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            CreateContractData createContractData = this.getCreateContractData(senderBytes, contractAddressBytes, alias, gasLimit, price, contractCode, args);
            CoinData coinData = new CoinData();
            Result makeCoinDataResult = this.makeCoinData(chainId, sender, senderBytes, contractAddressBytes, gasLimit, price, value, tx.size(), (NulsData)createContractData, coinData, null, null);
            if (makeCoinDataResult.isFailed()) {
                return makeCoinDataResult;
            }
            tx.setTxDataObj(createContractData);
            tx.setCoinDataObj(coinData);
            tx.serializeData();
            return ContractUtil.getSuccess().setData((Object)tx);
        }
        catch (IOException e) {
            Log.error(e);
            Result result = Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_TX_CREATE_ERROR);
            result.setMsg(e.getMessage());
            return result;
        }
    }

    public Result validateCreate(int chainId, byte[] sender, byte[] contractAddress, Long gasLimit, Long price, byte[] contractCode, String[][] args) {
        try {
            BigInteger value = BigInteger.ZERO;
            if (!ContractUtil.checkPrice(price)) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_MINIMUM_PRICE_ERROR);
            }
            if (contractAddress == null) {
                contractAddress = AddressTool.getAddress((String)AccountCall.createContractAddress(chainId));
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            long blockHeight = blockHeader.getHeight();
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramExecutor programExecutor = this.contractHelper.getProgramExecutor(chainId);
            ProgramCreate programCreate = new ProgramCreate();
            programCreate.setContractAddress(contractAddress);
            programCreate.setSender(sender);
            programCreate.setValue(value);
            programCreate.setPrice(price);
            programCreate.setNumber(blockHeight);
            programCreate.setContractCode(contractCode);
            if (args != null) {
                programCreate.setArgs(args);
            }
            ProgramExecutor track = programExecutor.begin(prevStateRoot);
            long realGasLimit = gasLimit;
            programCreate.setGasLimit(10000000L);
            ProgramResult programResult = track.create(programCreate);
            if (!programResult.isSuccess()) {
                Log.error(programResult.getErrorMessage() + ", " + programResult.getStackTrace());
                Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
                result = ContractUtil.checkVmResultAndReturn(programResult.getErrorMessage(), result);
                ContractUtil.addDebugEvents(programResult.getDebugEvents(), result);
                return result;
            }
            if (realGasLimit != 10000000L) {
                programCreate.setGasLimit(realGasLimit);
                track = programExecutor.begin(prevStateRoot);
                programResult = track.create(programCreate);
                if (!programResult.isSuccess()) {
                    Log.error(programResult.getStackTrace());
                    Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                    result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
                    ContractUtil.addDebugEvents(programResult.getDebugEvents(), result);
                    return result;
                }
            }
            return ContractUtil.getSuccess().setData((Object)programResult);
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    private int calcSize(NulsData nulsData) {
        if (nulsData == null) {
            return 0;
        }
        int size = nulsData.size();
        return VarInt.sizeOf((long)size) + size - 1;
    }

    public Result makeCoinData(int chainId, String sender, byte[] senderBytes, byte[] contractAddress, long gasLimit, long price, BigInteger value, int txSize, NulsData txData, CoinData coinData, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOtherList) {
        BigInteger imputedValue;
        long gasUsed = gasLimit;
        BigInteger totalValue = imputedValue = BigInteger.valueOf(LongUtils.mul((long)gasUsed, (long)price));
        int nulsAssetChainId = ContractContext.LOCAL_CHAIN_ID;
        int nulsAssetId = ContractContext.LOCAL_MAIN_ASSET_ID;
        totalValue = totalValue.add(value);
        if (value.compareTo(BigInteger.ZERO) > 0) {
            coinData.addTo(new CoinTo(contractAddress, nulsAssetChainId, nulsAssetId, value));
        }
        if (nulsValueToOtherList != null && !nulsValueToOtherList.isEmpty()) {
            for (AccountAmountDto dto : nulsValueToOtherList) {
                totalValue = totalValue.add(dto.getValue());
                coinData.addTo(new CoinTo(AddressTool.getAddress((String)dto.getTo()), nulsAssetChainId, nulsAssetId, dto.getValue()));
            }
        }
        ContractBalance senderBalance = this.contractHelper.getUnConfirmedBalanceAndNonce(chainId, nulsAssetChainId, nulsAssetId, sender);
        CoinFrom coinFrom = new CoinFrom(senderBytes, nulsAssetChainId, nulsAssetId, totalValue, RPCUtil.decode((String)senderBalance.getNonce()), 0);
        coinData.addFrom(coinFrom);
        if (multyAssetValues != null && !multyAssetValues.isEmpty()) {
            for (ProgramMultyAssetValue multyAssetValue : multyAssetValues) {
                int assetChainId = multyAssetValue.getAssetChainId();
                int assetId = multyAssetValue.getAssetId();
                BigInteger _value = multyAssetValue.getValue();
                ContractBalance senderBalanceOfTransfer = this.contractHelper.getUnConfirmedBalanceAndNonce(chainId, assetChainId, assetId, sender);
                if (_value.compareTo(BigInteger.ZERO) <= 0) continue;
                if (senderBalanceOfTransfer.getBalance().compareTo(_value) < 0) {
                    Log.error("Insufficient balance, asset: {}-{}", assetChainId, assetId);
                    return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE);
                }
                CoinFrom coinFromOfTransfer = new CoinFrom(senderBytes, assetChainId, assetId, _value, RPCUtil.decode((String)senderBalanceOfTransfer.getNonce()), 0);
                CoinTo coinTo = new CoinTo(contractAddress, assetChainId, assetId, _value);
                coinData.addFrom(coinFromOfTransfer);
                coinData.addTo(coinTo);
            }
        }
        Chain chain = this.contractHelper.getChain(chainId);
        BigInteger fee = TransactionFeeCalculator.getNormalUnsignedTxFee((int)(txSize + this.calcSize(txData) + this.calcSize((NulsData)coinData)), (long)chain.getConfig().getFeeUnit(nulsAssetChainId, nulsAssetId), (double)chain.getConfig().getFeeCoefficient(nulsAssetChainId, nulsAssetId));
        totalValue = totalValue.add(fee);
        if (senderBalance.getBalance().compareTo(totalValue) < 0) {
            Log.error("Insufficient balance, asset: {}-{}", ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID);
            return Result.getFailed((ErrorCode)ContractErrorCode.INSUFFICIENT_BALANCE);
        }
        coinFrom.setAmount(totalValue);
        return ContractUtil.getSuccess();
    }

    public CreateContractData getCreateContractData(byte[] senderBytes, byte[] contractAddressBytes, String alias, long gasLimit, long price, byte[] contractCode, String[][] args) {
        CreateContractData createContractData = new CreateContractData();
        createContractData.setSender(senderBytes);
        createContractData.setContractAddress(contractAddressBytes);
        createContractData.setAlias(alias);
        createContractData.setGasLimit(gasLimit);
        createContractData.setPrice(price);
        createContractData.setCode(contractCode);
        if (args != null) {
            createContractData.setArgsCount((short)args.length);
            createContractData.setArgs(args);
        }
        return createContractData;
    }

    public Result<CallContractTransaction> makeCallTx(int chainId, String sender, BigInteger value, Long gasLimit, Long price, String contractAddress, String methodName, String methodDesc, String[][] args, String password, String remark, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOtherList) {
        Result accountResult;
        if (value == null) {
            value = BigInteger.ZERO;
        }
        if ((accountResult = AccountCall.validationPassword(chainId, sender, password)).isFailed()) {
            return accountResult;
        }
        byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
        byte[] senderBytes = AddressTool.getAddress((String)sender);
        Result validateCall = this.validateCall(chainId, senderBytes, contractAddressBytes, value, gasLimit, price, methodName, methodDesc, args, multyAssetValues);
        if (validateCall.isFailed()) {
            return validateCall;
        }
        Result<CallContractTransaction> result = this.newCallTx(chainId, sender, senderBytes, value, gasLimit, price, contractAddressBytes, methodName, methodDesc, args, remark, multyAssetValues, nulsValueToOtherList);
        return result;
    }

    public Result<CallContractTransaction> newCallTx(int chainId, String sender, byte[] senderBytes, BigInteger value, Long gasLimit, Long price, byte[] contractAddressBytes, String methodName, String methodDesc, String[][] args, String remark, List<ProgramMultyAssetValue> multyAssetValues, List<AccountAmountDto> nulsValueToOtherList) {
        try {
            CallContractTransaction tx = new CallContractTransaction();
            if (StringUtils.isNotBlank((String)remark)) {
                tx.setRemark(remark.getBytes(StandardCharsets.UTF_8));
            }
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            CallContractData callContractData = this.getCallContractData(senderBytes, contractAddressBytes, value, gasLimit, price, methodName, methodDesc, args);
            CoinData coinData = new CoinData();
            Result makeCoinDataResult = this.makeCoinData(chainId, sender, senderBytes, contractAddressBytes, gasLimit, price, value, tx.size(), (NulsData)callContractData, coinData, multyAssetValues, nulsValueToOtherList);
            if (makeCoinDataResult.isFailed()) {
                return makeCoinDataResult;
            }
            tx.setTxDataObj(callContractData);
            tx.setCoinDataObj(coinData);
            tx.serializeData();
            return ContractUtil.getSuccess().setData((Object)tx);
        }
        catch (IOException e) {
            Log.error(e);
            Result result = Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_EXECUTE_ERROR);
            result.setMsg(e.getMessage());
            return result;
        }
    }

    private CallContractData getCallContractData(byte[] senderBytes, byte[] contractAddressBytes, BigInteger value, long gasLimit, long price, String methodName, String methodDesc, String[][] args) {
        CallContractData callContractData = new CallContractData();
        callContractData.setContractAddress(contractAddressBytes);
        callContractData.setSender(senderBytes);
        callContractData.setValue(value);
        callContractData.setPrice(price);
        callContractData.setGasLimit(gasLimit);
        callContractData.setMethodName(methodName);
        callContractData.setMethodDesc(methodDesc);
        if (args != null) {
            callContractData.setArgsCount((short)args.length);
            callContractData.setArgs(args);
        }
        return callContractData;
    }

    public Result validateCall(int chainId, byte[] senderBytes, byte[] contractAddressBytes, BigInteger value, Long gasLimit, Long price, String methodName, String methodDesc, String[][] args, List<ProgramMultyAssetValue> multyAssetValues) {
        try {
            if (!ContractUtil.checkPrice(price)) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_MINIMUM_PRICE_ERROR);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            long blockHeight = blockHeader.getHeight();
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramCall programCall = new ProgramCall();
            programCall.setContractAddress(contractAddressBytes);
            programCall.setSender(senderBytes);
            programCall.setNumber(blockHeight);
            programCall.setMethodName(methodName);
            programCall.setMethodDesc(methodDesc);
            programCall.setArgs(args);
            ProgramMethod method = this.contractHelper.getMethodInfoByContractAddress(chainId, prevStateRoot, methodName, methodDesc, contractAddressBytes);
            if (method == null) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_METHOD_NOT_EXIST);
            }
            if (method.isView()) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_NOT_EXECUTE_VIEW);
            }
            programCall.setValue(value);
            programCall.setMultyAssetValues(multyAssetValues);
            programCall.setPrice(price);
            ProgramExecutor programExecutor = this.contractHelper.getProgramExecutor(chainId);
            ProgramExecutor track = programExecutor.begin(prevStateRoot);
            long realGasLimit = gasLimit;
            programCall.setGasLimit(10000000L);
            ProgramResult programResult = track.call(programCall);
            if (!programResult.isSuccess()) {
                Log.error("sender[{}], contractAddress[{}]" + programResult.getErrorMessage() + ", " + programResult.getStackTrace(), AddressTool.getStringAddressByBytes((byte[])senderBytes), AddressTool.getStringAddressByBytes((byte[])contractAddressBytes));
                Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
                result = ContractUtil.checkVmResultAndReturn(programResult.getErrorMessage(), result);
                ContractUtil.addDebugEvents(programResult.getDebugEvents(), result);
                return result;
            }
            if (realGasLimit != 10000000L) {
                programCall.setGasLimit(realGasLimit);
                track = programExecutor.begin(prevStateRoot);
                programResult = track.call(programCall);
                if (!programResult.isSuccess()) {
                    Log.error(programResult.getStackTrace());
                    Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                    result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
                    ContractUtil.addDebugEvents(programResult.getDebugEvents(), result);
                    return result;
                }
            }
            return ContractUtil.getSuccess().setData((Object)programResult);
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    public Result<ContractResult> previewCall(int chainId, byte[] senderBytes, byte[] contractAddressBytes, BigInteger value, Long gasLimit, Long price, String methodName, String methodDesc, String[][] args, List<ProgramMultyAssetValue> multyAssetValues) {
        try {
            if (!ContractUtil.checkPrice(price)) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_MINIMUM_PRICE_ERROR);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            long blockHeight = blockHeader.getHeight();
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramCall programCall = new ProgramCall();
            programCall.setContractAddress(contractAddressBytes);
            programCall.setSender(senderBytes);
            programCall.setNumber(blockHeight);
            programCall.setMethodName(methodName);
            programCall.setMethodDesc(methodDesc);
            programCall.setArgs(args);
            ProgramMethod method = this.contractHelper.getMethodInfoByContractAddress(chainId, prevStateRoot, methodName, methodDesc, contractAddressBytes);
            if (method == null) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_METHOD_NOT_EXIST);
            }
            if (method.isView()) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_NOT_EXECUTE_VIEW);
            }
            programCall.setValue(value);
            programCall.setMultyAssetValues(multyAssetValues);
            programCall.setPrice(price);
            ProgramExecutor programExecutor = this.contractHelper.getProgramExecutor(chainId);
            ProgramExecutor track = programExecutor.begin(prevStateRoot);
            programCall.setGasLimit(gasLimit);
            ProgramResult programResult = track.call(programCall);
            if (!programResult.isSuccess()) {
                Log.error("sender[{}], contractAddress[{}]" + programResult.getErrorMessage() + ", " + programResult.getStackTrace(), AddressTool.getStringAddressByBytes((byte[])senderBytes), AddressTool.getStringAddressByBytes((byte[])contractAddressBytes));
                Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
                result = ContractUtil.checkVmResultAndReturn(programResult.getErrorMessage(), result);
                ContractUtil.addDebugEvents(programResult.getDebugEvents(), result);
                return result;
            }
            ContractResult contractResult = new ContractResult();
            contractResult.setGasUsed(programResult.getGasUsed());
            contractResult.setPrice(price);
            contractResult.setContractAddress(contractAddressBytes);
            contractResult.setSender(senderBytes);
            contractResult.setValue(value.longValue());
            contractResult.setRemark("previewCall");
            contractResult.setDebugEvents(programResult.getDebugEvents());
            contractResult.setError(false);
            contractResult.setRevert(false);
            contractResult.setResult(programResult.getResult());
            contractResult.setEvents(programResult.getEvents());
            contractResult.setTransfers(programResult.getTransfers());
            contractResult.setInvokeRegisterCmds(programResult.getInvokeRegisterCmds());
            contractResult.setContractAddressInnerCallSet(this.generateInnerCallSet(programResult.getInternalCalls()));
            contractResult.setAccounts(programResult.getAccounts());
            return ContractUtil.getSuccess().setData((Object)contractResult);
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    public Set<String> generateInnerCallSet(List<ProgramInternalCall> internalCalls) {
        return internalCalls.stream().map(a -> AddressTool.getStringAddressByBytes((byte[])a.getContractAddress())).collect(Collectors.toSet());
    }

    public Result<DeleteContractTransaction> makeDeleteTx(int chainId, String sender, String contractAddress, String password, String remark) {
        byte[] contractAddressBytes;
        Result accountResult = AccountCall.validationPassword(chainId, sender, password);
        if (accountResult.isFailed()) {
            return accountResult;
        }
        byte[] senderBytes = AddressTool.getAddress((String)sender);
        Result validateDelete = this.validateDelete(chainId, senderBytes, contractAddress, contractAddressBytes = AddressTool.getAddress((String)contractAddress));
        if (validateDelete.isFailed()) {
            return validateDelete;
        }
        Result<DeleteContractTransaction> result = this.newDeleteTx(chainId, sender, senderBytes, contractAddressBytes, remark);
        return result;
    }

    public Result<DeleteContractTransaction> newDeleteTx(int chainId, String sender, byte[] senderBytes, byte[] contractAddressBytes, String remark) {
        try {
            DeleteContractTransaction tx = new DeleteContractTransaction();
            if (StringUtils.isNotBlank((String)remark)) {
                tx.setRemark(remark.getBytes(StandardCharsets.UTF_8));
            }
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            DeleteContractData deleteContractData = this.getDeleteContractData(contractAddressBytes, senderBytes);
            CoinData coinData = new CoinData();
            Result makeCoinDataResult = this.makeCoinData(chainId, sender, senderBytes, contractAddressBytes, 0L, 0L, BigInteger.ZERO, tx.size(), (NulsData)deleteContractData, coinData, null, null);
            if (makeCoinDataResult.isFailed()) {
                return makeCoinDataResult;
            }
            tx.setTxDataObj(deleteContractData);
            tx.setCoinDataObj(coinData);
            tx.serializeData();
            return ContractUtil.getSuccess().setData((Object)tx);
        }
        catch (IOException e) {
            Log.error(e);
            Result result = Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_OTHER_ERROR);
            result.setMsg(e.getMessage());
            return result;
        }
    }

    private DeleteContractData getDeleteContractData(byte[] contractAddressBytes, byte[] senderBytes) {
        DeleteContractData deleteContractData = new DeleteContractData();
        deleteContractData.setContractAddress(contractAddressBytes);
        deleteContractData.setSender(senderBytes);
        return deleteContractData;
    }

    public Result validateDelete(int chainId, byte[] senderBytes, String contractAddress, byte[] contractAddressBytes) {
        try {
            Result<ContractAddressInfoPo> contractAddressInfoPoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddressBytes);
            if (contractAddressInfoPoResult.isFailed()) {
                return contractAddressInfoPoResult;
            }
            ContractAddressInfoPo contractAddressInfoPo = (ContractAddressInfoPo)contractAddressInfoPoResult.getData();
            if (contractAddressInfoPo == null) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            byte[] stateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramStatus status = this.contractHelper.getContractStatus(chainId, stateRoot, contractAddressBytes);
            boolean isTerminatedContract = ContractUtil.isTerminatedContract(status.ordinal());
            if (isTerminatedContract) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_DELETED);
            }
            if (!ArraysTool.arrayEquals((byte[])senderBytes, (byte[])contractAddressInfoPo.getSender())) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_DELETE_CREATER);
            }
            ContractBalance balance = this.contractHelper.getRealBalance(chainId, ContractContext.LOCAL_CHAIN_ID, ContractContext.LOCAL_MAIN_ASSET_ID, contractAddress);
            BigInteger totalBalance = balance.getTotal();
            if (totalBalance.compareTo(BigInteger.ZERO) != 0) {
                return Result.getFailed((ErrorCode)ContractErrorCode.CONTRACT_DELETE_BALANCE);
            }
            return ContractUtil.getSuccess();
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    public Result signAndBroadcastTx(int chainId, String sender, String password, Transaction tx) {
        try {
            AccountCall.transactionSignature(chainId, sender, password, tx);
            String txData = RPCUtil.encode((byte[])tx.serialize());
            boolean broadcast = TransactionCall.newTx(chainId, txData);
            if (!broadcast) {
                return ContractUtil.getFailed();
            }
            return ContractUtil.getSuccess();
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
        catch (IOException e) {
            Log.error(e);
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
    }
}

