/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.manager;

import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.validator.CallContractTxValidator;
import io.nuls.contract.validator.CreateContractTxValidator;
import io.nuls.contract.validator.DeleteContractTxValidator;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;

@Component
public class ContractTxValidatorManager {
    @Autowired
    private CreateContractTxValidator createContractTxValidator;
    @Autowired
    private CallContractTxValidator callContractTxValidator;
    @Autowired
    private DeleteContractTxValidator deleteContractTxValidator;

    public Result createValidator(int chainId, CreateContractTransaction tx) throws NulsException {
        return this.createContractTxValidator.validate(chainId, tx);
    }

    public Result callValidator(int chainId, CallContractTransaction tx) throws NulsException {
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_22) {
            return this.callContractTxValidator.validateV22(chainId, tx);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_20) {
            return this.callContractTxValidator.validateV20(chainId, tx);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.PROTOCOL_14) {
            return this.callContractTxValidator.validateV14(chainId, tx);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_ACCOUNT_TRANSFER_ON_CONTRACT_CALL) {
            return this.callContractTxValidator.validateV13(chainId, tx);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)chainId) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
            return this.callContractTxValidator.validateV8(chainId, tx);
        }
        return this.callContractTxValidator.validate(chainId, tx);
    }

    public Result deleteValidator(int chainId, DeleteContractTransaction tx) throws NulsException {
        return this.deleteContractTxValidator.validate(chainId, tx);
    }
}

