/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.bo;

import io.nuls.base.data.BlockHeader;
import io.nuls.contract.enums.BatchInfoStatus;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.vm.program.ProgramExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchInfoV8 {
    private static final long TIME_OUT = 10000L;
    private ContractTempBalanceManager tempBalanceManager;
    private BlockHeader currentBlockHeader;
    private ProgramExecutor batchExecutor;
    private int txCounter = 0;
    private long height;
    private long beginTime;
    private long beforeEndTime;
    private long gasCostTotal;
    private int txTotal;
    private BatchInfoStatus status;
    private String preStateRoot;
    private Map<String, ContractResult> contractResultMap;
    private Set<String> deleteSet = new HashSet<String>();
    private Set<String> createSet = new HashSet<String>();
    private List<byte[]> offlineTxHashList;
    private int serialOrder;

    public BatchInfoV8(long height) {
        this.height = height;
        this.gasCostTotal = 0L;
        this.txTotal = 0;
        this.beginTime = System.currentTimeMillis();
        this.status = BatchInfoStatus.STARTING;
        this.contractResultMap = new HashMap<String, ContractResult>();
        this.offlineTxHashList = new ArrayList<byte[]>();
        this.serialOrder = 0;
    }

    public List<byte[]> getOfflineTxHashList() {
        return this.offlineTxHashList;
    }

    public void setOfflineTxHashList(List<byte[]> offlineTxHashList) {
        this.offlineTxHashList = offlineTxHashList;
    }

    public Map<String, ContractResult> getContractResultMap() {
        return this.contractResultMap;
    }

    public void setContractResultMap(Map<String, ContractResult> contractResultMap) {
        this.contractResultMap = contractResultMap;
    }

    public int getAndIncreaseTxCounter() {
        return this.txCounter++;
    }

    public static long getTimeOut() {
        return 10000L;
    }

    public Set<String> getDeleteSet() {
        return this.deleteSet;
    }

    public Set<String> getCreateSet() {
        return this.createSet;
    }

    public ContractTempBalanceManager getTempBalanceManager() {
        return this.tempBalanceManager;
    }

    public void setTempBalanceManager(ContractTempBalanceManager tempBalanceManager) {
        this.tempBalanceManager = tempBalanceManager;
    }

    public BlockHeader getCurrentBlockHeader() {
        return this.currentBlockHeader;
    }

    public void setCurrentBlockHeader(BlockHeader currentBlockHeader) {
        this.currentBlockHeader = currentBlockHeader;
    }

    public ProgramExecutor getBatchExecutor() {
        return this.batchExecutor;
    }

    public void setBatchExecutor(ProgramExecutor batchExecutor) {
        this.batchExecutor = batchExecutor;
    }

    public int getTxCounter() {
        return this.txCounter;
    }

    public void setTxCounter(int txCounter) {
        this.txCounter = txCounter;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getBeforeEndTime() {
        return this.beforeEndTime;
    }

    public void setBeforeEndTime(long beforeEndTime) {
        this.beforeEndTime = beforeEndTime;
    }

    public long getGasCostTotal() {
        return this.gasCostTotal;
    }

    public void setGasCostTotal(long gasCostTotal) {
        this.gasCostTotal = gasCostTotal;
    }

    public int getTxTotal() {
        return this.txTotal;
    }

    public void setTxTotal(int txTotal) {
        this.txTotal = txTotal;
    }

    public BatchInfoStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchInfoStatus status) {
        this.status = status;
    }

    public String getPreStateRoot() {
        return this.preStateRoot;
    }

    public void setPreStateRoot(String preStateRoot) {
        this.preStateRoot = preStateRoot;
    }

    public void setDeleteSet(Set<String> deleteSet) {
        this.deleteSet = deleteSet;
    }

    public void setCreateSet(Set<String> createSet) {
        this.createSet = createSet;
    }

    public int getSerialOrder() {
        return this.serialOrder;
    }

    public void setSerialOrder(int serialOrder) {
        this.serialOrder = serialOrder;
    }
}

