/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class CallContractDataDto {
    @ApiModelProperty(description="Transaction creator address")
    private String sender;
    @ApiModelProperty(description="Contract address")
    private String contractAddress;
    @ApiModelProperty(description="The amount of main network assets transferred by the caller to the contracted address, to be filled in when this service is not availableBigInteger.ZERO")
    private String value;
    @ApiModelProperty(description="GASlimit")
    private long gasLimit;
    @ApiModelProperty(description="GASunit price")
    private long price;
    @ApiModelProperty(description="Contract method")
    private String methodName;
    @ApiModelProperty(description="Contract method description, if the method in the contract is not overloaded, this parameter can be empty")
    private String methodDesc;
    @ApiModelProperty(description="parameter list")
    private String[][] args;

    public CallContractDataDto(ContractData call) {
        this.sender = AddressTool.getStringAddressByBytes((byte[])call.getSender());
        this.contractAddress = AddressTool.getStringAddressByBytes((byte[])call.getContractAddress());
        this.value = ContractUtil.bigInteger2String(call.getValue());
        this.gasLimit = call.getGasLimit();
        this.price = call.getPrice();
        this.methodName = call.getMethodName();
        this.methodDesc = call.getMethodDesc();
        this.args = call.getArgs();
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(long gasLimit) {
        this.gasLimit = gasLimit;
    }

    public long getPrice() {
        return this.price;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public void setMethodDesc(String methodDesc) {
        this.methodDesc = methodDesc;
    }

    public String[][] getArgs() {
        return this.args;
    }

    public void setArgs(String[][] args) {
        this.args = args;
    }
}

