/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.NulsHash;
import io.nuls.contract.model.bo.ContractMultyAssetMergedTransfer;
import io.nuls.contract.model.bo.MultyAssetOutput;
import io.nuls.contract.model.dto.MultyAssetOutputDto;
import io.nuls.contract.util.ContractUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.util.ArrayList;
import java.util.List;

@ApiModel
public class ContractMultyAssetMergedTransferDto {
    @ApiModelProperty(description="Contract generation transaction\uff1aContract transfer transactionhash")
    private String txHash;
    @ApiModelProperty(description="Transferred contract address")
    private String from;
    @ApiModelProperty(description="Transfer amount")
    private String value;
    @ApiModelProperty(description="Transfer amount asset chainID")
    private int assetChainId;
    @ApiModelProperty(description="Transfer amount assetsID")
    private int assetId;
    @ApiModelProperty(description="Transferred address list", type=@TypeDescriptor(value=List.class, collectionElement=MultyAssetOutputDto.class))
    private List<MultyAssetOutputDto> outputs;
    @ApiModelProperty(description="Call contract transactionshash\uff08Source transactionhashContract trading is derived from calling contract trading\uff09")
    private String orginTxHash;

    public ContractMultyAssetMergedTransferDto() {
    }

    public ContractMultyAssetMergedTransferDto(ContractMultyAssetMergedTransfer transfer) {
        this.from = AddressTool.getStringAddressByBytes((byte[])transfer.getFrom());
        this.value = ContractUtil.bigInteger2String(transfer.getValue());
        this.assetChainId = transfer.getAssetChainId();
        this.assetId = transfer.getAssetId();
        NulsHash thatHash = transfer.getHash();
        this.txHash = thatHash == null ? null : thatHash.toHex();
        NulsHash thatOrginTxHash = transfer.getOrginHash();
        this.orginTxHash = thatOrginTxHash == null ? null : thatOrginTxHash.toHex();
        this.makeOutputs(transfer.getOutputs());
    }

    private void makeOutputs(List<MultyAssetOutput> outputs) {
        if (outputs != null && !outputs.isEmpty()) {
            this.outputs = new ArrayList<MultyAssetOutputDto>(outputs.size());
            for (MultyAssetOutput output : outputs) {
                this.outputs.add(new MultyAssetOutputDto(output));
            }
        }
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getAssetChainId() {
        return this.assetChainId;
    }

    public void setAssetChainId(int assetChainId) {
        this.assetChainId = assetChainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public List<MultyAssetOutputDto> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<MultyAssetOutputDto> outputs) {
        this.outputs = outputs;
    }

    public String getOrginTxHash() {
        return this.orginTxHash;
    }

    public void setOrginTxHash(String orginTxHash) {
        this.orginTxHash = orginTxHash;
    }
}

