/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.rpc.resource;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.enums.ContractStatus;
import io.nuls.contract.enums.TokenTypeStatus;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractTokenInfo;
import io.nuls.contract.model.dto.AccountAmountDto;
import io.nuls.contract.model.dto.ContractAddressDto;
import io.nuls.contract.model.dto.ContractConstructorInfoDto;
import io.nuls.contract.model.dto.ContractInfoDto;
import io.nuls.contract.model.dto.ContractResultDto;
import io.nuls.contract.model.dto.ContractTokenInfoDto;
import io.nuls.contract.model.dto.ContractTransactionDto;
import io.nuls.contract.model.dto.InputDto;
import io.nuls.contract.model.dto.OutputDto;
import io.nuls.contract.model.po.ContractAddressInfoPo;
import io.nuls.contract.model.tx.ContractBaseTransaction;
import io.nuls.contract.rpc.call.BlockCall;
import io.nuls.contract.rpc.call.TransactionCall;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.service.ContractTxService;
import io.nuls.contract.storage.ContractAddressStorageService;
import io.nuls.contract.util.ContractLedgerUtil;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.util.MapUtil;
import io.nuls.contract.vm.program.ProgramCreateData;
import io.nuls.contract.vm.program.ProgramEncodePacked;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramMethod;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.contract.vm.program.ProgramResult;
import io.nuls.contract.vm.program.ProgramStatus;
import io.nuls.core.basic.Page;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.crypto.KeccakHash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@NulsCoresCmd(module=ModuleE.SC)
public class ContractResource
extends BaseCmd {
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ContractService contractService;
    @Autowired
    private ContractTxService contractTxService;
    @Autowired
    private ContractAddressStorageService contractAddressStorageService;

    @CmdAnnotation(cmd="sc_create", version=1.0, description="Publish contract/create contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="password", parameterDes="Account password"), @Parameter(parameterName="alias", parameterDes="Contract alias"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="GASlimit"), @Parameter(parameterName="price", requestType=@TypeDescriptor(value=long.class), parameterDes="GASunit price"), @Parameter(parameterName="contractCode", parameterDes="Smart Contract Code(BytecodeHexEncoding string)"), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true), @Parameter(parameterName="remark", parameterDes="Transaction notes", canNull=true)})
    @ResponseData(name="Return value", description="Return aMapObject, containing two properties", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="Transactions for publishing contractshash"), @Key(name="contractAddress", description="Generated contract address")}))
    public Response create(Map<String, Object> params) {
        try {
            Result result;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            String password = (String)params.get("password");
            String alias = (String)params.get("alias");
            Long gasLimit = Long.parseLong(params.get("gasLimit").toString());
            Long price = Long.parseLong(params.get("price").toString());
            String contractCode = (String)params.get("contractCode");
            List argsList = (List)params.get("args");
            Object[] args = argsList != null ? argsList.toArray() : null;
            String remark = (String)params.get("remark");
            if (gasLimit <= 0L || price <= 0L) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!FormatValidUtils.validAlias((String)alias)) {
                return this.failed(ContractErrorCode.CONTRACT_ALIAS_FORMAT_ERROR);
            }
            if (StringUtils.isBlank((String)contractCode)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            byte[] contractCodeBytes = HexUtil.decode((String)contractCode);
            ProgramMethod method = this.contractHelper.getMethodInfoByCode(chainId, "<init>", null, contractCodeBytes);
            String[][] convertArgs = null;
            if (method != null) {
                convertArgs = ContractUtil.twoDimensionalArray(args, method.argsType2Array());
            }
            if ((result = this.contractTxService.contractCreateTx(chainId, sender, alias, gasLimit, price, contractCodeBytes, convertArgs, password, remark)).isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success(result.getData());
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_imputed_create_gas", version=1.0, description="Estimated release contract consumptionGAS/imputed create gas")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="contractCode", parameterDes="Smart Contract Code(BytecodeHexEncoding string)"), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true)})
    @ResponseData(name="Return value", description="Return consumedgasvalue", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="gasLimit", valueType=Long.class, description="ConsumablegasValue, return value for execution failure1"), @Key(name="errorMsg", valueType=String.class, description="Error message for execution failure")}))
    public Response imputedCreateGas(Map<String, Object> params) {
        try {
            Object[] args;
            HashMap resultMap = MapUtil.createHashMap(1);
            resultMap.put("gasLimit", 1);
            String errorMsg = null;
            boolean isImputed = false;
            Result result = null;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            String contractCode = (String)params.get("contractCode");
            List argsList = (List)params.get("args");
            Object[] objectArray = args = argsList != null ? argsList.toArray() : null;
            if (AddressTool.validAddress((int)chainId, (String)sender) && !StringUtils.isBlank((String)contractCode)) {
                byte[] senderBytes = AddressTool.getAddress((String)sender);
                byte[] contractCodeBytes = HexUtil.decode((String)contractCode);
                ProgramMethod method = this.contractHelper.getMethodInfoByCode(chainId, "<init>", null, contractCodeBytes);
                String[][] convertArgs = null;
                if (method != null) {
                    convertArgs = ContractUtil.twoDimensionalArray(args, method.argsType2Array());
                }
                if ((result = this.contractTxService.validateContractCreateTx(chainId, senderBytes, 10000000L, 25L, contractCodeBytes, convertArgs)).isFailed()) {
                    errorMsg = result.getMsg();
                } else {
                    isImputed = true;
                }
            }
            if (isImputed) {
                ProgramResult programResult = (ProgramResult)result.getData();
                long gasUsed = programResult.getGasUsed();
                gasUsed = (gasUsed += gasUsed >> 1) > 10000000L ? 10000000L : gasUsed;
                resultMap.put("gasLimit", gasUsed);
            } else if (StringUtils.isNotBlank(errorMsg)) {
                Result failed = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                failed.setMsg(errorMsg);
                return ContractUtil.wrapperFailed(failed);
            }
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_validate_create", version=1.0, description="Verify release contract/validate create contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="GASlimit"), @Parameter(parameterName="price", requestType=@TypeDescriptor(value=long.class), parameterDes="GASunit price"), @Parameter(parameterName="contractCode", parameterDes="Smart Contract Code(BytecodeHexEncoding string)"), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true)})
    @ResponseData(description="No specific return value, validation successful without errors")
    public Response validateCreate(Map<String, Object> params) {
        try {
            Result result;
            Object[] args;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            Long gasLimit = Long.parseLong(params.get("gasLimit").toString());
            Long price = Long.parseLong(params.get("price").toString());
            String contractCode = (String)params.get("contractCode");
            List argsList = (List)params.get("args");
            Object[] objectArray = args = argsList != null ? argsList.toArray() : null;
            if (gasLimit < 0L || price < 0L) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)contractCode)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            byte[] contractCodeBytes = HexUtil.decode((String)contractCode);
            ProgramMethod method = this.contractHelper.getMethodInfoByCode(chainId, "<init>", null, contractCodeBytes);
            String[][] convertArgs = null;
            if (method != null) {
                convertArgs = ContractUtil.twoDimensionalArray(args, method.argsType2Array());
            }
            if ((result = this.contractTxService.validateContractCreateTx(chainId, AddressTool.getAddress((String)sender), gasLimit, price, contractCodeBytes, convertArgs)).isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success();
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_call", version=1.0, description="call contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="password", parameterDes="Caller account password"), @Parameter(parameterName="value", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="The caller transferred to the contract addressNULSAsset amount, filled in when this business is not availableBigInteger.ZERO"), @Parameter(parameterName="multyAssetValues", requestType=@TypeDescriptor(value=String[][].class), parameterDes="The amount of other assets transferred by the caller to the contract address, fill in the blank if there is no such business, rule: [[<value>,<assetChainId>,<assetId>]]"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="GASlimit"), @Parameter(parameterName="price", requestType=@TypeDescriptor(value=long.class), parameterDes="GASunit price"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="methodName", parameterDes="Contract method"), @Parameter(parameterName="methodDesc", parameterDes="Contract method description, if the method in the contract is not overloaded, this parameter can be empty", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true), @Parameter(parameterName="remark", parameterDes="Transaction notes", canNull=true), @Parameter(parameterName="nulsValueToOthers", requestType=@TypeDescriptor(value=String[][].class), parameterDes="The caller transferred to another account addressNULSAsset amount, fill in the blank without this business, rule: [[<value>,<address>]]")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="Transaction calling contracthash")}))
    public Response call(Map<String, Object> params) {
        try {
            Result result;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            String password = (String)params.get("password");
            Object valueObj = params.get("value");
            valueObj = valueObj == null ? "0" : valueObj;
            BigInteger value = new BigInteger(valueObj.toString());
            Long gasLimit = Long.parseLong(params.get("gasLimit").toString());
            Long price = Long.parseLong(params.get("price").toString());
            String contractAddress = (String)params.get("contractAddress");
            String methodName = (String)params.get("methodName");
            String methodDesc = (String)params.get("methodDesc");
            List argsList = (List)params.get("args");
            Object[] args = argsList != null ? argsList.toArray() : null;
            List multyAssetValuesList = (List)params.get("multyAssetValues");
            Object[] multyAssetValues = multyAssetValuesList != null ? multyAssetValuesList.toArray() : null;
            List nulsValueToOthersList = (List)params.get("nulsValueToOthers");
            Object[] nulsValueToOthers = nulsValueToOthersList != null ? nulsValueToOthersList.toArray() : null;
            String remark = (String)params.get("remark");
            if (value.compareTo(BigInteger.ZERO) < 0 || gasLimit < 0L || price < 0L) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)methodName)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramMethod method = this.contractHelper.getMethodInfoByContractAddress(chainId, prevStateRoot, methodName, methodDesc, contractAddressBytes);
            String[][] convertArgs = null;
            if (method != null) {
                convertArgs = ContractUtil.twoDimensionalArray(args, method.argsType2Array());
            }
            List multyAssetValueList = null;
            if (multyAssetValues != null) {
                Result<List<ProgramMultyAssetValue>> multyAssetValueListResult = this.convertMultyAssetValues(multyAssetValues);
                if (multyAssetValueListResult.isFailed()) {
                    return this.failed(multyAssetValueListResult.getErrorCode());
                }
                multyAssetValueList = (List)multyAssetValueListResult.getData();
            }
            List nulsValueToOtherList = null;
            if (nulsValueToOthers != null) {
                Result<List<AccountAmountDto>> nulsValueToOtherListResult = this.convertNulsValueToOthers(nulsValueToOthers);
                if (nulsValueToOtherListResult.isFailed()) {
                    return this.failed(nulsValueToOtherListResult.getErrorCode());
                }
                nulsValueToOtherList = (List)nulsValueToOtherListResult.getData();
            }
            if ((result = this.contractTxService.contractCallTx(chainId, sender, value, gasLimit, price, contractAddress, methodName, methodDesc, convertArgs, password, remark, multyAssetValueList, nulsValueToOtherList)).isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success(result.getData());
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    private Result<List<ProgramMultyAssetValue>> convertMultyAssetValues(Object[] multyAssetValues) {
        ArrayList<ProgramMultyAssetValue> results = null;
        String[][] convertMultyAssetValues = ContractUtil.twoDimensionalArray(multyAssetValues);
        if (convertMultyAssetValues != null && convertMultyAssetValues.length > 0) {
            results = new ArrayList<ProgramMultyAssetValue>();
            for (String[] args : convertMultyAssetValues) {
                if (args == null || args.length != 3) {
                    return Result.getFailed((ErrorCode)ContractErrorCode.PARAMETER_ERROR);
                }
                int assetChainId = Integer.parseInt(args[1]);
                int assetId = Integer.parseInt(args[2]);
                if (assetChainId <= 0 || assetId <= 0) {
                    return Result.getFailed((ErrorCode)ContractErrorCode.PARAMETER_ERROR);
                }
                results.add(new ProgramMultyAssetValue(new BigInteger(args[0]), assetChainId, assetId));
            }
        }
        return Result.getSuccess(results);
    }

    private Result<List<AccountAmountDto>> convertNulsValueToOthers(Object[] nulsValueToOthers) {
        ArrayList<AccountAmountDto> results = null;
        String[][] convertNulsValueToOthers = ContractUtil.twoDimensionalArray(nulsValueToOthers);
        if (convertNulsValueToOthers != null && convertNulsValueToOthers.length > 0) {
            results = new ArrayList<AccountAmountDto>();
            for (String[] args : convertNulsValueToOthers) {
                if (args == null || args.length != 2) {
                    return Result.getFailed((ErrorCode)ContractErrorCode.PARAMETER_ERROR);
                }
                results.add(new AccountAmountDto(new BigInteger(args[0].trim()), args[1].trim()));
            }
        }
        return Result.getSuccess(results);
    }

    @CmdAnnotation(cmd="sc_validate_call", version=1.0, description="validate call contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="value", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="The caller transferred to the contract addressNULSAsset amount, filled in when this business is not availableBigInteger.ZERO"), @Parameter(parameterName="multyAssetValues", requestType=@TypeDescriptor(value=String[][].class), parameterDes="The amount of other assets transferred by the caller to the contract address, fill in the blank if there is no such business, rule: [[<value>,<assetChainId>,<assetId>]]"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="GASlimit"), @Parameter(parameterName="price", requestType=@TypeDescriptor(value=long.class), parameterDes="GASunit price"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="methodName", parameterDes="Contract method"), @Parameter(parameterName="methodDesc", parameterDes="Contract method description, if the method in the contract is not overloaded, this parameter can be empty", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true)})
    @ResponseData(description="No specific return value, validation successful without errors")
    public Response validateCall(Map<String, Object> params) {
        try {
            Result result;
            Object[] args;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            Object valueObj = params.get("value");
            valueObj = valueObj == null ? "0" : valueObj;
            BigInteger value = new BigInteger(valueObj.toString());
            Long gasLimit = Long.parseLong(params.get("gasLimit").toString());
            Long price = Long.parseLong(params.get("price").toString());
            String contractAddress = (String)params.get("contractAddress");
            String methodName = (String)params.get("methodName");
            String methodDesc = (String)params.get("methodDesc");
            List argsList = (List)params.get("args");
            List multyAssetValuesList = (List)params.get("multyAssetValues");
            Object[] multyAssetValues = multyAssetValuesList != null ? multyAssetValuesList.toArray() : null;
            Object[] objectArray = args = argsList != null ? argsList.toArray() : null;
            if (value.compareTo(BigInteger.ZERO) < 0 || gasLimit < 0L || price < 0L) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)methodName)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            byte[] senderBytes = AddressTool.getAddress((String)sender);
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramMethod method = this.contractHelper.getMethodInfoByContractAddress(chainId, prevStateRoot, methodName, methodDesc, contractAddressBytes);
            String[][] convertArgs = null;
            if (method != null) {
                convertArgs = ContractUtil.twoDimensionalArray(args, method.argsType2Array());
            }
            List multyAssetValueList = null;
            if (multyAssetValues != null) {
                Result<List<ProgramMultyAssetValue>> multyAssetValueListResult = this.convertMultyAssetValues(multyAssetValues);
                if (multyAssetValueListResult.isFailed()) {
                    return this.failed(multyAssetValueListResult.getErrorCode());
                }
                multyAssetValueList = (List)multyAssetValueListResult.getData();
            }
            if ((result = this.contractTxService.validateContractCallTx(chainId, senderBytes, value, gasLimit, price, contractAddressBytes, methodName, methodDesc, convertArgs, multyAssetValueList)).isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success();
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_preview_call", version=1.0, description="preview call contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="value", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="The caller transferred to the contract addressNULSAsset amount, filled in when this business is not availableBigInteger.ZERO"), @Parameter(parameterName="multyAssetValues", requestType=@TypeDescriptor(value=String[][].class), parameterDes="The amount of other assets transferred by the caller to the contract address, fill in the blank if there is no such business, rule: [[<value>,<assetChainId>,<assetId>]]"), @Parameter(parameterName="gasLimit", requestType=@TypeDescriptor(value=long.class), parameterDes="GASlimit"), @Parameter(parameterName="price", requestType=@TypeDescriptor(value=long.class), parameterDes="GASunit price"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="methodName", parameterDes="Contract method"), @Parameter(parameterName="methodDesc", parameterDes="Contract method description, if the method in the contract is not overloaded, this parameter can be empty", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true)})
    @ResponseData(description="Return contract execution results", responseType=@TypeDescriptor(value=ContractResultDto.class))
    public Response previewCall(Map<String, Object> params) {
        try {
            Result<ContractResult> result;
            Object[] multyAssetValues;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            Object valueObj = params.get("value");
            valueObj = valueObj == null ? "0" : valueObj;
            BigInteger value = new BigInteger(valueObj.toString());
            Long gasLimit = Long.parseLong(params.get("gasLimit").toString());
            Long price = Long.parseLong(params.get("price").toString());
            String contractAddress = (String)params.get("contractAddress");
            String methodName = (String)params.get("methodName");
            String methodDesc = (String)params.get("methodDesc");
            List argsList = (List)params.get("args");
            Object[] args = argsList != null ? argsList.toArray() : null;
            List multyAssetValuesList = (List)params.get("multyAssetValues");
            Object[] objectArray = multyAssetValues = multyAssetValuesList != null ? multyAssetValuesList.toArray() : null;
            if (value.compareTo(BigInteger.ZERO) < 0 || gasLimit < 0L || price < 0L) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)methodName)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            byte[] senderBytes = AddressTool.getAddress((String)sender);
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramMethod method = this.contractHelper.getMethodInfoByContractAddress(chainId, prevStateRoot, methodName, methodDesc, contractAddressBytes);
            String[][] convertArgs = null;
            if (method != null) {
                convertArgs = ContractUtil.twoDimensionalArray(args, method.argsType2Array());
            }
            List multyAssetValueList = null;
            if (multyAssetValues != null) {
                Result<List<ProgramMultyAssetValue>> multyAssetValueListResult = this.convertMultyAssetValues(multyAssetValues);
                if (multyAssetValueListResult.isFailed()) {
                    return this.failed(multyAssetValueListResult.getErrorCode());
                }
                multyAssetValueList = (List)multyAssetValueListResult.getData();
            }
            if ((result = this.contractTxService.previewContractCallTx(chainId, senderBytes, value, gasLimit, price, contractAddressBytes, methodName, methodDesc, convertArgs, multyAssetValueList)).isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            ContractResult contractResult = (ContractResult)result.getData();
            ContractResultDto contractResultDto = new ContractResultDto((int)chainId, contractResult, gasLimit);
            return this.success(contractResultDto);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_imputed_call_gas", version=1.0, description="imputed call gas")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="value", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="The caller transferred to the contract addressNULSAsset amount, filled in when this business is not availableBigInteger.ZERO"), @Parameter(parameterName="multyAssetValues", requestType=@TypeDescriptor(value=String[][].class), parameterDes="The amount of other assets transferred by the caller to the contract address, fill in the blank if there is no such business, rule: [[<value>,<assetChainId>,<assetId>]]"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="methodName", parameterDes="Contract method"), @Parameter(parameterName="methodDesc", parameterDes="Contract method description, if the method in the contract is not overloaded, this parameter can be empty", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true)})
    @ResponseData(name="Return value", description="Return consumedgasvalue", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="gasLimit", valueType=Long.class, description="ConsumablegasValue, return value for execution failure1"), @Key(name="errorMsg", valueType=String.class, description="Error message for execution failure")}))
    public Response imputedCallGas(Map<String, Object> params) {
        try {
            Object[] multyAssetValues;
            HashMap resultMap = MapUtil.createHashMap(1);
            resultMap.put("gasLimit", 1);
            String errorMsg = null;
            boolean isImputed = false;
            Result result = null;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            Object valueObj = params.get("value");
            valueObj = valueObj == null ? "0" : valueObj;
            BigInteger value = new BigInteger(valueObj.toString());
            String contractAddress = (String)params.get("contractAddress");
            String methodName = (String)params.get("methodName");
            String methodDesc = (String)params.get("methodDesc");
            List argsList = (List)params.get("args");
            Object[] args = argsList != null ? argsList.toArray() : null;
            List multyAssetValuesList = (List)params.get("multyAssetValues");
            Object[] objectArray = multyAssetValues = multyAssetValuesList != null ? multyAssetValuesList.toArray() : null;
            if (value.compareTo(BigInteger.ZERO) >= 0 && AddressTool.validAddress((int)chainId, (String)sender) && AddressTool.validAddress((int)chainId, (String)contractAddress) && !StringUtils.isBlank((String)methodName)) {
                byte[] senderBytes = AddressTool.getAddress((String)sender);
                byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
                if (ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                    BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
                    byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
                    ProgramMethod method = this.contractHelper.getMethodInfoByContractAddress(chainId, prevStateRoot, methodName, methodDesc, contractAddressBytes);
                    String[][] convertArgs = null;
                    if (method != null) {
                        String[] argsType2Array = method.argsType2Array();
                        resultMap.put("argsType", argsType2Array);
                        convertArgs = ContractUtil.twoDimensionalArray(args, argsType2Array);
                    }
                    List multyAssetValueList = null;
                    if (multyAssetValues != null) {
                        Result<List<ProgramMultyAssetValue>> multyAssetValueListResult = this.convertMultyAssetValues(multyAssetValues);
                        if (multyAssetValueListResult.isFailed()) {
                            return this.failed(multyAssetValueListResult.getErrorCode());
                        }
                        multyAssetValueList = (List)multyAssetValueListResult.getData();
                    }
                    if ((result = this.contractTxService.validateContractCallTx(chainId, senderBytes, value, 10000000L, 25L, contractAddressBytes, methodName, methodDesc, convertArgs, multyAssetValueList)).isFailed()) {
                        errorMsg = result.getMsg();
                    } else {
                        isImputed = true;
                    }
                }
            }
            if (isImputed) {
                ProgramResult programResult = (ProgramResult)result.getData();
                long gasUsed = programResult.getGasUsed();
                gasUsed = (gasUsed += gasUsed >> 1) > 10000000L ? 10000000L : gasUsed;
                resultMap.put("gasLimit", gasUsed);
            } else if (StringUtils.isNotBlank(errorMsg)) {
                Result failed = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                failed.setMsg(errorMsg);
                return ContractUtil.wrapperFailed(failed);
            }
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_delete", version=1.0, description="delete contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="password", parameterDes="Transaction account password"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="remark", parameterDes="Transaction notes", canNull=true)})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="Delete transactions for contractshash")}))
    public Response delete(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            String contractAddress = (String)params.get("contractAddress");
            String password = (String)params.get("password");
            String remark = (String)params.get("remark");
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            Result result = this.contractTxService.contractDeleteTx(chainId, sender, contractAddress, password, remark);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success(result.getData());
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_validate_delete", version=1.0, description="validate delete contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="Transaction creator account address"), @Parameter(parameterName="contractAddress", parameterDes="Contract address")})
    @ResponseData(description="No specific return value, validation successful without errors")
    public Response validateDelete(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            String contractAddress = (String)params.get("contractAddress");
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            Result result = this.contractTxService.validateContractDeleteTx(chainId, sender, contractAddress);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success();
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_transfer", version=1.0, description="Transfer from account address to contract address(Main chain assets)/transfer NULS from sender to contract address")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterDes="Transferor's account address"), @Parameter(parameterName="toAddress", parameterDes="Transferred contract address"), @Parameter(parameterName="password", parameterDes="Transferor account password"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="The amount of main chain assets transferred out"), @Parameter(parameterName="remark", parameterDes="Transaction notes", canNull=true)})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="transactionhash")}))
    public Response transfer(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("address");
            String contractAddress = (String)params.get("toAddress");
            String password = (String)params.get("password");
            BigInteger value = new BigInteger(params.get("amount").toString());
            String remark = (String)params.get("remark");
            if (value.compareTo(BigInteger.ZERO) <= 0) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR, "amount error");
            }
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            Result<ContractAddressInfoPo> contractAddressInfoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddressBytes);
            ContractAddressInfoPo po = (ContractAddressInfoPo)contractAddressInfoResult.getData();
            if (po == null) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            if (!po.isAcceptDirectTransfer()) {
                return this.failed(ContractErrorCode.CONTRACT_NO_ACCEPT_DIRECT_TRANSFER);
            }
            HashMap<String, Object> gasParams = new HashMap<String, Object>();
            gasParams.put("chainId", chainId);
            gasParams.put("sender", sender);
            gasParams.put("value", value);
            gasParams.put("contractAddress", contractAddress);
            gasParams.put("methodName", "_payable");
            gasParams.put("methodDesc", "() return void");
            Response response = this.imputedCallGas(gasParams);
            if (!response.isSuccess()) {
                return response;
            }
            Map responseData = (Map)response.getResponseData();
            Long gasLimit = Long.valueOf(responseData.get("gasLimit").toString());
            Result result = this.contractTxService.contractCallTx(chainId, sender, value, gasLimit, 25L, contractAddress, "_payable", "() return void", null, password, remark, null, null);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success(result.getData());
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_token_transfer", version=1.0, description="NRC20-tokenTransfer/transfer NRC20-token from address to toAddress")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterDes="Transferor's account address"), @Parameter(parameterName="toAddress", parameterDes="Transfer address"), @Parameter(parameterName="contractAddress", parameterDes="tokenContract address"), @Parameter(parameterName="password", parameterDes="Transferor account password"), @Parameter(parameterName="amount", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="Transferred outtokenAsset amount"), @Parameter(parameterName="remark", parameterDes="Transaction notes", canNull=true)})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="transactionhash")}))
    public Response tokenTransfer(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String from = (String)params.get("address");
            String to = (String)params.get("toAddress");
            String contractAddress = (String)params.get("contractAddress");
            String password = (String)params.get("password");
            BigInteger value = new BigInteger(params.get("amount").toString());
            String remark = (String)params.get("remark");
            if (value.compareTo(BigInteger.ZERO) < 0) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)from)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)to)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            Result<ContractAddressInfoPo> contractAddressInfoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddressBytes);
            ContractAddressInfoPo po = (ContractAddressInfoPo)contractAddressInfoResult.getData();
            if (po == null) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            if (!po.isNrc20()) {
                return this.failed(ContractErrorCode.CONTRACT_NOT_NRC20);
            }
            Object[] argsObj = new Object[]{to, value.toString()};
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(argsObj[0]);
            list.add(argsObj[1]);
            HashMap<String, Object> gasParams = new HashMap<String, Object>();
            gasParams.put("chainId", chainId);
            gasParams.put("sender", from);
            gasParams.put("value", 0);
            gasParams.put("contractAddress", contractAddress);
            gasParams.put("methodName", "transfer");
            gasParams.put("args", list);
            Response response = this.imputedCallGas(gasParams);
            if (!response.isSuccess()) {
                return response;
            }
            Map responseData = (Map)response.getResponseData();
            Long gasLimit = Long.valueOf(responseData.get("gasLimit").toString());
            Result result = this.contractTxService.contractCallTx(chainId, from, BigInteger.ZERO, gasLimit, 25L, contractAddress, "transfer", null, ContractUtil.twoDimensionalArray(argsObj), password, remark, null, null);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            return this.success(result.getData());
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_token_balance", version=1.0, description="NRC20Token balance details/NRC20-token balance")
    @Parameters(description="parameter", value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="address", parameterDes="Account address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ContractTokenInfoDto.class))
    public Response tokenBalance(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String contractAddress = (String)params.get("contractAddress");
            String address = (String)params.get("address");
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            Result<ContractTokenInfo> result = this.contractHelper.getContractToken(chainId, blockHeader, address, contractAddress);
            if (result.isFailed()) {
                return ContractUtil.wrapperFailed(result);
            }
            ContractTokenInfo data = (ContractTokenInfo)result.getData();
            ContractTokenInfoDto dto = null;
            if (data != null) {
                dto = new ContractTokenInfoDto(data);
                dto.setStatus(data.getStatus().status());
            }
            return this.success(dto);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_invoke_view", version=1.0, description="invoke view contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="methodName", parameterDes="Contract method"), @Parameter(parameterName="methodDesc", parameterDes="Contract method description, if the method in the contract is not overloaded, this parameter can be empty", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true)})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="The call result of the view method")}))
    public Response invokeView(Map<String, Object> params) {
        try {
            params.put("height", 0);
            return this.invokeViewByHeight(params);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_invoke_view_by_height", version=1.0, description="invoke view contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="height", parameterDes="height"), @Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="methodName", parameterDes="Contract method"), @Parameter(parameterName="methodDesc", parameterDes="Contract method description, if the method in the contract is not overloaded, this parameter can be empty", canNull=true), @Parameter(parameterName="args", requestType=@TypeDescriptor(value=Object[].class), parameterDes="parameter list", canNull=true)})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="The call result of the view method")}))
    public Response invokeViewByHeight(Map<String, Object> params) {
        try {
            Object[] args;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            long height = 0L;
            Object objectHeight = params.get("height");
            if (objectHeight != null) {
                height = Long.parseLong(objectHeight.toString());
            }
            String contractAddress = (String)params.get("contractAddress");
            String methodName = (String)params.get("methodName");
            String methodDesc = (String)params.get("methodDesc");
            List argsList = (List)params.get("args");
            Object[] objectArray = args = argsList != null ? argsList.toArray() : null;
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            if (StringUtils.isBlank((String)methodName)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = height <= 0L ? BlockCall.getLatestBlockHeader(chainId) : BlockCall.getBlockHeader((int)chainId, height);
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramMethod method = this.contractHelper.getMethodInfoByContractAddress(chainId, prevStateRoot, methodName, methodDesc, contractAddressBytes);
            if (method == null) {
                return this.failed(ContractErrorCode.CONTRACT_METHOD_NOT_EXIST);
            }
            if (!method.isView()) {
                return this.failed(ContractErrorCode.CONTRACT_NON_VIEW_METHOD);
            }
            ProgramResult programResult = this.contractHelper.invokeCustomGasViewMethod(chainId, blockHeader, contractAddressBytes, methodName, methodDesc, ContractUtil.twoDimensionalArray(args, method.argsType2Array()));
            if (Log.isDebugEnabled()) {
                Log.debug("view method cost gas: " + programResult.getGasUsed());
            }
            if (!programResult.isSuccess()) {
                Log.error("error msg: {}, statck trace: {}", programResult.getErrorMessage(), programResult.getStackTrace());
                Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_ERROR);
                result.setMsg(ContractUtil.simplifyErrorMsg(programResult.getErrorMessage()));
                Result newResult = ContractUtil.checkVmResultAndReturn(programResult.getErrorMessage(), result);
                if (newResult == result) {
                    return ContractUtil.wrapperFailed(result);
                }
                return ContractUtil.wrapperFailed(newResult);
            }
            LinkedHashMap resultMap = MapUtil.createLinkedHashMap(2);
            resultMap.put("result", programResult.getResult());
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_code_hash", version=1.0, description="get code hash of contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="contractAddress", parameterDes="Contract address")})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="code hash(Keccak256)")}))
    public Response codeHash(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String contractAddress = (String)params.get("contractAddress");
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            byte[] codeHash = this.contractHelper.getContractCodeHash(chainId, prevStateRoot, contractAddressBytes);
            if (codeHash == null) {
                Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_NOT_FOUND);
                return ContractUtil.wrapperFailed(result);
            }
            LinkedHashMap resultMap = MapUtil.createLinkedHashMap(2);
            resultMap.put("result", HexUtil.encode((byte[])codeHash));
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_code", version=1.0, description="get code of contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="contractAddress", parameterDes="Contract address")})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="code")}))
    public Response contractCode(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String contractAddress = (String)params.get("contractAddress");
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            byte[] code = this.contractHelper.getContractCode(chainId, prevStateRoot, contractAddressBytes);
            if (code == null) {
                Result result = Result.getFailed((ErrorCode)ContractErrorCode.DATA_NOT_FOUND);
                return ContractUtil.wrapperFailed(result);
            }
            LinkedHashMap resultMap = MapUtil.createLinkedHashMap(2);
            resultMap.put("result", HexUtil.encode((byte[])code));
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_compute_address", version=1.0, description="compute contract")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="sender", parameterDes="sender"), @Parameter(parameterName="codeHash", parameterDes="codeHash"), @Parameter(parameterName="salt", parameterDes="salt")})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="contractAddress", description="Contract address")}))
    public Response computeAddress(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String sender = (String)params.get("sender");
            String codeHash = (String)params.get("codeHash");
            List saltList = (List)params.get("salt");
            if (saltList == null || saltList.isEmpty()) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            int size = saltList.size();
            String[] salts = new String[size];
            for (int i = 0; i < size; ++i) {
                salts[i] = saltList.get(i).toString();
            }
            ProgramEncodePacked encodePacked = new ProgramEncodePacked((short)size, salts);
            if (!AddressTool.validAddress((int)chainId, (String)sender)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            ProgramCreateData createData = new ProgramCreateData(AddressTool.getAddress((String)sender), encodePacked.serialize(), HexUtil.decode((String)codeHash));
            Address newAddress = new Address(chainId.intValue(), BaseConstant.CONTRACT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])KeccakHash.keccakBytes((byte[])createData.serialize(), (int)256)));
            LinkedHashMap resultMap = MapUtil.createLinkedHashMap(2);
            resultMap.put("contractAddress", newAddress.toString());
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_constructor", version=1.0, description="contract code constructor")
    @Parameters(description="parameter", value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="contractCode", parameterDes="Smart Contract Code(BytecodeHexEncoding string)")})
    @ResponseData(name="Return value", description="Contract constructor details", responseType=@TypeDescriptor(value=ContractConstructorInfoDto.class))
    public Response constructor(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String contractCode = (String)params.get("contractCode");
            if (StringUtils.isBlank((String)contractCode)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            byte[] contractCodeBytes = HexUtil.decode((String)contractCode);
            ContractConstructorInfoDto contractInfoDto = this.contractHelper.getConstructor(chainId, contractCodeBytes);
            if (contractInfoDto == null || contractInfoDto.getConstructor() == null) {
                return this.failed(ContractErrorCode.ILLEGAL_CONTRACT);
            }
            return this.success(contractInfoDto);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_info", version=1.0, description="Contract information details/contract info")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="contractAddress", parameterDes="Contract address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ContractInfoDto.class))
    public Response contractInfo(Map<String, Object> params) {
        try {
            boolean isNrc1155;
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String contractAddress = (String)params.get("contractAddress");
            if (!AddressTool.validAddress((int)chainId, (String)contractAddress)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            byte[] contractAddressBytes = AddressTool.getAddress((String)contractAddress);
            if (!ContractLedgerUtil.isExistContractAddress(chainId, contractAddressBytes)) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            Result<ContractAddressInfoPo> contractAddressInfoResult = this.contractHelper.getContractAddressInfo(chainId, contractAddressBytes);
            if (contractAddressInfoResult.isFailed()) {
                return ContractUtil.wrapperFailed(contractAddressInfoResult);
            }
            ContractAddressInfoPo po = (ContractAddressInfoPo)contractAddressInfoResult.getData();
            if (po == null) {
                return this.failed(ContractErrorCode.CONTRACT_ADDRESS_NOT_EXIST);
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramExecutor track = this.contractHelper.getProgramExecutor(chainId).begin(prevStateRoot);
            byte[] codeHash = track.contractCodeHash(contractAddressBytes);
            ProgramStatus status = track.status(contractAddressBytes);
            List<ProgramMethod> methods = track.method(contractAddressBytes);
            boolean isAcceptDirectTransferByOtherAsset = false;
            if (methods != null && !methods.isEmpty()) {
                int removeIndex = -1;
                boolean isQueriedPayableOtherAsset = false;
                int size = methods.size();
                for (int i = 0; !(i >= size || removeIndex > -1 && isQueriedPayableOtherAsset); ++i) {
                    ProgramMethod m = methods.get(i);
                    if ("_payable".equals(m.getName()) && "(String[][] args) return void".equals(m.getDesc())) {
                        removeIndex = i;
                        continue;
                    }
                    if (!"_payableMultyAsset".equals(m.getName()) || !"() return void".equals(m.getDesc())) continue;
                    isAcceptDirectTransferByOtherAsset = m.isPayableMultyAsset();
                    isQueriedPayableOtherAsset = true;
                }
                if (removeIndex > -1) {
                    methods.remove(removeIndex);
                }
            }
            ContractInfoDto dto = new ContractInfoDto();
            try {
                byte[] createTxHash = po.getCreateTxHash();
                NulsHash create = new NulsHash(createTxHash);
                dto.setCreateTxHash(create.toHex());
            }
            catch (Exception e) {
                Log.error("createTxHash parse error.", e);
            }
            dto.setAddress(contractAddress);
            dto.setCreater(AddressTool.getStringAddressByBytes((byte[])po.getSender()));
            dto.setAlias(po.getAlias());
            dto.setCreateTime(po.getCreateTime());
            dto.setBlockHeight(po.getBlockHeight());
            dto.setTokenType(po.getTokenType());
            dto.setNrc20(po.isNrc20());
            boolean isNrc721 = TokenTypeStatus.NRC721.status() == po.getTokenType();
            boolean bl = isNrc1155 = TokenTypeStatus.NRC1155.status() == po.getTokenType();
            if (po.isNrc20() || isNrc721 || isNrc1155) {
                dto.setNrc20TokenName(po.getNrc20TokenName());
                dto.setNrc20TokenSymbol(po.getNrc20TokenSymbol());
                if (po.isNrc20()) {
                    dto.setDecimals(po.getDecimals());
                    dto.setTotalSupply(ContractUtil.bigInteger2String(po.getTotalSupply()));
                } else if (isNrc1155) {
                    ProgramResult uriResult = this.contractHelper.invokeViewMethod((int)chainId, contractAddressBytes, "uri", "() return String", (String[][])null);
                    String uri = uriResult.getResult();
                    dto.setTokenUri(uri);
                }
            }
            dto.setStatus(status.name());
            dto.setMethod(methods);
            dto.setDirectPayable(po.isAcceptDirectTransfer());
            dto.setDirectPayableByOtherAsset(isAcceptDirectTransferByOtherAsset);
            if (codeHash != null) {
                dto.setCodeHash(HexUtil.encode((byte[])codeHash));
            }
            return this.success(dto);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_result_list", version=1.0, description="contract result list")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="hashList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="transactionhashlist")})
    @ResponseData(name="Return value", description="Return the list of contract execution results for the transaction", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash1 or hash2 or hash3...", valueType=ContractResultDto.class, description="TradinghashIn the listhashValue askeyHerekey nameIt is dynamic")}))
    public Response contractResultList(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            List hashList = (List)params.get("hashList");
            if (hashList == null || hashList.isEmpty()) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            LinkedHashMap resultMap = MapUtil.createLinkedHashMap(hashList.size());
            for (String hash : hashList) {
                ContractResultDto contractResultDto;
                ContractBaseTransaction tx1;
                NulsHash txHash = NulsHash.fromHex((String)hash);
                Transaction tx = TransactionCall.getConfirmedTx(chainId, hash);
                if (tx == null || !ContractUtil.isContractTransaction(tx) || (tx1 = ContractUtil.convertContractTx(chainId, tx)) == null || (contractResultDto = this.makeContractResultDto(chainId, tx1, txHash)) == null) continue;
                resultMap.put(hash, contractResultDto);
            }
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_result", version=1.0, description="contract result")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="hash", parameterDes="transactionhash")})
    @ResponseData(description="Return contract execution results", responseType=@TypeDescriptor(value=ContractResultDto.class))
    public Response contractResult(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String hash = (String)params.get("hash");
            if (StringUtils.isBlank((String)hash)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            if (!NulsHash.validHash((String)hash)) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            ContractResultDto contractResultDto = null;
            boolean flag = true;
            String msg = "";
            NulsHash txHash = NulsHash.fromHex((String)hash);
            Transaction tx = TransactionCall.getConfirmedTx(chainId, hash);
            if (tx == null) {
                flag = false;
                msg = ContractErrorCode.TX_NOT_EXIST.getMsg();
            } else if (!ContractUtil.isContractTransaction(tx)) {
                flag = false;
                msg = ContractErrorCode.NON_CONTRACTUAL_TRANSACTION.getMsg();
            } else {
                ContractBaseTransaction tx1 = ContractUtil.convertContractTx(chainId, tx);
                contractResultDto = this.makeContractResultDto(chainId, tx1, txHash);
                if (contractResultDto == null) {
                    flag = false;
                    msg = ContractErrorCode.DATA_NOT_FOUND.getMsg();
                }
            }
            LinkedHashMap resultMap = MapUtil.createLinkedHashMap(2);
            resultMap.put("flag", flag);
            if (!flag && StringUtils.isNotBlank((String)msg)) {
                resultMap.put("msg", msg);
            }
            if (flag && contractResultDto != null) {
                resultMap.put("data", contractResultDto);
            }
            if (!flag) {
                return this.failed(msg);
            }
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    private ContractResultDto makeContractResultDto(int chainId, ContractBaseTransaction tx1, NulsHash txHash) throws NulsException, IOException {
        ContractResultDto contractResultDto = null;
        if (tx1.getType() == 18 || tx1.getType() == 19) {
            return null;
        }
        ContractResult contractExecuteResult = this.contractService.getContractExecuteResult(chainId, txHash);
        if (contractExecuteResult != null) {
            contractResultDto = new ContractResultDto(chainId, contractExecuteResult, tx1);
            tx1.setBlockHeight(contractExecuteResult.getBlockHeight());
        }
        return contractResultDto;
    }

    @CmdAnnotation(cmd="sc_contract_tx", version=1.0, description="Contract trading/contract tx")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="hash", parameterDes="transactionhash")})
    @ResponseData(description="Return contract transaction, Including contract execution results", responseType=@TypeDescriptor(value=ContractTransactionDto.class))
    public Response contractTx(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String hash = (String)params.get("hash");
            if (StringUtils.isBlank((String)hash)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            if (!NulsHash.validHash((String)hash)) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            NulsHash txHash = NulsHash.fromHex((String)hash);
            Transaction tx = TransactionCall.getConfirmedTx(chainId, hash);
            if (tx == null) {
                return this.failed(ContractErrorCode.TX_NOT_EXIST);
            }
            if (!ContractUtil.isContractTransaction(tx)) {
                return this.failed(ContractErrorCode.NON_CONTRACTUAL_TRANSACTION);
            }
            ContractBaseTransaction tx1 = ContractUtil.convertContractTx(chainId, tx);
            tx1.setStatus(TxStatusEnum.CONFIRMED);
            ContractResultDto contractResultDto = this.makeContractResultDto(chainId, tx1, txHash);
            ContractTransactionDto txDto = new ContractTransactionDto(chainId, tx1);
            this.calTransactionValue(txDto);
            if (contractResultDto != null) {
                txDto.setContractResult(contractResultDto);
            }
            return this.success(txDto);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    private void calTransactionValue(ContractTransactionDto txDto) {
        if (txDto == null) {
            return;
        }
        List<InputDto> inputDtoList = txDto.getInputs();
        HashSet<String> inputAdressSet = new HashSet<String>(inputDtoList.size());
        for (InputDto inputDto : inputDtoList) {
            inputAdressSet.add(inputDto.getAddress());
        }
        BigInteger value = BigInteger.ZERO;
        List<OutputDto> outputDtoList = txDto.getOutputs();
        for (OutputDto outputDto : outputDtoList) {
            if (inputAdressSet.contains(outputDto.getAddress())) continue;
            value = value.add(new BigInteger(outputDto.getAmount()));
        }
        txDto.setValue(ContractUtil.bigInteger2String(value));
    }

    @CmdAnnotation(cmd="sc_account_contracts", version=1.0, description="List of contract addresses for the account/account contract list")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", parameterDes="Account address"), @Parameter(parameterName="pageNumber", requestType=@TypeDescriptor(value=int.class), parameterDes="Page number", canNull=true), @Parameter(parameterName="pageSize", requestType=@TypeDescriptor(value=int.class), parameterDes="Page size", canNull=true)})
    @ResponseData(name="Return value", description="Return aPageObject, only described herePageCollection in objects", responseType=@TypeDescriptor(value=List.class, collectionElement=ContractAddressDto.class))
    public Response accountContracts(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String address = (String)params.get("address");
            Integer pageNumber = (Integer)params.get("pageNumber");
            Integer pageSize = (Integer)params.get("pageSize");
            if (null == pageNumber || pageNumber == 0) {
                pageNumber = 1;
            }
            if (null == pageSize || pageSize == 0) {
                pageSize = 10;
            }
            if (pageNumber < 0 || pageSize < 0 || pageSize > 100) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)address)) {
                return this.failed(ContractErrorCode.ADDRESS_ERROR);
            }
            byte[] addressBytes = AddressTool.getAddress((String)address);
            LinkedHashMap<String, ContractAddressDto> resultMap = new LinkedHashMap<String, ContractAddressDto>();
            LinkedList<Map<String, String>> list = this.contractHelper.getChain(chainId).getContractTxCreateUnconfirmedManager().getLocalUnconfirmedCreateContractTransaction(address);
            if (list != null) {
                for (Map map : list) {
                    String contractAddress = (String)map.get("contractAddress");
                    Long time = Long.valueOf((String)map.get("time"));
                    ContractAddressDto dto = new ContractAddressDto();
                    dto.setContractAddress(contractAddress);
                    dto.setCreateTime(time);
                    String success = (String)map.get("success");
                    if (StringUtils.isNotBlank((String)success)) {
                        dto.setStatus(ContractStatus.CREATION_FAILED.status());
                        dto.setMsg((String)map.get("msg"));
                    } else {
                        dto.setStatus(ContractStatus.NOT_EXISTS_OR_CONFIRMING.status());
                    }
                    resultMap.put(contractAddress, dto);
                }
            }
            BlockHeader blockHeader = BlockCall.getLatestBlockHeader(chainId);
            long height = blockHeader.getHeight();
            byte[] prevStateRoot = ContractUtil.getStateRoot(blockHeader);
            ProgramExecutor track = this.contractHelper.getChain(chainId).getProgramExecutor().begin(prevStateRoot);
            Result<List<ContractAddressInfoPo>> contractInfoListResult = this.contractAddressStorageService.getContractInfoList(chainId, addressBytes);
            List contractAddressInfoPoList = (List)contractInfoListResult.getData();
            if (contractAddressInfoPoList != null && contractAddressInfoPoList.size() > 0) {
                contractAddressInfoPoList.sort(new Comparator<ContractAddressInfoPo>(){

                    @Override
                    public int compare(ContractAddressInfoPo o1, ContractAddressInfoPo o2) {
                        return o1.compareTo(o2.getCreateTime());
                    }
                });
                for (ContractAddressInfoPo po : contractAddressInfoPoList) {
                    byte[] byArray = po.getContractAddress();
                    String contractAddress = AddressTool.getStringAddressByBytes((byte[])byArray);
                    resultMap.put(contractAddress, new ContractAddressDto(po, height, track.status(byArray).ordinal()));
                }
            }
            ArrayList infoList = new ArrayList(resultMap.values());
            ArrayList<ContractAddressDto> contractAddressDtoList = new ArrayList<ContractAddressDto>();
            Page page = new Page(pageNumber.intValue(), pageSize.intValue(), infoList.size());
            int start = pageNumber * pageSize - pageSize;
            if ((long)start >= page.getTotal()) {
                return this.success(page);
            }
            int end = start + pageSize;
            if ((long)end > page.getTotal()) {
                end = (int)page.getTotal();
            }
            if (infoList.size() > 0) {
                for (int i = start; i < end; ++i) {
                    contractAddressDtoList.add((ContractAddressDto)infoList.get(i));
                }
            }
            page.setList(contractAddressDtoList);
            return this.success(page);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_upload", version=1.0, description="Contract codejarPackage upload/upload")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="jarFileData", parameterDes="File description and file byte stream conversionBase64Encoding string\uff08File description andBase64String separated by commas\uff09")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="constructor", valueType=ProgramMethod.class, description="Contract constructor details"), @Key(name="isNrc20", valueType=Boolean.class, description="Is itNRC20contract"), @Key(name="code", description="Smart Contract Code(BytecodeHexEncoding string)")}))
    public Response upload(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String jarFileData = (String)params.get("jarFileData");
            if (StringUtils.isBlank((String)jarFileData)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            String[] arr = jarFileData.split(",");
            if (arr.length != 2) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            String body = arr[1];
            byte[] contractCode = Base64.getDecoder().decode(body);
            ContractConstructorInfoDto contractInfoDto = this.contractHelper.getConstructor(chainId, contractCode);
            if (contractInfoDto == null || contractInfoDto.getConstructor() == null) {
                return this.failed(ContractErrorCode.ILLEGAL_CONTRACT);
            }
            LinkedHashMap resultMap = MapUtil.createLinkedHashMap(3);
            resultMap.put("constructor", contractInfoDto.getConstructor());
            resultMap.put("isNrc20", contractInfoDto.isNrc20());
            resultMap.put("code", HexUtil.encode((byte[])contractCode));
            return this.success(resultMap);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_reward_log_by_consensus", version=1.0, description="CONTRACT_REWARD_LOG_BY_CONSENSUS")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterDes="address")})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class))
    public Response getAssetsMapAboutContractRewardLogByConsensus(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String address = (String)params.get("address");
            Map<String, String> res = this.contractHelper.getAssetsMapAboutContractRewardLogByConsensus(chainId, AddressTool.getAddress((String)address));
            return this.success(res);
        }
        catch (Exception e) {
            Log.error(e);
            return this.failed(e.getMessage());
        }
    }

    @CmdAnnotation(cmd="sc_contract_tx_events", version=1.0, description="contract tx events")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="hash", parameterDes="transactionhash")})
    @ResponseData(description="Return contract transaction events", responseType=@TypeDescriptor(value=List.class))
    public Response contractTxEvents(Map<String, Object> params) {
        try {
            Integer chainId = (Integer)params.get("chainId");
            ChainManager.chainHandle(chainId);
            String hash = (String)params.get("hash");
            if (StringUtils.isBlank((String)hash)) {
                return this.failed(ContractErrorCode.NULL_PARAMETER);
            }
            if (!NulsHash.validHash((String)hash)) {
                return this.failed(ContractErrorCode.PARAMETER_ERROR);
            }
            NulsHash txHash = NulsHash.fromHex((String)hash);
            Transaction tx = TransactionCall.getConfirmedTx(chainId, hash);
            if (tx == null) {
                return this.failed(ContractErrorCode.TX_NOT_EXIST);
            }
            if (!ContractUtil.isGasCostContractTransaction(tx)) {
                return this.failed(ContractErrorCode.NON_CONTRACTUAL_TRANSACTION);
            }
            ContractResult contractExecuteResult = this.contractService.getContractExecuteResult(chainId, txHash);
            if (contractExecuteResult == null) {
                return this.success();
            }
            List<String> events = contractExecuteResult.getEvents();
            if (events == null || events.isEmpty()) {
                return this.success();
            }
            List results = events.stream().map(e -> {
                try {
                    return JSONUtils.json2map((String)e);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }).collect(Collectors.toList());
            return this.success(results);
        }
        catch (Exception e2) {
            Log.error(e2);
            return this.failed(e2.getMessage());
        }
    }
}

