/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.contract.callable.ContractTxCallableV14;
import io.nuls.contract.callable.ContractTxCallableV22;
import io.nuls.contract.callable.ContractTxCallableV8;
import io.nuls.contract.constant.ContractErrorCode;
import io.nuls.contract.enums.CmdRegisterMode;
import io.nuls.contract.helper.ContractConflictChecker;
import io.nuls.contract.helper.ContractHelper;
import io.nuls.contract.manager.ChainManager;
import io.nuls.contract.manager.ContractTempBalanceManager;
import io.nuls.contract.manager.ContractTxProcessorManager;
import io.nuls.contract.manager.ContractTxValidatorManager;
import io.nuls.contract.model.bo.BatchInfo;
import io.nuls.contract.model.bo.BatchInfoV8;
import io.nuls.contract.model.bo.Chain;
import io.nuls.contract.model.bo.ContractContainer;
import io.nuls.contract.model.bo.ContractResult;
import io.nuls.contract.model.bo.ContractTempTransaction;
import io.nuls.contract.model.bo.ContractWrapperTransaction;
import io.nuls.contract.model.dto.ContractPackageDto;
import io.nuls.contract.model.po.ContractOfflineTxHashPo;
import io.nuls.contract.model.tx.CallContractTransaction;
import io.nuls.contract.model.tx.ContractReturnGasTransaction;
import io.nuls.contract.model.tx.ContractTransferTransaction;
import io.nuls.contract.model.tx.CreateContractTransaction;
import io.nuls.contract.model.tx.DeleteContractTransaction;
import io.nuls.contract.model.txdata.ContractData;
import io.nuls.contract.service.ContractCaller;
import io.nuls.contract.service.ContractExecutor;
import io.nuls.contract.service.ContractService;
import io.nuls.contract.service.ResultAnalyzer;
import io.nuls.contract.service.ResultHanlder;
import io.nuls.contract.storage.ContractExecuteResultStorageService;
import io.nuls.contract.storage.ContractOfflineTxHashListStorageService;
import io.nuls.contract.util.ContractUtil;
import io.nuls.contract.util.Log;
import io.nuls.contract.vm.program.ProgramExecutor;
import io.nuls.contract.vm.program.ProgramInvokeRegisterCmd;
import io.nuls.contract.vm.program.ProgramNewTx;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@Component
public class ContractServiceImpl
implements ContractService {
    @Autowired
    private ContractCaller contractCaller;
    @Autowired
    private ResultAnalyzer resultAnalyzer;
    @Autowired
    private ResultHanlder resultHanlder;
    @Autowired
    private ContractExecutor contractExecutor;
    @Autowired
    private ContractHelper contractHelper;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private ContractExecuteResultStorageService contractExecuteResultStorageService;
    @Autowired
    private ContractOfflineTxHashListStorageService contractOfflineTxHashListStorageService;
    @Autowired
    private ContractTxProcessorManager contractTxProcessorManager;
    @Autowired
    private ContractTxValidatorManager contractTxValidatorManager;

    @Override
    public Result begin(int chainId, long blockHeight, long blockTime, String packingAddress, String preStateRoot) {
        Log.info("[Begin contract batch] packaging blockHeight is [{}], packaging address is [{}], preStateRoot is [{}]", blockHeight, packingAddress, preStateRoot);
        Chain chain = this.contractHelper.getChain(chainId);
        BatchInfo batchInfo = new BatchInfo(blockHeight);
        chain.setBatchInfo(null);
        chain.setBatchInfo(batchInfo);
        this.contractHelper.createTempBalanceManagerAndCurrentBlockHeader(chainId, blockHeight, blockTime, AddressTool.getAddress((String)packingAddress));
        ProgramExecutor batchExecutor = this.contractExecutor.createBatchExecute(chainId, RPCUtil.decode((String)preStateRoot));
        batchInfo.setBatchExecutor(batchExecutor);
        batchInfo.setPreStateRoot(preStateRoot);
        ContractConflictChecker checker = ContractConflictChecker.newInstance();
        checker.setContractSetList(new CopyOnWriteArrayList<Set<String>>());
        batchInfo.setChecker(checker);
        return ContractUtil.getSuccess();
    }

    @Override
    public Result beginV8(int chainId, long blockHeight, long blockTime, String packingAddress, String preStateRoot) {
        Log.info("[Begin contract batch] packaging blockHeight is [{}], packaging address is [{}], preStateRoot is [{}]", blockHeight, packingAddress, preStateRoot);
        Chain chain = this.contractHelper.getChain(chainId);
        BatchInfoV8 batchInfo = new BatchInfoV8(blockHeight);
        chain.setBatchInfoV8(batchInfo);
        ContractTempBalanceManager tempBalanceManager = ContractTempBalanceManager.newInstance(chainId);
        BlockHeader tempHeader = new BlockHeader();
        tempHeader.setHeight(blockHeight);
        tempHeader.setTime(blockTime);
        tempHeader.setPackingAddress(AddressTool.getAddress((String)packingAddress));
        batchInfo.setTempBalanceManager(tempBalanceManager);
        batchInfo.setCurrentBlockHeader(tempHeader);
        ProgramExecutor batchExecutor = this.contractExecutor.createBatchExecute(chainId, RPCUtil.decode((String)preStateRoot));
        batchInfo.setBatchExecutor(batchExecutor);
        batchInfo.setPreStateRoot(preStateRoot);
        HashMap result = new HashMap();
        return ContractUtil.getSuccess().setData(result);
    }

    private Result validContractTx(int chainId, Transaction tx) {
        try {
            Result result;
            switch (tx.getType()) {
                case 15: {
                    CreateContractTransaction create = new CreateContractTransaction();
                    create.copyTx(tx);
                    result = this.contractTxValidatorManager.createValidator(chainId, create);
                    break;
                }
                case 16: {
                    CallContractTransaction call = new CallContractTransaction();
                    call.copyTx(tx);
                    result = this.contractTxValidatorManager.callValidator(chainId, call);
                    break;
                }
                case 17: {
                    DeleteContractTransaction delete = new DeleteContractTransaction();
                    delete.copyTx(tx);
                    result = this.contractTxValidatorManager.deleteValidator(chainId, delete);
                    break;
                }
                default: {
                    result = ContractUtil.getSuccess();
                }
            }
            return result;
        }
        catch (NulsException e) {
            return ContractUtil.getFailed();
        }
    }

    @Override
    public Result invokeContractOneByOne(int chainId, ContractTempTransaction tx) {
        try {
            Log.info("[Invoke Contract] TxType is [{}], hash is [{}]", tx.getType(), tx.getHash().toString());
            tx.setChainId(chainId);
            ContractWrapperTransaction wrapperTx = ContractUtil.parseContractTransaction(tx, this.chainManager);
            if (wrapperTx == null) {
                return ContractUtil.getSuccess();
            }
            Chain chain = this.contractHelper.getChain(chainId);
            BatchInfo batchInfo = chain.getBatchInfo();
            wrapperTx.setOrder(batchInfo.getAndIncreaseTxCounter());
            ContractData contractData = wrapperTx.getContractData();
            byte[] contractAddressBytes = contractData.getContractAddress();
            String contractAddress = AddressTool.getStringAddressByBytes((byte[])contractAddressBytes);
            ContractContainer container = batchInfo.newOrGetContractContainer(contractAddress);
            Result validResult = this.validContractTx(chainId, tx);
            if (validResult.isFailed()) {
                return validResult;
            }
            String preStateRoot = batchInfo.getPreStateRoot();
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            container.loadFutureList();
            Result result = this.contractCaller.callTx(chainId, container, batchExecutor, wrapperTx, preStateRoot);
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Log.error(e);
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
        catch (ExecutionException e) {
            Log.error(e);
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    @Override
    public Result invokeContractOneByOneV8(int chainId, ContractTempTransaction tx) {
        try {
            Log.info("[Invoke Contract] TxType is [{}], hash is [{}]", tx.getType(), tx.getHash().toString());
            tx.setChainId(chainId);
            ContractWrapperTransaction wrapperTx = ContractUtil.parseContractTransaction(tx, this.chainManager);
            if (wrapperTx == null) {
                return ContractUtil.getSuccess();
            }
            Chain chain = this.contractHelper.getChain(chainId);
            BatchInfoV8 batchInfo = chain.getBatchInfoV8();
            wrapperTx.setOrder(batchInfo.getAndIncreaseTxCounter());
            Result validResult = this.validContractTx(chainId, tx);
            if (validResult.isFailed()) {
                return validResult;
            }
            String preStateRoot = batchInfo.getPreStateRoot();
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            Result result = this.callTx(chainId, batchExecutor, wrapperTx, preStateRoot, batchInfo);
            if (result.isSuccess()) {
                HashMap _result = new HashMap();
                Map map = (Map)result.getData();
                _result.put("success", map.get("success"));
                _result.put("gasUsed", map.get("gasUsed"));
                _result.put("txList", map.get("txList"));
                return result.setData(_result);
            }
            return result;
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    @Override
    public Result invokeContractOneByOneV14(int chainId, ContractTempTransaction tx) {
        try {
            Log.info("[Invoke Contract] TxType is [{}], hash is [{}]", tx.getType(), tx.getHash().toString());
            tx.setChainId(chainId);
            ContractWrapperTransaction wrapperTx = ContractUtil.parseContractTransaction(tx, this.chainManager);
            if (wrapperTx == null) {
                return ContractUtil.getSuccess();
            }
            Chain chain = this.contractHelper.getChain(chainId);
            BatchInfoV8 batchInfo = chain.getBatchInfoV8();
            wrapperTx.setOrder(batchInfo.getAndIncreaseTxCounter());
            Result validResult = this.validContractTx(chainId, tx);
            if (validResult.isFailed()) {
                return validResult;
            }
            String preStateRoot = batchInfo.getPreStateRoot();
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            Result result = this.callTxV14(chainId, batchExecutor, wrapperTx, preStateRoot, batchInfo);
            if (result.isSuccess()) {
                HashMap _result = new HashMap();
                Map map = (Map)result.getData();
                _result.put("success", map.get("success"));
                _result.put("gasUsed", map.get("gasUsed"));
                _result.put("txList", map.get("txList"));
                return result.setData(_result);
            }
            return result;
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    @Override
    public Result invokeContractOneByOneV22(int chainId, ContractTempTransaction tx) {
        try {
            Log.info("[Invoke Contract] TxType is [{}], hash is [{}]", tx.getType(), tx.getHash().toString());
            tx.setChainId(chainId);
            ContractWrapperTransaction wrapperTx = ContractUtil.parseContractTransaction(tx, this.chainManager);
            if (wrapperTx == null) {
                return ContractUtil.getSuccess();
            }
            Chain chain = this.contractHelper.getChain(chainId);
            BatchInfoV8 batchInfo = chain.getBatchInfoV8();
            wrapperTx.setOrder(batchInfo.getAndIncreaseTxCounter());
            Result validResult = this.validContractTx(chainId, tx);
            if (validResult.isFailed()) {
                return validResult;
            }
            String preStateRoot = batchInfo.getPreStateRoot();
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            Result result = this.callTxV22(chainId, batchExecutor, wrapperTx, preStateRoot, batchInfo);
            if (result.isSuccess()) {
                HashMap _result = new HashMap();
                Map map = (Map)result.getData();
                _result.put("success", map.get("success"));
                _result.put("gasUsed", map.get("gasUsed"));
                _result.put("txList", map.get("txList"));
                return result.setData(_result);
            }
            return result;
        }
        catch (NulsException e) {
            Log.error(e);
            return Result.getFailed((ErrorCode)(e.getErrorCode() == null ? ContractErrorCode.FAILED : e.getErrorCode()));
        }
    }

    protected Result callTx(int chainId, ProgramExecutor batchExecutor, ContractWrapperTransaction tx, String preStateRoot, BatchInfoV8 batchInfo) {
        try {
            ContractData contractData = tx.getContractData();
            Integer blockType = Chain.currentThreadBlockType();
            byte[] contractAddressBytes = contractData.getContractAddress();
            String contract = AddressTool.getStringAddressByBytes((byte[])contractAddressBytes);
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            long blockTime = currentBlockHeader.getTime();
            long lastestHeight = currentBlockHeader.getHeight() - 1L;
            ContractTxCallableV8 txCallable = new ContractTxCallableV8(chainId, blockType, blockTime, batchExecutor, contract, tx, lastestHeight, preStateRoot);
            ContractResult contractResult = txCallable.call();
            batchInfo.getContractResultMap().put(tx.getHash().toString(), contractResult);
            Map<String, Object> result = this.extractDataFromContractResult(contractResult);
            batchInfo.getOfflineTxHashList().addAll((List)result.get("txHashList"));
            return ContractUtil.getSuccess().setData(result);
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed();
        }
    }

    protected Result callTxV14(int chainId, ProgramExecutor batchExecutor, ContractWrapperTransaction tx, String preStateRoot, BatchInfoV8 batchInfo) {
        try {
            ContractData contractData = tx.getContractData();
            Integer blockType = Chain.currentThreadBlockType();
            byte[] contractAddressBytes = contractData.getContractAddress();
            String contract = AddressTool.getStringAddressByBytes((byte[])contractAddressBytes);
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            long blockTime = currentBlockHeader.getTime();
            long lastestHeight = currentBlockHeader.getHeight() - 1L;
            ContractTxCallableV14 txCallable = new ContractTxCallableV14(chainId, blockType, blockTime, batchExecutor, contract, tx, lastestHeight, preStateRoot);
            ContractResult contractResult = txCallable.call();
            batchInfo.getContractResultMap().put(tx.getHash().toString(), contractResult);
            Map<String, Object> result = this.extractDataFromContractResult(contractResult);
            batchInfo.getOfflineTxHashList().addAll((List)result.get("txHashList"));
            return ContractUtil.getSuccess().setData(result);
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed();
        }
    }

    protected Result callTxV22(int chainId, ProgramExecutor batchExecutor, ContractWrapperTransaction tx, String preStateRoot, BatchInfoV8 batchInfo) {
        try {
            ContractData contractData = tx.getContractData();
            Integer blockType = Chain.currentThreadBlockType();
            byte[] contractAddressBytes = contractData.getContractAddress();
            String contract = AddressTool.getStringAddressByBytes((byte[])contractAddressBytes);
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            long blockTime = currentBlockHeader.getTime();
            long lastestHeight = currentBlockHeader.getHeight() - 1L;
            ContractTxCallableV22 txCallable = new ContractTxCallableV22(chainId, blockType, blockTime, batchExecutor, contract, tx, lastestHeight, preStateRoot);
            ContractResult contractResult = txCallable.call();
            batchInfo.getContractResultMap().put(tx.getHash().toString(), contractResult);
            Map<String, Object> result = this.extractDataFromContractResult(contractResult);
            batchInfo.getOfflineTxHashList().addAll((List)result.get("txHashList"));
            return ContractUtil.getSuccess().setData(result);
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed();
        }
    }

    protected Map<String, Object> extractDataFromContractResult(ContractResult contractResult) throws IOException {
        String newTx;
        ArrayList<byte[]> offlineTxHashList = new ArrayList<byte[]>();
        ArrayList<String> resultTxList = new ArrayList<String>();
        List<ProgramInvokeRegisterCmd> invokeRegisterCmds = contractResult.getInvokeRegisterCmds();
        for (ProgramInvokeRegisterCmd programInvokeRegisterCmd : invokeRegisterCmds) {
            if (!programInvokeRegisterCmd.getCmdRegisterMode().equals((Object)CmdRegisterMode.NEW_TX)) continue;
            ProgramNewTx programNewTx = programInvokeRegisterCmd.getProgramNewTx();
            String newTxHash = programNewTx.getTxHash();
            if (StringUtils.isNotBlank((String)newTxHash)) {
                offlineTxHashList.add(RPCUtil.decode((String)newTxHash));
            }
            if (!StringUtils.isNotBlank((String)(newTx = programNewTx.getTxString()))) continue;
            resultTxList.add(newTx);
        }
        List<ContractTransferTransaction> contractTransferList = contractResult.getContractTransferList();
        for (Transaction transaction : contractTransferList) {
            newTx = RPCUtil.encode((byte[])transaction.serialize());
            contractResult.getContractTransferTxStringList().add(newTx);
            resultTxList.add(newTx);
            offlineTxHashList.add(transaction.getHash().getBytes());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", contractResult.isSuccess());
        result.put("gasUsed", contractResult.getGasUsed());
        result.put("txList", resultTxList);
        result.put("txHashList", offlineTxHashList);
        return result;
    }

    @Override
    public Result beforeEnd(int chainId, long blockHeight) {
        try {
            Result result = this.contractCaller.callBatchEnd(chainId, blockHeight);
            return result;
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed();
        }
    }

    @Override
    public Result end(int chainId, long blockHeight) {
        try {
            BatchInfo batchInfo = this.contractHelper.getChain(chainId).getBatchInfo();
            Future<ContractPackageDto> future = batchInfo.getContractPackageDtoFuture();
            future.get();
            ContractPackageDto dto = batchInfo.getContractPackageDto();
            if (dto == null) {
                return ContractUtil.getFailed();
            }
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            Result<byte[]> batchExecuteResult = this.contractExecutor.commitBatchExecute(batchExecutor);
            byte[] stateRoot = (byte[])batchExecuteResult.getData();
            currentBlockHeader.setStateRoot(stateRoot);
            dto.setStateRoot(stateRoot);
            return ContractUtil.getSuccess().setData((Object)dto);
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
    }

    @Override
    public Result packageEnd(int chainId, long blockHeight) {
        try {
            BatchInfo batchInfo = this.contractHelper.getChain(chainId).getBatchInfo();
            ContractPackageDto dto = batchInfo.getContractPackageDto();
            if (dto == null) {
                long beforeEndTime = batchInfo.getBeforeEndTime();
                long now0 = System.currentTimeMillis();
                long timeOut = 1200L - (now0 - beforeEndTime);
                if (timeOut <= 0L) {
                    Log.warn("Exceeded the reserved timeout period[0]: {}", timeOut);
                } else {
                    Log.info("Reserved timeout[0]: {}", timeOut);
                    Future<ContractPackageDto> future = batchInfo.getContractPackageDtoFuture();
                    try {
                        future.get(timeOut, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        Log.error("wait end time out[0]", e.getMessage());
                    }
                    dto = batchInfo.getContractPackageDto();
                    if (dto == null) {
                        Map<String, Future<ContractResult>> contractMap;
                        long now1 = System.currentTimeMillis();
                        Log.info("Time spent for the first time: {}", now1 - beforeEndTime);
                        if (batchInfo.isExceed() && !(contractMap = batchInfo.getContractMap()).isEmpty()) {
                            Set<Map.Entry<String, Future<ContractResult>>> entries = contractMap.entrySet();
                            int count = 0;
                            for (Map.Entry<String, Future<ContractResult>> entry : entries) {
                                String hash = entry.getKey();
                                Future<ContractResult> _future = entry.getValue();
                                if (_future.isDone()) continue;
                                _future.cancel(true);
                                batchInfo.addPendingTxHashList(hash);
                                ++count;
                            }
                            Log.warn("Exceeding the block contractgasperhapstxCountLimit and interrupt the number of unfinished transactions: {}", count);
                        }
                        long now2 = System.currentTimeMillis();
                        timeOut = 1500L - (now2 - beforeEndTime);
                        Log.info("Reserved timeout[1]: {}", timeOut);
                        if (timeOut <= 0L) {
                            Log.warn("Exceeded the reserved timeout period[1]: {}", timeOut);
                        } else {
                            future.get();
                            Log.info("triggerENDperiod - Time spent on contract execution: {}", System.currentTimeMillis() - beforeEndTime);
                        }
                    }
                }
            }
            if (dto == null) {
                return ContractUtil.getFailed();
            }
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            long s = 0L;
            if (Log.isDebugEnabled()) {
                s = System.currentTimeMillis();
            }
            Result<byte[]> batchExecuteResult = this.contractExecutor.commitBatchExecute(batchExecutor);
            if (Log.isDebugEnabled()) {
                long e = System.currentTimeMillis();
                Log.debug("Contract submission persistence timecost: {}", e - s);
            }
            byte[] stateRoot = (byte[])batchExecuteResult.getData();
            currentBlockHeader.setStateRoot(stateRoot);
            dto.setStateRoot(stateRoot);
            return ContractUtil.getSuccess().setData((Object)dto);
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
    }

    @Override
    public Result endV8(int chainId, long blockHeight) {
        try {
            BatchInfoV8 batchInfo = this.contractHelper.getChain(chainId).getBatchInfoV8();
            BlockHeader currentBlockHeader = batchInfo.getCurrentBlockHeader();
            ProgramExecutor batchExecutor = batchInfo.getBatchExecutor();
            Result<byte[]> batchExecuteResult = this.contractExecutor.commitBatchExecute(batchExecutor);
            byte[] stateRoot = (byte[])batchExecuteResult.getData();
            currentBlockHeader.setStateRoot(stateRoot);
            ArrayList<String> txList = new ArrayList<String>();
            ContractReturnGasTransaction returnGasTx = this.contractHelper.makeReturnGasTx(new ArrayList<ContractResult>(batchInfo.getContractResultMap().values()), batchInfo.getCurrentBlockHeader().getTime());
            if (returnGasTx != null) {
                txList.add(RPCUtil.encode((byte[])returnGasTx.serialize()));
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("stateRoot", HexUtil.encode((byte[])stateRoot));
            result.put("txList", txList);
            return ContractUtil.getSuccess().setData(result);
        }
        catch (Exception e) {
            Log.error(e);
            return ContractUtil.getFailed().setMsg(e.getMessage());
        }
    }

    @Override
    public Result packageEndV8(int chainId, long blockHeight) {
        return this.endV8(chainId, blockHeight);
    }

    @Override
    public Result saveContractExecuteResult(int chainId, NulsHash hash, ContractResult result) {
        if (hash == null || result == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        return this.contractExecuteResultStorageService.saveContractExecuteResult(chainId, hash, result);
    }

    @Override
    public Result deleteContractExecuteResult(int chainId, NulsHash hash) {
        if (hash == null) {
            return Result.getFailed((ErrorCode)ContractErrorCode.NULL_PARAMETER);
        }
        return this.contractExecuteResultStorageService.deleteContractExecuteResult(chainId, hash);
    }

    @Override
    public ContractResult getContractExecuteResult(int chainId, NulsHash hash) {
        if (hash == null) {
            return null;
        }
        return this.contractExecuteResultStorageService.getContractExecuteResult(chainId, hash);
    }

    @Override
    public Result<ContractOfflineTxHashPo> getContractOfflineTxHashList(Integer chainId, String blockHash) throws NulsException {
        return this.contractOfflineTxHashListStorageService.getOfflineTxHashList(chainId, RPCUtil.decode((String)blockHash));
    }
}

